 /** 
/* PangaeaExpt1Node.java
 *
 * Create Practi URANode and Overlog Engine, and a PangaeaFS (local interface)
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
 **/ 

import java.io.*;
import java.util.*;

public class PangaeaExpt1Node extends URAOverlogNode{


  

  private final static boolean dbg = true;
  //private static final boolean PRINT_METHODS = false;
 
  private int goldNum; 
  HashSet objCache;
  
  
  long readCount, readTime, lastReadTime, firstReadTime;

  final static long primary = 0;
  static final long FILESIZE = 1;
  static final int WRITENUM = 10;
  final PangaeaLocalInterface pli;

  
  public PangaeaExpt1Node(String configPath, 
                               String p2ConfigPath, 
                               NodeId nodeId,
                               boolean cleanDb,
                               String overlogPath,
                               String nodeMapPath,
			  boolean noSyncLog,
			  int goldNum){
    
    super(configPath, p2ConfigPath, nodeId, cleanDb, overlogPath, nodeMapPath, noSyncLog);
    super.getP2Runtime().getCore().setCatchupTypeToCP(true);//set the catchup type to be CP
    

    Env.dprintln(dbg, "creating PangaeaExpt1Node");
    pli = new PangaeaLocalInterface(li, nodeId);
    //pfs = new PangaeaFS(pli,
    //                    overlogPolicy, nodeId.equals(new NodeId(primary)));
    //Env.dprintln(dbg, "creating PangaeaFS done");
    //overlogPolicy.registerHandler(new GetGoldNodesHandler(pfs));
    // Env.dprintln(dbg, "creating PangaeaFS done 1");
    //overlogPolicy.registerHandler(new InformGoldNodeHandler(pfs));
    //Env.dprintln(dbg, "creating PangaeaFS done 2");
    //overlogPolicy.registerHandler(new ReplaceDeadGoldHandler(pfs));  
    if(dbg){
      System.out.println("PangaeaExpt1Node( " + configPath + ", "
                         + p2ConfigPath + ", "
                         + nodeId + ", "
                         + overlogPath + ", "
                         + nodeMapPath + ") startts ...");
    }
    try{
      super.start();
    }catch(Exception e){
      e.printStackTrace();
      System.exit(1);
    }
    
    this.objCache = new HashSet();
    this.goldNum = goldNum;
    readCount = 0;
    readTime = 0;
    lastReadTime = 0;
    firstReadTime = 0;

  }

  public BodyMsg read(ObjId objId,
		      long offset,
		      long length)
    throws ObjNotFoundException, IOException,
	   EOFException, ReadOfHoleException{

    long start = System.currentTimeMillis();

    if(!objCache.contains(objId)){

      //in this experiment, only read when somebody has write
      //so here, to avoid get no object found exception
      // apply a fake invalidate
      ObjInvalTarget oit = new ObjInvalTarget(objId, 0, 1);
      AcceptStamp stamp = new AcceptStamp(0, new NodeId(primary));
      PreciseInv fakeInv = new PreciseInv(oit, stamp);
      super.getP2Runtime().getCore().applyInvalToDataStore(fakeInv);
      //this shouldn't be part of the read
      start = System.currentTimeMillis();
      //
      // The file exists in the directory file,
      // but the corresponding body has not arrived yet.
      // This means we need to create a new replica for this file.
      //
      String objIdStr = objId.toString();
      
      if(OverlogPolicy.UseP2VersionHasStringProblem){
	    assert !objId.toString().contains("-") :
	      "\"-\" is not allowed in ObjId because we are using the p2 version"
	      + "\nthat can't interpret \"/\" well and have to hack by replacing \"/\" with"
	      + "\n \"-\"."
	      + " If you are using a p2 version works with \"/\", turn off OverlogPolicy.UseP2VersionHasStringProblem";
	      
	      objIdStr = objId.toString().replaceAll("/", "-");
      }
       
      HashSet goldNodes = (HashSet) PangaeaFS.getGoldNodes(overlogPolicy, objId, goldNum);
      
      // handle meta object
      PangaeaFS.tellP2CreateNewReplica(overlogPolicy, objIdStr, goldNodes);
      
      objCache.add(objId);
      Env.dprintln(dbg, "add " + objIdStr + " to cache");
      
    }

    
    BodyMsg ret = pli.read(objId, offset, length);

    long end = System.currentTimeMillis();
    readCount++;
    lastReadTime = (end-start);
    readTime+= lastReadTime;
    if(firstReadTime == 0){
      firstReadTime = lastReadTime;
    }
    return ret;
    
  }
	   
 /** 
 *  Write method 
 **/ 
  public long
    write(ObjId objId, long size)
    throws IOException {
     if(!objCache.contains(objId)){
       String objIdStr = objId.toString();
       
       if(OverlogPolicy.UseP2VersionHasStringProblem){
	 assert !objId.toString().contains("-") :
	   "\"-\" is not allowed in ObjId because we are using the p2 version"
	   + "\nthat can't interpret \"/\" well and have to hack by replacing \"/\" with"
	   + "\n \"-\"."
	      + " If you are using a p2 version works with \"/\", turn off OverlogPolicy.UseP2VersionHasStringProblem";
	   
	   objIdStr = objId.toString().replaceAll("/", "-");
       }
       
       HashSet goldNodes = (HashSet) PangaeaFS.getGoldNodes(overlogPolicy, objId, goldNum);
       PangaeaFS.tellP2CreateNewObj(overlogPolicy, objIdStr, goldNodes);
       objCache.add(objId);
       Env.dprintln(dbg, "add " + objIdStr + " to cache");
     }
    ImmutableBytes buffer = URANode.populateByteArray(size);
    return pli.write(objId, 0, size, buffer.dangerousGetReferenceToInternalByteArray());
  }

  public void populateWrite(){
    try{
      this.write(new ObjId("/first"), FILESIZE);
      for(int i = 0; i < WRITENUM; i++){
	try{
	  Thread.sleep(20);//quience
	}catch(InterruptedException e){
	  //ignore
	}
	this.write(new ObjId("/"+i), FILESIZE);
      }
    }catch(Exception e){
      Env.dprintln(dbg, "write get " +e.toString());
    }
    super.getP2Runtime().getCore().syncStateToDisk();
  }
  
  public void startRead(){
    try{
      this.read(new ObjId("/first"), 0, 1);
      for(int i = WRITENUM-1; i >=0; i--){
	try{
	  Thread.sleep(5000);//quience
	}catch(InterruptedException e){
	  //ignore
	}
	this.read(new ObjId("/"+i), 0, 1);
      }
    }catch(Exception e){
      Env.dprintln(dbg, "read get " +e.toString());
    }
  }

  public void userInterface(InputStream is){
    boolean dbgWriteScript = false;
    
    long accumulatedTimeMillis = 0;
    long nextWriteExpectedTime = System.currentTimeMillis();
    long startTime = System.currentTimeMillis();
    long writeNum = 0;

    Env.printDebug("Enter action:  ");
    Env.printDebug("Comments       : c [comments]");
    Env.printDebug("write          : w [ObjId] [size]");
    Env.printDebug("read           : r [ObjId]");
    Env.printDebug("avgtime        : t ");
    Env.printDebug("end            : e");

    BufferedReader din = null;
		
    try{
	    		
      din = new BufferedReader(new InputStreamReader(is));
		
	    
      String input;
      for(input = din.readLine(); input!= null; input=din.readLine()) {
        
        System.err.println("Input : " + input);
        byte[] action = input.getBytes();
		
        if(action[0] == 'w'){
          writeNum++;
          StringTokenizer st = new StringTokenizer(input.substring(2));
          ObjId objId = new ObjId(st.nextToken());
          
	  
	  long len = new Long(st.nextToken()).longValue();
	  ///Env.dprintln(dbg, " to write to object " + objId.toString()+ ":" + str);
	  try{
	    //PRACTIFileOutputStream pos = new PRACTIFileOutputStream(this.pli, objId);
	    //ObjectOutputStream oos = new ObjectOutputStream(pos);
	    //setup the tree: mazzola  --> rossi --> boniperti
	  
	    this.write(objId, len);
	    
	  }catch(Exception e){
	    e.printStackTrace();
	    //continue
	  }
		    
        } else if (action[0] == 'r'){//blockRead send READ_DONE at the end
	  StringTokenizer st = new StringTokenizer(input.substring(2));
          ObjId objId = new ObjId(st.nextToken());
                
          try{
	    
	    BodyMsg readValue=this.read(objId, 0, 1);
	    Env.dprintln(dbg, "read object " + readValue + " takes: " + lastReadTime);
	    
          }catch(Exception e){
            //
            // ObjNotFoundException or EOFException
            //
	    e.printStackTrace();
	    //continue;
          }
                    
        } else if (action[0] == 's'){
          this.startRead();
	  long avg = 0;
	  if(readCount >1){
	    avg = (readTime-firstReadTime)/(readCount-1);
	  }
	  Env.dprintln(dbg, " so far avg = " + avg);
	  
        } else if (action[0] == 'p'){
	  this.populateWrite();
	  
          // Do nothing
        } else if (action[0] == 't'){
          // Do nothing
	  long avg = 0;
	  if(readCount >1){
	    avg = (readTime-firstReadTime)/(readCount-1);
	  }
	  Env.dprintln(dbg, " so far avg = " + avg);
        }  
	
      }//for
    } catch (Exception e){
      e.printStackTrace();
      Env.printDebug("Wrong input format ...");
    }	
  }
  
  public static void main(String[] argv)
    throws Exception{
    //create the config file for expt1
    boolean cleanDB = false;
    if(argv[2].equals("true")){
      cleanDB = true;
    }

    String olgFile = "case-studies/Pangaea/expt1/PangaeaExpt1_png.olg";
    if((argv.length>3)&&argv[3].equals("r")){
	olgFile = "case-studies/Pangaea/expt1/PangaeaExpt1_random.olg";
    }
    String prefix = "test"+File.separatorChar + "tmp.pfsexpt1";
    CreateConfigForExpt1.makeConfigs(prefix);
    PangaeaExpt1Node uraNode = new PangaeaExpt1Node(prefix+".config",
						    prefix+".p2config",
						    new NodeId(new Long(argv[0]).longValue()),
						    cleanDB,
						    olgFile,
						    prefix+".map", false,
						    new Integer(argv[1]).intValue());
    Env.dprintln(dbg, "uraNode created");
    uraNode.userInterface(System.in);
    
  }

  
}

 /** 
/* $Log: PangaeaExpt1Node.java,v $
/* Revision 1.1  2007/04/02 21:11:39  zjiandan
/* snapshort for sosp2007.
/**/
 **/ 
