 /** 
/* PangaeaP2Synchronizer.java
 *
 *  Store and retrieve persistent tuple in PRACTI for p2
 *    
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
 **/ 

import java.io.*;
import java.util.*;

public class PRACTIP2Interface{
  OverlogPolicy op;
  PRACTIFSLocalInterface li;
  static final int BLOCK_SIZE = 1000;
  static final long WATCH_TIMEOUT = 100000;//1 sec
  static final boolean dbg = false;
  static final boolean NO_COLON_IN_OBJID = true;
  
  public PRACTIP2Interface(PRACTIFSLocalInterface pli, OverlogPolicy op){
    this.op = op;
    this.li = pli;
    op.registerHandler(new PRACTIReadAndWatchTupleHandler(this));
    //op.registerHandler(new PRACTIReadTupleHandler(this));
    //op.registerHandler(new PRACTIWriteTupleHandler(this));
    //tbd register the other handlers.
  }
  
  public void practiReadAndWatch(String ObjIdName){
    PRACTIFileInputStream pis = null;
    ObjectInputStream ois = null;
    if(NO_COLON_IN_OBJID){
      ObjIdName = ObjIdName.replace(":", ".");
    }
    try{
      
      pis = new PRACTIFileInputStream(li, new ObjId(ObjIdName), BLOCK_SIZE);
      ois = new ObjectInputStream(pis);
    }catch(FileNotFoundException e){
      Env.dprintln(dbg, "PRACTIP2Interface::practiReadAndWatch(" + ObjIdName + ") file not found, do nothing");
      return;
    }catch(IOException ee){
      Env.dprintln(dbg, "PRACTIP2Interface:practiReadAndWatch(" + ObjIdName + " ) failed because of IOException");
      ee.printStackTrace();//report failed
      return;
    }
    String tupleStr = null;
    Tuple tp = null;
    while(true){
      
      try{
	tupleStr = (String) (ois.readObject());
	String[] tpStrs = tupleStr.split(" ");
	String[] tpStrs2= new String[tpStrs.length+1];
	tpStrs2[0] = tpStrs[0];
	tpStrs2[1] = op.getMyOverlogId().toString();
	
	for (int i = 2; i < tpStrs2.length; i ++){
	  tpStrs2[i] = tpStrs[i-1];
	}
	tp = new Tuple(tpStrs2);
	Env.dprintln(dbg, "PRACTIP2Interface::practiReadAndWatch() insert tuple: " + tp.toString());
	op.insertTuple(tp);
      }catch(EOFException e){
	Env.dprintln(dbg, "PRACTIP2Interface::practiReadAndWatch():EOFException "
		     + "going to sleep for a while");
	//tbd: watch the insert event from li and invalidate
	try{
	  Thread.sleep(WATCH_TIMEOUT);
	}catch(InterruptedException ee){
	  Env.dprintln(dbg, "PRACTIP2Interface::practiReadAndWatch():sleep interrupted");
	}
      }catch(Exception ee){
	Env.dprintln(dbg, "PRACTIP2Interface:practiReadAndWatch(" + ObjIdName + " ) failed because of IOException");
	ee.printStackTrace();//report failed
	return;
      }
    }
  }
  
  
  public void readTupleForP2(String ObjIdName){
    
    PRACTIFileInputStream pis = null;
    ObjectInputStream ois = null;
    try{
      pis = new PRACTIFileInputStream(li, new ObjId(ObjIdName), BLOCK_SIZE);
      ois = new ObjectInputStream(pis);
    }catch(FileNotFoundException e){
      Env.dprintln(dbg, "PRACTIP2Interface::readTupleForP2(" + ObjIdName + ") file not found, do nothing");
      return;
    }catch(Exception ee){
      Env.dprintln(dbg, "PRACTIP2Interface:practiReadAndWatch(" + ObjIdName + " ) failed because of IOException");
      ee.printStackTrace();//report failed
      return;
    }  
    String tupleStr = null;
    Tuple tp = null;
    while(true){
      
      try{
	tupleStr = (String) (ois.readObject());
	String[] tpStrs = tupleStr.split(" ");
	String[] tpStrs2= new String[tpStrs.length+1];
	tpStrs2[0] = tpStrs[0];
	tpStrs2[1] = op.getMyOverlogId().toString();
      
	for (int i = 2; i < tpStrs2.length; i ++){
	  tpStrs2[i] = tpStrs[i-1];
	}
	tp = new Tuple(tpStrs2);
	Env.dprintln(dbg, "PRACTIP2Interface::readTupleForP2() insert tuple: " + tp.toString());
	op.insertTuple(tp);
      }catch(EOFException e){
	break;
      }catch(Exception ee){
	Env.dprintln(dbg, "PRACTIP2Interface:practiReadAndWatch(" + ObjIdName + " ) failed because of IOException");
	ee.printStackTrace();//report failed
	return;
      }
    }
  }
  
  void writeTupleForP2(String ObjIdName, String tuple){
    assert false; //not implemented yet
    /*
    s = new ObjectOutputStream(li, ObjIdName);
    s. writeObject(tuple);
    */
  }

  void clearTupleForP2(String ObjIdName){
    assert false; //not implemented yet
    /*
    li.delete(ObjIdName);
    */
}

  void readThenClearTupleForP2(String objIdName){
    assert false; //not implemented yet
    /*
    this.readTupleForP2(objIdName);
    li.delete(ObjIdName);
    */
  }
}