 /** 
/* PRACTIReadAndWatchTupleHandler.java
 *
 * Handle "practiReadAndWatch(ME, ObjId)" Tuple received from P2 
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
 **/ 

public class PRACTIReadAndWatchTupleHandler extends TupleHandler{
  static final boolean sanityCheck = true;
  PRACTIP2Interface pfs;
  public PRACTIReadAndWatchTupleHandler(PRACTIP2Interface pfs){
    super("practiReadAndWatch");
    this.pfs = pfs;
  }

  public void handleTuple(Tuple tp)
    throws MalformedTupleException{
    if(tp.getLength() != 3) {
      throw new MalformedTupleException("tp=" + tp);
    }
    //assert tp.getItem(1)== myoverlogid;
    String objIdStr = tp.getItem(2);

    if(OverlogPolicy.P2VersionHasStringProblem){
      objIdStr = objIdStr.replace("-", "/");
    }

    pfs.practiReadAndWatch(objIdStr);
  }
}

 /** 
/* $Log: PRACTIReadAndWatchTupleHandler.java,v $
/* Revision 1.3  2007/09/12 19:08:39  nalini
/* upgraded to p2-0.8.2
/*
/* Revision 1.2  2007/03/02 03:09:24  zjiandan
/* nothing major, just to sync with other nodes.
/*
/* Revision 1.1  2007/03/02 01:35:29  zjiandan
/* Yeah! Working Simplified TierStore.
/* */
 **/ 
