 /** 
 *  Local interface created for TierStoreFS 
 **/ 
import java.util.HashMap;
import java.util.Arrays;
import java.util.Map;
import java.util.Iterator;
import java.io.IOException;
import java.io.EOFException;

public class TierStoreLocalInterface extends PRACTIFSLocalInterface{

 /** 
 *  Data members 
 **/ 
  

 /** 
 *  Constructor 
 **/ 
  public
  TierStoreLocalInterface(LocalInterface li, NodeId myNodeId){
    super(li, myNodeId, true);//bound = true
  }

 /** 
 *  Constructor 
 **/ 
  public
  TierStoreLocalInterface(PRACTIFSLocalInterface li, NodeId myNodeId){
    super(li, myNodeId);
  }

 /** 
 *  Read from an object  
 *  TierStore sepcific parameters: 
 *      blockValid = true; blockPrecise = false 
 **/ 
  public synchronized BodyMsg
  read(ObjId objId,
       long offset,
       long length)
    throws ObjNotFoundException, IOException,
	   EOFException, ReadOfHoleException{
    BodyMsg result = null;

    try{
      result = this.li.read(objId,
                            offset,
                            length,
                            false,//blockValid
                            false);//blockPrecise
    }catch(ReadOfInvalidRangeException rire){
      throw new ObjNotFoundException(rire.toString());
    }
    return(result);
  }

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    Env.verifyAssertEnabled();
    System.out.println("Testing TierStoreLocalInterface.java...");
    TierStoreLocalInterface.testSimple();
    System.out.println("...TierStoreLocalInterface.java");
    System.exit(0);
  }

 /** 
 *  Used for testing 
 **/ 
  private static void
  testSimple(){
    TierStoreLocalInterface li = null;
    FakePRACTIFSLocalInterface fakeLI = null;
    PRACTIFSReadLockToken readToken = null;
    PRACTIFSWriteLockToken writeToken = null;

    fakeLI = new FakePRACTIFSLocalInterface(new NodeId(1));
    li = new TierStoreLocalInterface(fakeLI, new NodeId(1));
    try{
      // Try one objId
      readToken = li.acquireReadLock(new ObjId("a"));
      assert(readToken.getObjId().equals(new ObjId("a")));
      assert(readToken.isAcquired());
      li.releaseReadLock(readToken, new ObjId("a"));
      assert(!readToken.isAcquired());
      writeToken = li.acquireWriteLock(new ObjId("a"));
      assert(writeToken.getObjId().equals(new ObjId("a")));
      assert(writeToken.isAcquired());
      li.releaseWriteLock(writeToken, new ObjId("a"));
      assert(!writeToken.isAcquired());

      // Try two objIds
      readToken = li.acquireReadLock(new ObjId("a"));
      assert(readToken.getObjId().equals(new ObjId("a")));
      assert(readToken.isAcquired());
      writeToken = li.acquireWriteLock(new ObjId("b"));
      assert(writeToken.getObjId().equals(new ObjId("b")));
      assert(writeToken.isAcquired());
      li.releaseWriteLock(writeToken, new ObjId("b"));
      li.releaseReadLock(readToken, new ObjId("a"));
    }catch(InterruptedException e){
      System.err.println("" + e);
    }
  }
}
 /** 
/* $Log: TierStoreLocalInterface.java,v $
/* Revision 1.1  2007/03/02 01:35:29  zjiandan
/* Yeah! Working Simplified TierStore.
/* */
 **/ 
