 /** 
/* TierStoreURAOverlogNode.java
 *
 * Create Practi URANode and Overlog Engine, and a TierStoreFS (local interface)
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
 **/ 

import java.io.*;
import java.util.*;

public class TierStoreURAOverlogNode extends URAOverlogNode{
  final static long primary = 0;
  final static boolean dbg = true;
  final TierStoreFS pfs;
  final PRACTIP2Interface ppi;
  TierStoreLocalInterface tli;
  public TierStoreURAOverlogNode(String configPath, 
                               String p2ConfigPath, 
                               NodeId nodeId,
                               boolean cleanDb,
                               String overlogPath,
                               String nodeMapPath,
			       boolean noSyncLog){
    
    super(configPath, p2ConfigPath, nodeId, cleanDb, overlogPath, nodeMapPath, noSyncLog);
    Env.dprintln(dbg, "creating TierStoreFS");
    tli = new TierStoreLocalInterface(li, nodeId);
    initConfig();
    pfs = new TierStoreFS(tli,
			  overlogPolicy, nodeId.equals(new NodeId(primary)));
    ppi = new PRACTIP2Interface(tli, overlogPolicy);
    Env.dprintln(dbg, "creating TierStoreFS done");
    //overlogPolicy.registerHandler(new GetGoldNodesHandler(pfs));
    // Env.dprintln(dbg, "creating TierStoreFS done 1");
    
    
    
    if(dbg){
      System.out.println("TierStoreURAOverlogNode( " + configPath + ", "
                         + p2ConfigPath + ", "
                         + nodeId + ", "
                         + overlogPath + ", "
                         + nodeMapPath + ") starts ...");
    }
    try{
      super.start();
    }catch(Exception e){
      e.printStackTrace();
      System.exit(1);
    }

  }

  public TierStoreFS getFS(){
    return pfs;
  }
  public TierStoreLocalInterface getTLI(){
    return this.tli;
  }

  public void userInterface(InputStream is){
    boolean dbgWriteScript = false;
    
    long accumulatedTimeMillis = 0;
    long nextWriteExpectedTime = System.currentTimeMillis();
    long startTime = System.currentTimeMillis();
    long writeNum = 0;

    Env.printDebug("Enter action:  ");
    Env.printDebug("Comments       : c [comments]");
    Env.printDebug("write          : w [ObjId] [String]");
    Env.printDebug("GetAcceptStamp : r [ObjId] [String]");
    Env.printDebug("end            : e");

    BufferedReader din = null;
		
    try{
	    		
      din = new BufferedReader(new InputStreamReader(is));
		
	    
      String input;
      for(input = din.readLine(); input!= null; input=din.readLine()) {
        
        System.err.println("Input : " + input);
        byte[] action = input.getBytes();
		
        if(action[0] == 'w'){
          writeNum++;
          StringTokenizer st = new StringTokenizer(input.substring(2));
          ObjId objId = new ObjId(st.nextToken());
          String str = "";
	  while(st.hasMoreElements()){
	    str = str+st.nextToken();
	    str += " ";
	  }
	  str.trim();
         
	  Env.dprintln(dbg, "str to write to object " + objId.toString()+ ":" + str);
	  try{
	    PRACTIFileOutputStream pos = new PRACTIFileOutputStream(this.tli, objId);
	    ObjectOutputStream oos = new ObjectOutputStream(pos);
	    //setup the tree: mazzola  --> rossi --> boniperti
	  
	    oos.writeObject(str);
	    oos.flush();
	  }catch(Exception e){
	    e.printStackTrace();
	    //continue
	  }
		    
        } else if (action[0] == 'r'){//blockRead send READ_DONE at the end
	  StringTokenizer st = new StringTokenizer(input.substring(2));
          ObjId objId = new ObjId(st.nextToken());
          String str = "";
	  
          PRACTIFileInputStream pis = null;
          ObjectInputStream ois = null;
          try{
	    pis = new PRACTIFileInputStream(this.tli, objId, 1000);
	    ois = new ObjectInputStream(pis);
	    
	    str = (String)(ois.readObject());
	    
	    Env.dprintln(dbg, "read object " + objId.toString() + " :" + str);
	    
          }catch(Exception e){
            //
            // ObjNotFoundException or EOFException
            //
	    e.printStackTrace();
	    //continue;
          }
                    
        } else if (action[0] == 'e'){
          System.exit(-1);

       
        } else if (action[0] == 'c'){
          // Do nothing
        } 
      }//for
    } catch (Exception e){
      e.printStackTrace();
      Env.printDebug("Wrong input format ...");
    }	
  }

  private void initConfig(){
    try{
    //tbd: move this to TierStoreConfig.java
    PRACTIFileOutputStream pos = new PRACTIFileOutputStream(this.tli, new ObjId("/subscriptionTree/children/rossi.csres.utexas.edu.5000"));
    ObjectOutputStream oos = new ObjectOutputStream(pos);
    //setup the tree: mazzola  --> rossi --> boniperti
    String str = "children rossi.csres.utexas.edu:5000 boniperti.csres.utexas.edu:5001";
    oos.writeObject(str);
    oos.flush();

    pos = new PRACTIFileOutputStream(this.tli, new ObjId("/subscriptionTree/children/mazzola.csres.utexas.edu.5002"));
    oos = new ObjectOutputStream(pos);
    str = "children mazzola.csres.utexas.edu:5002 rossi.csres.utexas.edu:5000";
    oos.writeObject(str);
    oos.flush();

    pos = new PRACTIFileOutputStream(this.tli, new ObjId("/subscriptionTree/parent/rossi.csres.utexas.edu.5000"));
    oos = new ObjectOutputStream(pos);
    str = "parent rossi.csres.utexas.edu:5000 mazzola.csres.utexas.edu:5002";
    oos.writeObject(str);
    oos.flush();

    pos = new PRACTIFileOutputStream(this.tli, new ObjId("/subscriptionTree/parent/boniperti.csres.utexas.edu.5001"));
    oos = new ObjectOutputStream(pos);
    str = "parent boniperti.csres.utexas.edu:5001 rossi.csres.utexas.edu:5000";
    oos.writeObject(str);
    oos.flush();

    pos = new PRACTIFileOutputStream(this.tli, new ObjId("/subscriptionTree/subscribe/boniperti.csres.utexas.edu.5001"));
    oos = new ObjectOutputStream(pos);
    str = "subscribeItems helloWorld";
    oos.writeObject(str);
    str = "subscribeItems nfsroot";
    oos.writeObject(str);
    oos.flush();

    pos = new PRACTIFileOutputStream(this.tli, new ObjId("/subscriptionTree/subscribe/rossi.csres.utexas.edu.5000"));
    oos = new ObjectOutputStream(pos);
    str = "subscribeItems helloWorld";
    oos.writeObject(str);
    str = "subscribeItems nfsroot";
    oos.writeObject(str);
    oos.flush();
    
    pos = new PRACTIFileOutputStream(this.tli, new ObjId("/subscriptionTree/subscribe/mazzola.csres.utexas.edu.5002"));
    oos = new ObjectOutputStream(pos);
    str = "subscribeItems helloWorld-*";
    oos.writeObject(str);
    str = "subscribeItems nfsroot-*";
    oos.writeObject(str);
    oos.flush();
    Env.dprintln(dbg, "populate cofig finished");
    }catch(Exception e){
      e.printStackTrace();
      System.exit(-1);
    }
  }
  public static void main(String[] argv)
  throws Exception{
    TierStoreURAOverlogNode uraNode = new TierStoreURAOverlogNode("test/tfs_rossi_boniperti.config",
								  "test/tfs_rossi_boniperti.p2config",
								  new NodeId(0),
								  true,
								  // "case-studies/TierStore/TierStore.olg",
								  "case-studies/TierStore/TierStore.olg",
								  
								  "test/tfs_rossi_boniperti.map", false);
    Env.dprintln(dbg, "uraNode created");
    
    uraNode.userInterface(System.in);
    
    
  }
}

 /** 
/* $Log: TierStoreURAOverlogNode.java,v $
/* Revision 1.3  2007/03/02 08:55:41  zjiandan
/* dadah! hello world!
/*
/* Revision 1.2  2007/03/02 03:09:24  zjiandan
/* nothing major, just to sync with other nodes.
/*
/* Revision 1.1  2007/03/02 01:35:29  zjiandan
/* Yeah! Working Simplified TierStore.
/* */
 **/ 
