 /** 
/*  TierStoreExp1_PopulateDB
 * 
 *  Populates DB  based on the parameters specified in TierStoreExp1_Constants
 *  Populates it with bound writes
 * 
 * (C) Copyright 2007 -- See the file COPYRIGHT for additional details
 */
 **/ 

import java.io.*;

public class TierStoreExp1_2_PopulateDb {

  static final String CONFIG_PATH = TierStoreExp1_Constants.CONFIG_PATH;
  static final String P2_CONFIG_PATH = TierStoreExp1_Constants.P2_CONFIG_PATH;
  static final String OVERLOG_PATH = TierStoreExp1_Constants.OVERLOG_PATH;
  static final String NODEMAP_PATH = TierStoreExp1_Constants.NODEMAP_PATH;
  static final String DBPREFIX_POPULATED = TierStoreExp1_Constants.DBPREFIX_POPULATED;
  static final String DBPREFIX_DEFAULT = TierStoreExp1_Constants.DBPREFIX_DEFAULT;
  static final String PUBLICATION_PREFIX = TierStoreExp1_Constants.PUBLICATION_PREFIX;
  static final String PUB_ID = TierStoreExp1_Constants.PUB_ID;

  static final int NUM_OBJS = TierStoreExp1_Constants.NUM_OBJS;
  static final int SIZE_OF_OBJS = TierStoreExp1_Constants.SIZE_OF_OBJS;
  static final byte value = 65;

  private URAOverlogNode node;
  private LocalInterface li;
  

 /** 
 *  Constructor 
 **/ 


  public TierStoreExp1_2_PopulateDb() {
    
    node = new URAOverlogNode(CONFIG_PATH, 
                              P2_CONFIG_PATH,
                              new NodeId(1),
                              true,
                              OVERLOG_PATH,
                              NODEMAP_PATH,
                              false);

    li = node.getLocalInterface();
  }
 
 /** 
 *   Starts the node w/o starting the overlog 
 **/ 
   
  public synchronized void startNode() throws Exception{
    //start node without overlog
    node.start(true);
    wait(2000);
  }

 /** 
 *  shutdown 
 **/ 
   
  public synchronized void shutdown() throws Exception{
    node.shutdown();
  }
  

 /** 
 *   Converts values to byte arrays 
 **/ 

  private synchronized byte[] convertToArray(int size, byte value){
    byte[] b = new byte[size];
    for(int i = 0; i < size; i++) {
      b[i] = value;
    }
    return b;
  }


 /** 
 *   Writes <numObjects> of <b> to dir <path> 
 **/ 

  private void writeDir(String path, int numObjects, byte[] b){
    
    for(int i=0; i < numObjects; i++){
      ObjId objId = new ObjId(path + "/" + i);  
      System.out.println("Writing : " + objId);
      try{
        li.write(objId, 0, b.length, b, true);
      }catch(Exception e) {
        e.printStackTrace();
      }
    }
  }

 /** 
 *   populate DB 
 **/ 
  private void populateDB() {
    byte[] b = convertToArray(SIZE_OF_OBJS, value);
    
    writeDir(PUBLICATION_PREFIX + PUB_ID, NUM_OBJS, b);
  }

 /** 
 *  main method 
 **/ 

  public static void main(String[] args) {


    TierStoreExp1_2_PopulateDb exp = new TierStoreExp1_2_PopulateDb();

    try{ 
      exp.startNode();
      exp.populateDB();
      exp.shutdown();
    }catch(Exception e) {
      e.printStackTrace();
    }
    System.out.println("DB Population Ended"); 
    System.exit(0);
  }
}

 /** 
/* $Log: TierStoreExp1_2_PopulateDb.java,v $
/* Revision 1.1  2007/03/21 22:27:00  nalini
/* Added Tier Store exp
/*
*/
 **/ 
