public class TierStoreExp1_MakeConfig {


  final static String NODE_0_NAME=TierStoreExp1_Constants.NODE_0_NAME;
  final static String NODE_0_PORT=TierStoreExp1_Constants.NODE_0_PORT;
  final static String NODE_1_NAME=TierStoreExp1_Constants.NODE_1_NAME;
  final static String NODE_1_PORT=TierStoreExp1_Constants.NODE_1_PORT;
  final static String NODE_2_NAME=TierStoreExp1_Constants.NODE_2_NAME;
  final static String NODE_2_PORT=TierStoreExp1_Constants.NODE_2_PORT;
  final static String NODE_3_NAME=TierStoreExp1_Constants.NODE_3_NAME;
  final static String NODE_3_PORT=TierStoreExp1_Constants.NODE_3_PORT;
  final static String NODE_4_NAME=TierStoreExp1_Constants.NODE_4_NAME;
  final static String NODE_4_PORT=TierStoreExp1_Constants.NODE_4_PORT;
  final static String PUB_ID = TierStoreExp1_Constants.PUB_ID;

  final static String CONFIG_PATH = TierStoreExp1_Constants.CONFIG_PATH;
  final static String P2_CONFIG_PATH = TierStoreExp1_Constants.P2_CONFIG_PATH;
  final static String OVERLOG_PATH = TierStoreExp1_Constants.OVERLOG_PATH;
  final static String NODEMAP_PATH = TierStoreExp1_Constants.NODEMAP_PATH;
  public static final String DBPREFIX_POPULATED = TierStoreExp1_Constants.DBPREFIX_POPULATED;
  public static final String DBPREFIX_DEFAULT = TierStoreExp1_Constants.DBPREFIX_DEFAULT;
  public static final String PUBLICATION_PREFIX = TierStoreExp1_Constants.PUBLICATION_PREFIX;


 /** 
 *  Make configuration 
 **/ 
  public static synchronized void makePractiConfig(String configPath) {
    Config.createEmptyConfig();
    Config.addOneNodeConfig(new NodeId(0),
                            NODE_0_NAME,
                            9988,
                            9989,
                            9991,
                            9992,
                            9990,
                            DBPREFIX_POPULATED+".db",
                            PUBLICATION_PREFIX+PUB_ID + "/*:" + PUBLICATION_PREFIX+"nfsroot/*:/subscriptionTree/*",
                            -1L,
                            NODE_0_NAME,
                            9993,
                            9994,
                            -1,
  			    Config.CACHE_SIZE_BYTES_DEFAULT,
			    Config.MAX_LOG_DISK_SIZE_BYTES,
			    Config.MAX_LOG_MEM_SIZE_BYTES);
    Config.addOneNodeConfig(new NodeId(1),
                            NODE_1_NAME,
                            9788,
                            9789,
                            9791,
                            9792,
                            9790,
                            DBPREFIX_DEFAULT+".db",
                            PUBLICATION_PREFIX+PUB_ID + "/*:" + PUBLICATION_PREFIX+"nfsroot/*:/subscriptionTree/*",
                            -1L,
                            NODE_1_NAME,
                            9793,
                            9794,
                            -1,
  			    Config.CACHE_SIZE_BYTES_DEFAULT,
			    Config.MAX_LOG_DISK_SIZE_BYTES,
			    Config.MAX_LOG_MEM_SIZE_BYTES);
    Config.addOneNodeConfig(new NodeId(2),
                            NODE_2_NAME,
                            9888,
                            9889,
                            9891,
                            9892,
                            9890,
                            DBPREFIX_DEFAULT+".db",
                            PUBLICATION_PREFIX+PUB_ID + "/*:" + PUBLICATION_PREFIX+"nfsroot/*:/subscriptionTree/*",
                            -1L,
                            NODE_2_NAME,
                            9893,
                            9894,
                            -1,
  			    Config.CACHE_SIZE_BYTES_DEFAULT,
			    Config.MAX_LOG_DISK_SIZE_BYTES,
			    Config.MAX_LOG_MEM_SIZE_BYTES);
    
    Config.addOneNodeConfig(new NodeId(3),
                            NODE_3_NAME,
                            9688,
                            9689,
                            9691,
                            9692,
                            9690,
                            DBPREFIX_DEFAULT+".db",
                            PUBLICATION_PREFIX+PUB_ID + "/*:" + PUBLICATION_PREFIX+"nfsroot/*:/subscriptionTree/*",
                            -1L,
                            NODE_3_NAME,
                            9693,
                            9694,
                            -1,
  			    Config.CACHE_SIZE_BYTES_DEFAULT,
			    Config.MAX_LOG_DISK_SIZE_BYTES,
			    Config.MAX_LOG_MEM_SIZE_BYTES);


    Config.addOneNodeConfig(new NodeId(4),
                            NODE_4_NAME,
                            9588,
                            9589,
                            9591,
                            9592,
                            9590,
                            DBPREFIX_DEFAULT+".db",
                            PUBLICATION_PREFIX+PUB_ID + "/*:" + PUBLICATION_PREFIX+"nfsroot/*:/subscriptionTree/*",
                            -1L,
                            NODE_4_NAME,
                            9593,
                            9594,
                            -1,
  			    Config.CACHE_SIZE_BYTES_DEFAULT,
			    Config.MAX_LOG_DISK_SIZE_BYTES,
			    Config.MAX_LOG_MEM_SIZE_BYTES);


    Config.writeToFile(configPath);
  }

 public static synchronized void makeP2Config(String p2ConfigPath){

   P2Config.createEmptyConfig();
   P2Config.addOneNodeConfig(new NodeId(0), 5, 5, 30000000, 30000000, 2, 2, 2, 2, 2);
   P2Config.addOneNodeConfig(new NodeId(1), 5, 5, 30000000, 30000000, 2, 2, 2, 2, 2);
   P2Config.addOneNodeConfig(new NodeId(2), 5, 5, 30000000, 30000000, 2, 2, 2, 2, 2);
   P2Config.addOneNodeConfig(new NodeId(3), 5, 5, 30000000, 30000000, 2, 2, 2, 2, 2);
   P2Config.addOneNodeConfig(new NodeId(4), 5, 5, 30000000, 30000000, 2, 2, 2, 2, 2);
   P2Config.writeToFile(p2ConfigPath);
  }

  public static synchronized  void makeNodeIdMap(String nodeIdMapPath) {
    NodeIdMap.createEmptyMap();
    NodeIdMap.add(new NodeId(0), new OverlogId(NODE_0_NAME+ ":" + NODE_0_PORT));
    NodeIdMap.add(new NodeId(1), new OverlogId(NODE_1_NAME+ ":" + NODE_1_PORT));
    NodeIdMap.add(new NodeId(2), new OverlogId(NODE_2_NAME+ ":" + NODE_2_PORT));
    NodeIdMap.add(new NodeId(3), new OverlogId(NODE_3_NAME+ ":" + NODE_3_PORT));
    NodeIdMap.add(new NodeId(4), new OverlogId(NODE_4_NAME+ ":" + NODE_4_PORT));

    NodeIdMap.writeToFile(nodeIdMapPath);
  }

//---------------------------------------------------------------------------
// main method
//---------------------------------------------------------------------------

  public static void main(String args[]) {
    makePractiConfig(CONFIG_PATH);
    makeP2Config(P2_CONFIG_PATH);
    makeNodeIdMap(NODEMAP_PATH);
    System.out.println("done");
  }
}

//---------------------------------------------------------------------------
/* $Log: TierStoreExp1_MakeConfig.java,v $
/* Revision 1.1  2007/03/21 22:27:00  nalini
/* Added Tier Store exp
/*
*/
 /** 
