 /** 
/* TierStoreExp1_Node.java
 *
 * Starts the TierStoreUraNode_1.java
 *
 *  Tries to read the last obj in the database and 
 *
 *  measures the bandwidth consumed by outgoing connections

 *
 * (C) Copyright 2007 -- See the file COPYRIGHT for additional details
 */
 **/ 

import java.io.*;

public class TierStoreExp1_Node {
  private TierStoreURAOverlogNode_Exp1 node;
  private TierStoreLocalInterface tli;
  private NodeId myNodeId;
  private String outFile;

 /** 
 *  Constructor 
 **/ 
 
  public TierStoreExp1_Node(NodeId nodeId, boolean cleanDb) {
    Stats.reset();
    node = new TierStoreURAOverlogNode_Exp1(nodeId, cleanDb);
    tli = node.getTLI();
    myNodeId = nodeId;
    outFile = "out-"+nodeId.getIDint()+".res";
  }

 /** 
 *  starts the node 
 **/ 
 
  public void start() {
    node.start();
  }


 /** 
 *   reads the last obj 
 **/ 
 
  public synchronized void readLastObj() {
    ObjId objId = new ObjId(TierStoreExp1_Constants.PUBLICATION_PREFIX + 
                      TierStoreExp1_Constants.PUB_ID + "/" +   
                    (TierStoreExp1_Constants.NUM_OBJS - 1));

   System.out.println("Trying to Read last obj " + objId);

    while(true) {
      try{
        tli.read(objId, 0, 1);
	System.out.println("got obj.. me happy");
        break;
      }catch(ObjNotFoundException e){
        // wait and then try again
        //System.out.println("Obj Not Found");
        try{
          wait(2000);
        }catch(InterruptedException ie) {}
      }catch(Exception e) {
        e.printStackTrace();
        break;
      }
    }
  }

 /** 
 *   prints the stats 
 **/ 
 
  public void printStats() {
      try{
	  System.out.println("Total outgoing bw: " + Stats.createRecord().getTotal());
	  PrintStream out = new PrintStream(new FileOutputStream(outFile)); 
	  out.println(Stats.createRecord().getTotal());
	  out.close();
      }catch(Exception e) {
	  e.printStackTrace();
      }
  }


 /** 
 *   informGotData 
 **/ 
 
  public void informGotData() {
    node.informGotData();
  }

 /** 
 *  waitUntilChildrenDone 
 **/ 
 
  public void waitUntilChildrenDone(){
      System.out.println("Waiting for children to be done");
    node.waitUntilChildrenDone();
  }


 /** 
 *   main method 
 **/ 
  public static void main(String[] args) {
    if(args.length < 2) {
      System.out.println("Usage: TierStoreExp1_Node <nodeId> <cleanDB = 0|1>");
      System.exit(0);
    }

    NodeId nodeId = new NodeId(new Long(args[0]).longValue());
    boolean cleanDb = true;
    if(args[1].equals("0")){
      cleanDb = false;
    }


    TierStoreExp1_Node exp = new TierStoreExp1_Node(nodeId, cleanDb);
    System.out.println("Starting node");
    exp.start();
 
    exp.readLastObj();

    exp.informGotData();

    exp.waitUntilChildrenDone();

    exp.printStats();

    System.out.println("Test finished ...");

    // do not system exit yet because we want the data to 
    // transfer to other nodes
  }
}

 /** 
/* $Log: TierStoreExp1_Node.java,v $
/* Revision 1.2  2007/03/21 22:34:12  nalini
/* fixed compilation errors
/*
/* Revision 1.1  2007/03/21 22:27:00  nalini
/* Added Tier Store exp
/*
*/
 **/ 
  


        
      