 /** 
/* TierStoreURAOverlogNode_Exp1.java
 *
 * Create Practi URANode and Overlog Engine, and a TierStoreFS (local interface)
 *
 *  sets up the subscriptions as
 *
 *                      ----> Node 2
 *  Node 0 --> Node 1 -|----> Node 3
 *                      ----> Node 4
 *
 * (C) Copyright 2007 -- See the file COPYRIGHT for additional details
 */
 **/ 

import java.io.*;
import java.util.*;

public class TierStoreURAOverlogNode_Exp1 extends URAOverlogNode{

  final static String NODE_0_NAME=TierStoreExp1_Constants.NODE_0_NAME;
  final static String NODE_0_PORT=TierStoreExp1_Constants.NODE_0_PORT;
  final static String NODE_1_NAME=TierStoreExp1_Constants.NODE_1_NAME;
  final static String NODE_1_PORT=TierStoreExp1_Constants.NODE_1_PORT;
  final static String NODE_2_NAME=TierStoreExp1_Constants.NODE_2_NAME;
  final static String NODE_2_PORT=TierStoreExp1_Constants.NODE_2_PORT;
  final static String NODE_3_NAME=TierStoreExp1_Constants.NODE_3_NAME;
  final static String NODE_3_PORT=TierStoreExp1_Constants.NODE_3_PORT;
  final static String NODE_4_NAME=TierStoreExp1_Constants.NODE_4_NAME;
  final static String NODE_4_PORT=TierStoreExp1_Constants.NODE_4_PORT;
  final static String PUB_ID = TierStoreExp1_Constants.PUB_ID;

  final static String CONFIG_PATH = TierStoreExp1_Constants.CONFIG_PATH;
  final static String P2_CONFIG_PATH = TierStoreExp1_Constants.P2_CONFIG_PATH;
  final static String OVERLOG_PATH = TierStoreExp1_Constants.OVERLOG_PATH;
  final static String NODEMAP_PATH = TierStoreExp1_Constants.NODEMAP_PATH;

  final static long primary = 0;
  final static boolean dbg = true;
  final TierStoreFS pfs;
  final PRACTIP2Interface ppi;

  TierStoreLocalInterface tli;
  private TupleWait childDone;
  private NodeId myNodeId;


 /** 
 *   constructor 
 **/ 
 
  public TierStoreURAOverlogNode_Exp1(NodeId nodeId, 
                                      boolean cleanDb) {
    super(CONFIG_PATH, P2_CONFIG_PATH, nodeId, cleanDb, OVERLOG_PATH, NODEMAP_PATH, false);
    myNodeId = nodeId;                                     
    Env.dprintln(dbg, "creating TierStoreFS");
    tli = new TierStoreLocalInterface(li, nodeId);
    initConfig();
    pfs = new TierStoreFS(tli,
			  overlogPolicy, 
                          nodeId.equals(new NodeId(primary)));
    ppi = new PRACTIP2Interface(tli, overlogPolicy);

    childDone = new TupleWait("childDone");
    registerHandler(childDone);

    Env.dprintln(dbg, "creating TierStoreFS done");
    
  }

 /** 
 *   start method 
 **/ 
 
  public synchronized void start() {
    
    try{
      super.start();
      System.out.println("Waiting for overlog to start");
      wait(4000);
    }catch(Exception e){
      e.printStackTrace();
      System.exit(1);
    }

  }

 /** 
 *  getFS 
 **/ 

  public TierStoreFS getFS(){
    return pfs;
  }

 /** 
 *   getTLI 
 **/ 

  public TierStoreLocalInterface getTLI(){
    return this.tli;
  }

 /** 
 *  informs Overlog that I got data -- for exp1 
 **/ 
  public void informGotData() {
    String[] stringA = {"gotData",
                        NodeIdMap.getOverlogId(myNodeId).toString()};
    insertTuple(new Tuple(stringA));
  }

 /** 
 *  waits until all children report done 
 **/ 
  public void waitUntilChildrenDone() {
    long myNodeValue = myNodeId.getIDint();

    if(myNodeValue == 0) {
      // wait for 1 child
      childDone.waitForTuple();
    } else if (myNodeValue == 1) {
      // wait for 3 children;
      childDone.waitForMultipleTuples(3);
    }
    // no children
  }
    
      


 
 /** 
 *  initialize configuration 
 **/ 

  private void initConfig(){
    try{
      //
      // sets up config for node 0
      //
      // add Node 1 as child
    PRACTIFileOutputStream pos = 
      new PRACTIFileOutputStream(this.tli, 
                                 new ObjId("/subscriptionTree/children/" + 
                                           NODE_0_NAME + "." + NODE_0_PORT));
    ObjectOutputStream oos = new ObjectOutputStream(pos);
    String str = "children " + NODE_0_NAME + ":" + NODE_0_PORT + " " + NODE_1_NAME + ":" + NODE_1_PORT;
    oos.writeObject(str);
    oos.flush();

    //
    // set up config for node 1
    //
    // add Node 2, Node 3, Node 4 as children
    pos = 
      new PRACTIFileOutputStream(this.tli, new ObjId("/subscriptionTree/children/" +
                                                     NODE_1_NAME + "." + NODE_1_PORT));
    oos = new ObjectOutputStream(pos);
    str = "children " + NODE_1_NAME + ":" + NODE_1_PORT + " " + NODE_2_NAME + ":" + NODE_2_PORT;
    oos.writeObject(str);
    str = "children " + NODE_1_NAME + ":" + NODE_1_PORT + " " + NODE_3_NAME + ":" + NODE_3_PORT; 
    oos.writeObject(str);   
    str = "children " + NODE_1_NAME + ":" + NODE_1_PORT + " " + NODE_3_NAME + ":" + NODE_3_PORT;
    oos.writeObject(str);
    oos.flush();

    // add Node 0 as parent
     
    pos = 
      new PRACTIFileOutputStream(this.tli, new ObjId("/subscriptionTree/parent/" +
                                                     NODE_1_NAME + "." + NODE_1_PORT));
                                                     
    oos = new ObjectOutputStream(pos);
    str = "parent "+ NODE_1_NAME + ":" + NODE_1_PORT + " " + NODE_0_NAME + ":" + NODE_0_PORT;
    oos.writeObject(str);
    oos.flush();


    //
    //  set up config for node 2
    //
    // add node 1 as parent
    pos = 
      new PRACTIFileOutputStream(this.tli, new ObjId("/subscriptionTree/parent/" +
                                                     NODE_2_NAME + "." + NODE_2_PORT));
                                                     
    oos = new ObjectOutputStream(pos);
    str = "parent "+ NODE_2_NAME + ":" + NODE_2_PORT + " " + NODE_1_NAME + ":" + NODE_1_PORT;
    oos.writeObject(str);
    oos.flush();


    //
    //  set up config for node 3
    //
    // add node 1 as parent
    pos = 
      new PRACTIFileOutputStream(this.tli, new ObjId("/subscriptionTree/parent/" +
                                                     NODE_3_NAME + "." + NODE_3_PORT));
                                                     
    oos = new ObjectOutputStream(pos);
    str = "parent "+ NODE_3_NAME + ":" + NODE_3_PORT + " " + NODE_1_NAME + ":" + NODE_1_PORT;
    oos.writeObject(str);
    oos.flush();


    //
    //  set up config for node 4
    //
    // add node 1 as parent
    pos = 
      new PRACTIFileOutputStream(this.tli, new ObjId("/subscriptionTree/parent/" +
                                                     NODE_4_NAME + "." + NODE_4_PORT));
                                                     
    oos = new ObjectOutputStream(pos);
    str = "parent "+ NODE_4_NAME + ":" + NODE_4_PORT + " " + NODE_1_NAME + ":" + NODE_1_PORT;
    oos.writeObject(str);
    oos.flush();


    
    //
    // Set up subscriptions in nodes
    //

    pos = new PRACTIFileOutputStream(this.tli, new ObjId("/subscriptionTree/subscribe/" + 
                                                         NODE_0_NAME + "." + NODE_0_PORT));
    oos = new ObjectOutputStream(pos);
    str = "subscribeItems " + PUB_ID;
    oos.writeObject(str);
    str = "subscribeItems nfsroot";
    oos.writeObject(str);
    oos.flush();

    ObjId obj =  new ObjId("/subscriptionTree/subscribe" + 
			   NODE_0_NAME + "." + NODE_0_PORT);
    pos = new PRACTIFileOutputStream(this.tli, new ObjId("/subscriptionTree/subscribe/" + 
                                                         NODE_0_NAME + "." + NODE_0_PORT));
    System.out.println("Writing out to " + obj);
    oos = new ObjectOutputStream(pos);
    str = "subscribeItems " + PUB_ID;
    oos.writeObject(str);
    str = "subscribeItems nfsroot";
    oos.writeObject(str);
    oos.flush();
 

    pos = new PRACTIFileOutputStream(this.tli, new ObjId("/subscriptionTree/subscribe/" + 
                                                         NODE_1_NAME + "." + NODE_1_PORT));
    oos = new ObjectOutputStream(pos);
    str = "subscribeItems " + PUB_ID;
    oos.writeObject(str);
    str = "subscribeItems nfsroot";
    oos.writeObject(str);
    oos.flush();


    pos = new PRACTIFileOutputStream(this.tli, new ObjId("/subscriptionTree/subscribe/" + 
                                                         NODE_2_NAME + "." + NODE_2_PORT));
    oos = new ObjectOutputStream(pos);
    str = "subscribeItems " + PUB_ID;
    oos.writeObject(str);
    str = "subscribeItems nfsroot";
    oos.writeObject(str);
    oos.flush();
 

    pos = new PRACTIFileOutputStream(this.tli, new ObjId("/subscriptionTree/subscribe/" + 
                                                         NODE_3_NAME + "." + NODE_3_PORT));
    oos = new ObjectOutputStream(pos);
    str = "subscribeItems " + PUB_ID;
    oos.writeObject(str);
    str = "subscribeItems nfsroot";
    oos.writeObject(str);
    oos.flush();


    pos = new PRACTIFileOutputStream(this.tli, new ObjId("/subscriptionTree/subscribe/" + 
                                                      NODE_4_NAME + "." + NODE_4_PORT));
    oos = new ObjectOutputStream(pos);
    str = "subscribeItems " + PUB_ID;
    oos.writeObject(str);
    str = "subscribeItems nfsroot";
    oos.writeObject(str);
    oos.flush();


    Env.dprintln(dbg, "populate cofig finished");
    }catch(Exception e){
      e.printStackTrace();
      System.exit(-1);
    }
  }

 /** 
 *   main method 
 **/ 
 
  public static void main(String[] args)
  throws Exception{

    if(args.length < 2) {
      System.out.println("Usage: TierStoreURAOverlogNode_Exp1 <nodeId> <cleanDB = 0|1>");
      System.exit(0);
    }

    NodeId nodeId = new NodeId(new Long(args[0]).longValue());
    boolean cleanDb = true;
    if(args[1].equals("0")){
      cleanDb = false;
    }


    TierStoreURAOverlogNode_Exp1 uraNode = new TierStoreURAOverlogNode_Exp1(nodeId, cleanDb);

    uraNode.start();
    Env.dprintln(dbg, "uraNode created and started");
        
  }
}

 /** 
/* $Log: TierStoreURAOverlogNode_Exp1.java,v $
/* Revision 1.2  2007/03/21 22:34:12  nalini
/* fixed compilation errors
/*
/* Revision 1.1  2007/03/21 22:27:00  nalini
/* Added Tier Store exp
/*
*/
 **/ 
