//---------------------------------------------------------------------------
// Implement a SocketImpl instance for a NiceSocket
//---------------------------------------------------------------------------
#include <sys/types.h>
#include <jni.h>
#include "code_NiceSocketImpl.h"

//
// For cygwin, NiceSocketImple is a stub -- nice
// sockets and regular sockets are *the same.* 
//
// TBD: 
//  (1) Provide API to nice sockets to query whether
//      kernel nice is available on the current platform
//      (e.g., an ioctl call that returns an unusual number
//      if nice is available)
//  (2) Provide application-level nice or throttling
//      for cases when Nice not avail.
//
#ifndef __CYGWIN__
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <netdb.h>
#include <sys/types.h>
#endif

#define SEND_BUF_SIZE 5000000


//---------------------------------------------------------------------------
// Do we support low-priority connections?
//---------------------------------------------------------------------------
JNIEXPORT jint JNICALL Java_code_NiceSocketImpl_c_1checkSupportNice(JNIEnv *env, jobject obj)
{
#ifndef __CYGWIN__
  //
  // TBD: the kernel implementation should let us to a ioctl or something
  // to see if we really support... 
  //
  return 1;
#else
  return 0;
#endif
}



//---------------------------------------------------------------------------
// Create a socket
//---------------------------------------------------------------------------
JNIEXPORT jint JNICALL Java_code_NiceSocketImpl_c_1socket(JNIEnv *env, jobject obj)
{
#ifndef __CYGWIN__
  return nativeNiceSocketImpl_c_1socket(env, obj);
#else
  return -1;
#endif
}


//---------------------------------------------------------------------------
// Create a socket -- really do it on platforms that support us
//---------------------------------------------------------------------------
#ifndef __CYGWIN__
jint nativeNiceSocketImpl_c_1socket(JNIEnv *env, jobject obj)
{
  int size = 0;
  jint sockFD = -1;
  int sendBufSize = 0;
  int reply = 0;
  int make_it_one = 1;

  sockFD = socket(AF_INET, SOCK_STREAM, 0);

  /*
    if(sockFD >= 0){
    // Set the receiver buffer size
    sendBufSize = SEND_BUF_SIZE;
    setsockopt(sockFD, SOL_SOCKET, SO_SNDBUF, &sendBufSize, sizeof(int));
    // See if this worked
    size = sizeof(sendBufSize);
    getsockopt(sockFD, SOL_SOCKET, SO_SNDBUF, &sendBufSize, &size);
    printf("sendBufSize = %d, size = %d\n", sendBufSize, size);
    }
  */

  if(sockFD >= 0){
    setsockopt(sockFD, SOL_TCP, 15, &make_it_one, sizeof(int));
    // See if this worked
    size = sizeof(make_it_one);
    getsockopt(sockFD, SOL_TCP, 15, &make_it_one, &size);
    //printf("make_it_one = %d, size = %d\n", make_it_one, size);
  }

  return(sockFD);
}
#endif

//---------------------------------------------------------------------------
// Connect a socket
//---------------------------------------------------------------------------
JNIEXPORT jint JNICALL Java_code_NiceSocketImpl_c_1connect(JNIEnv *env,
						      jobject obj,
						      jint sock,
						      jstring ipAddress,
						      jint port)
{
  jint retVal = -1;

#ifndef __CYGWIN__
  struct sockaddr_in server;
  struct hostent *hp;
  const char* hostIPAddress = NULL;

  hostIPAddress = (*env)->GetStringUTFChars(env, ipAddress, 0);
  hp = gethostbyname(hostIPAddress);
  // If this seg faults, put this statement at the end
  (*env)->ReleaseStringUTFChars(env, ipAddress, hostIPAddress);

  if(hp != NULL){
    server.sin_family = AF_INET;
    server.sin_port = htons((short)port);
    memcpy((char*)&server.sin_addr, (char *)hp->h_addr, hp->h_length);
    retVal = connect(sock, (struct sockaddr *)&server, sizeof(server));
  }
#endif

  return(retVal);
}

//---------------------------------------------------------------------------
// Set TCP_NODELAY to the desired value
//---------------------------------------------------------------------------
JNIEXPORT jint JNICALL Java_code_NiceSocketImpl_c_1setNoDelay(JNIEnv *env,
                                                         jobject obj,
                                                         jint sock,
                                                         jint val)
{
  jint retVal = 0;

#ifndef __CYGWIN__
  retVal = setsockopt(sock,
                      SOL_TCP,
                      TCP_NODELAY,
                      (char*)(&val),
                      (socklen_t)sizeof(jint));
#endif
  return(retVal);
}

//---------------------------------------------------------------------------
// Return the value of the TCP_NODELAY socket option
//---------------------------------------------------------------------------
JNIEXPORT jint JNICALL Java_code_NiceSocketImpl_c_1getNoDelay(JNIEnv *env,
                                                         jobject obj,
                                                         jint sock)
{
  jint retVal = -999;
#ifndef __CYGWIN__
  jint val = 0;
  socklen_t size = (socklen_t)0;

  size = (socklen_t)sizeof(int);
  retVal = getsockopt(sock, SOL_TCP, TCP_NODELAY, (char*)&val, &size);
  if(retVal >= 0){
    retVal = val;
  }
#endif
  return(retVal);
}

//---------------------------------------------------------------------------
// Close a socket
//---------------------------------------------------------------------------
JNIEXPORT jint JNICALL Java_code_NiceSocketImpl_c_1close(JNIEnv *env,
						    jobject obj,
						    jint sock)
{
  jint retVal = 0;
#ifndef __CYGWIN__
  retVal = close(sock);
#endif
  return(retVal);
}
