#include <jni.h>
#include "code_NiceSocketInputStream.h"
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

//---------------------------------------------------------------------------
// Receive from a socket
//---------------------------------------------------------------------------
JNIEXPORT jint JNICALL Java_code_NiceSocketInputStream_c_1recv(JNIEnv *env,
							  jobject obj,
							  jint sock,
							  jbyteArray bArray,
							  jint off,
							  jint len)
{
#ifdef __CYGWIN__
  return -1;
#else

  jint retVal = 0;
  jbyte *body = (*env)->GetByteArrayElements(env, bArray, 0);

  retVal = recv(sock, body + off, len, 0);
  //retVal = nice_recv(sock, body + off, len, 0);
  (*env)->ReleaseByteArrayElements(env, bArray, body, 0);
  return(retVal);
#endif
}

//---------------------------------------------------------------------------
// Close socket
//---------------------------------------------------------------------------
JNIEXPORT jint JNICALL Java_code_NiceSocketInputStream_c_1close(JNIEnv *env,
							   jobject obj,
							   jint sock)
{
#ifdef __CYGWIN__
  return -1;
#else
  jint retVal = 0;
  retVal = close(sock);
  //retVal = nice_close(sock);
  
  return(retVal);
#endif
}
