#include <jni.h>
#include "code_NiceSocketInputStream.h"
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

//---------------------------------------------------------------------------
// Send to a socket
//---------------------------------------------------------------------------
JNIEXPORT jint JNICALL Java_code_NiceSocketOutputStream_c_1send(JNIEnv *env,
							   jobject obj,
							   jint sock,
							   jbyteArray bArray,
							   jint off,
							   jint len)
{
#ifdef __CYGWIN__
  return -1;
#else

  jint retVal = 0;
  jbyte *body = (*env)->GetByteArrayElements(env, bArray, 0);

  retVal = send(sock, body + off, len, 0);

  //retVal = nice_send(sock, body + off, len, 0);
  (*env)->ReleaseByteArrayElements(env, bArray, body, 0);
  return(retVal);
#endif
}

//---------------------------------------------------------------------------
// Send a single byte to a socket
//---------------------------------------------------------------------------
JNIEXPORT jint JNICALL Java_code_NiceSocketOutputStream_c_1sendbyte(JNIEnv *env,
							       jobject obj,
							       jint sockFD,
							       jint byte)
{
#ifdef __CYGWIN__
  return -1;
#else
  static char b = 0;
  jint retVal = 0;

  b = (char)(byte & 0xFF);
  retVal = send(sockFD, &b, 1, 0);
  //retVal = nice_send(sockFD, &b, 1, 0);

  return(retVal);
#endif
}

//---------------------------------------------------------------------------
// Close socket
//---------------------------------------------------------------------------
JNIEXPORT jint JNICALL Java_code_NiceSocketOutputStream_c_1close(JNIEnv *env,
							    jobject obj,
							    jint sock)
{
#ifdef __CYGWIN__
  return -1;
#else
  jint retVal = 0;

  retVal = close(sock);
  //retVal = nice_close(sock);

  return(retVal);
#endif
}
