 /** 
 *  Express interest in 10% of the directories and 100% of their files 
 **/ 
import java.util.Random;

class Case1RandFileBaseGen implements RandFileBaseGen
{
    private long numFiles;
    private long depth;
    private Random rand;

 /** 
 *  Constructor 
 **/ 
    public Case1RandFileBaseGen(long numFiles, int branchFactor)
    {
	assert (branchFactor == 10):"Only implemented for branchFactor == 10";
	this.numFiles = numFiles;
	this.getDepth();
	this.rand = new Random(1909);
    }

 /** 
 *  Return the depth of the directory structure 
 **/ 
    private void getDepth()
    {
	long lastFileNum = 0;

	this.depth = 0;
	lastFileNum = this.numFiles - 1;
	while(lastFileNum > 0){
	    // Make sure we have a power of 10
	    assert((lastFileNum % 10) == 9);
	    this.depth++;
	    lastFileNum = lastFileNum / 10;
	}
    }

 /** 
 *  Return a new base number 
 **/ 
    public long getNextBaseName()
    {
	long nextBaseName = 0;
	long nextBaseBound = 0;

	nextBaseBound = 1;
	for(int i = 0; i < (this.depth - 1); i++){
	    nextBaseBound *= 10;
	}
	nextBaseName = (long)(this.rand.nextDouble() * nextBaseBound);
	return(nextBaseName);
    }
}
