 /** 
 *  Global Coordinator 
 *  Read scripts from standard input 
 *  Currently have 4 kinds of commands: subscribe, subscribeBody, 
 *                                      issueDemandRead, and sleep 
 **/ 
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.HashMap;
import java.util.Random;

public class CoordExptB extends CoordExptA
{
    public static long SUBSCRIPTION_DURATION_MS = 86400000;  // 1 day
    public static long MAX_DELAY_MS = 1000; // 1 second

    /*
    //-----------------------------------------------------------------------
    // Ask nodeId to perform the reads to objects in writeEntries
    //-----------------------------------------------------------------------
    protected void sendWaitReadsFinishScript(int nodeId,
					     WriteEntry[] writeEntries)
    {
	OutputStream os = null;
	PrintStream ps = null;
	CoordCommPacket ccp = null;

	os = this.getProcessOutputStream(nodeId);
	ps = new PrintStream(os);
	for(int i = 0; i < writeEntries.length; i++){
	    if(this.liesInInterestSet(writeEntries[i].getObjId())){
		ps.println("r " + writeEntries[i].getObjId() +
			   " " + writeEntries[i].getOffset() +
			   " " + writeEntries[i].getLength());
		ps.flush();
		// Wait for this read to finish
		ccp = this.recv(nodeId);
		assert(ccp.getSignalType() == CoordCommPacket.READ_DONE);
		assert(ccp.getData() instanceof AcceptStamp);
	    }
	}
	if(ccp != null){
	    System.out.println("Read AcceptStamp = " + ccp.getData());
	}
    }

    //-----------------------------------------------------------------------
    // Ask nodeId to perform the random writes in writeEntries
    //-----------------------------------------------------------------------
    protected void sendRandomWritesScript(int nodeId,
					  WriteEntry[]
					  writeEntries)
    {
	OutputStream os = null;
	PrintStream ps = null;

	os = this.getProcessOutputStream(nodeId);
	ps = new PrintStream(os);
	for(int i = 0; i < writeEntries.length; i++){
	    if(this.liesInInterestSet(writeEntries[i].getObjId())){
		// Send a bound inval
		ps.println("w " + writeEntries[i].getObjId() +
			   " " + writeEntries[i].getOffset() +
			   " " + writeEntries[i].getLength() +
			   " 1"); // 1 = bound
	    }else{
		ps.println("w " + writeEntries[i].getObjId() +
			   " " + writeEntries[i].getOffset() +
			   " " + writeEntries[i].getLength() +
			   " 0"); // 0 = unbound
	    }
	}
        ps.println("g " + nodeId);
        ps.flush();
    }
    */

 /** 
 *  Constructor 
 **/ 
    public CoordExptB(String exptConfigFileName, String shellType_)
    {
	super(exptConfigFileName, shellType_);
    }

 /** 
 *  Send a script to standard output for node nodeId to do random demand 
 *  fetches 
 **/ 
    public void sendRandomDemandFetches(int supplierNodeId,
					int receiverNodeId,
					RandFileBaseGen rfbg)
    {
	OutputStream os = null;
	PrintStream ps = null;
	long baseFileName = 0;
	String fileName = null;
	long numFiles = 0;
	long offset = 0;
	long length = 0;
	long fileSize = 0;
	Random rand = null;

	rand = new Random(4555);
	for(int i = 0; i < this.exptConfig.getNumReads(); i++){
	    baseFileName = rfbg.getNextBaseName();
	    numFiles = this.exptConfig.getNumFiles();
	    fileName = this.senderScriptGen.createFileName(baseFileName,
							   numFiles);
	    fileSize = this.exptConfig.getFileSize();
	    offset = (long)(rand.nextDouble() * fileSize);
	    length = (long)(rand.nextDouble() * (fileSize - offset) + 1);
	    assert(offset + length <= fileSize);
	    assert(length > 0);
	    System.out.println("Sending demand push of " + fileName +
			       "[" + offset + ", " + length + "]");
	    this.issueDemandRead(supplierNodeId,
				 receiverNodeId,
				 fileName,
				 offset,
				 length,
				 i);
	}
	// We must have had at least one read; wait until this is done
	assert(fileName != null);
	os = this.getProcessOutputStream(receiverNodeId);
	ps = new PrintStream(os);
	/*
	try{
	    Thread.sleep(2000);
	}catch(InterruptedException e){
	    System.err.println("" + e);
	}
	*/
	ps.println("r " + fileName + " " + offset + " " + length);
	ps.flush();
    }

 /** 
 *  Make an array full of random writes 
 **/ 
    protected WriteEntry[] makeRandomWrites()
    {
	long numFiles = 0;
	long fileBase = 0;
	long fileSize = 0;
	WriteEntry[] writeEntries = null;
	Random rand = null;
	String fileName = null;
	long offset = 0;
	long length = 0;

	numFiles = this.exptConfig.getNumFiles();
	fileSize = this.exptConfig.getFileSize();
	rand = new Random(1978);
	writeEntries = new WriteEntry[this.exptConfig.getNumWrites()];
	for(int i = 0; i < writeEntries.length; i++){
	    // Generate a random write entry
	    fileBase = (long)(rand.nextDouble() * numFiles);
	    offset = (long)(rand.nextDouble() * fileSize);
	    length = (long)(rand.nextDouble() * (fileSize - offset)) + 1;
	    assert(length > 0); // Otherwise our code chokes
	    assert((offset + length) <= fileSize);

	    fileName = this.senderScriptGen.createFileName(fileBase, numFiles);
	    writeEntries[i] = new WriteEntry(fileName, offset, length);
	}
	return(writeEntries);
    }


 /** 
 *  Return the file name generator based on the current experiment number 
 **/ 
    public RandFileBaseGen getRandFileBaseGen()
    {
	RandFileBaseGen rfbg = null;

	switch(this.exptConfig.getExptNum()){
	case 1:
	    // The (10/100) case
	    rfbg = new Case1RandFileBaseGen(this.exptConfig.getNumFiles(), 10);
	    break;
	case 2:
	    // The (10/10) case
	    rfbg = new Case2RandFileBaseGen(this.exptConfig.getNumFiles(), 10);
	    break;
	case 3:
	    // The (1/100) case
	    rfbg = new Case3RandFileBaseGen(this.exptConfig.getNumFiles(), 10);
	    break;
	case 4:
	    // The (1/10) case
	    rfbg = new Case4RandFileBaseGen(this.exptConfig.getNumFiles(), 10);
	    break;
	default:
	    assert (false):"Unimplemented";
	}
	return(rfbg);
    }

 /** 
 *  Perform experiment actions 
 **/ 
    public void runExperimentB()
    {
	CoordCommPacket ccp = null;
	StatsRecord initStats = null;
	StatsRecord finalStats = null;
	StatsRecord diffStats = null;
	DirectoryInterestSet dis = null;

	/*
	 * Subscribe to "/*" for invals, demand bodies
	 */
	this.restartRMIRegistrySync();
	this.startNode(9);
	this.startNode(10);
	this.waitStartNode(9);
	this.waitStartNode(10);

	// Send all invalidates to the receiver
	this.sendPopulateFullScript(9);
	ccp = this.recv(9);
	assert(ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
	assert(ccp.getData() instanceof AcceptStamp);
	dis = new DirectoryInterestSet("/*");
	this.issueSubscribe(9,
			    10,
			    AcceptVV.makeVVAllNegatives(),
			    -1L,
			    dis,
			    SUBSCRIPTION_DURATION_MS,
			    MAX_DELAY_MS);
	this.sendSync(10, (AcceptStamp)ccp.getData());
	ccp = this.recv(10);
	assert(ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	assert(ccp.getData() == null);
	System.out.println("Received a SYNC_DONE");
	initStats = this.getAllStats();

	// Perform random writes on A and wait for B to receive a subset of
	// them
	/*
	WriteEntry[] res = this.makeRandomWrites();
	this.sendRandomWritesScript(9, false);
	this.sendSubsetReadsScript(10);
	*/

	this.sendRandomWritesScript(9, false);
	ccp = this.recv(9);
	assert(ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
	assert(ccp.getData() instanceof AcceptStamp);
	this.sendSync(10, (AcceptStamp)ccp.getData());
	ccp = this.recv(10);
	assert(ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	assert(ccp.getData() == null);
	System.out.println("Received the second SYNC_DONE");
	// A is done doing random writes

	// Demand push random files to B and wait for the last read
	this.sendRandomDemandFetches(9, 10, this.getRandFileBaseGen());
	ccp = this.recv(10);
	assert(ccp.getSignalType() == CoordCommPacket.READ_DONE);
	assert(ccp.getData() instanceof AcceptStamp);
	System.out.println("Read AcceptStamp = " + ccp.getData());

	finalStats = this.getAllStats();
	diffStats = finalStats.getDiff(initStats);
	System.out.println("---------------------------------------");
	System.out.println("" + diffStats);
	System.out.println("Exit value for node 9 = " + this.killNode(9));
	System.out.println("Exit value for node 10 = " + this.killNode(10));
    }

 /** 
 *  Program starting point 
 **/ 
    public static void main(String[] argv)
    {
	CoordExptB coord = null;

	if (argv.length < 2){
	    System.out.println("Usage: <exptConfigfile> <shellType>");
	    System.exit(-1);
	}
	coord = new CoordExptB(argv[0], argv[1]);
	coord.runExperimentB();
    }
}

 /** 
 *  $Log: CoordExptB.java,v $ 
 *  Revision 1.5  2004/07/07 21:24:23  nayate 
 *  Changed code to send bound invals to push data to the receiver 
 *  
 *  Revision 1.4  2004/05/26 16:19:35  nayate 
 *  *** empty log message *** 
 *  
 *  Revision 1.3  2004/05/21 13:37:28  nayate 
 *  Minor changes (removed some debugging information) 
 *  
 *  Revision 1.2  2004/05/21 13:11:59  nayate 
 *  Minor changes 
 *  
 *  Revision 1.1  2004/05/21 11:05:35  nayate 
 *  Second of the first set of experiments 
 *  
 **/ 
