 /** 
 *  Global Coordinator 
 *  Read scripts from standard input 
 *  Currently have 4 kinds of commands: subscribe, subscribeBody, 
 *                                      issueDemandRead, and sleep 
 **/ 
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.HashMap;
import java.util.Random;

public class CoordExptD extends CoordExptB
{
    public static long SUBSCRIPTION_DURATION_MS = 1000000;  // 1000 seconds
    public static long MAX_DELAY_MS = 1000; // 1 second

 /** 
 *  Constructor 
 **/ 
    public CoordExptD(String exptConfigFileName, String shellType_)
    {
	super(exptConfigFileName, shellType_);
    }

 /** 
 *  Return an interest set that contains the directories we are interested 
 *  in. Note that we may not care about all files in those directories. 
 **/ 
    public DirectoryInterestSet makeInterestSet()
    {
	DirectoryInterestSet dis = null;

	switch(this.exptConfig.getExptNum()){
	case 1:  // Fall through
	case 2:
	    // The (10/100) and the (10/10) cases
	    dis = new DirectoryInterestSet("/0/*");
	    break;
	case 3:
	case 4:
	    // The (1/100) and the (1/10) cases
	    dis = new DirectoryInterestSet("/0/0/*");
	    break;
	default:
	    assert (false):"Unimplemented";
	}
	return(dis);
    }

    //-----------------------------------------------------------------------
    // Perform experiment actions
    //-----------------------------------------------------------------------
    public void runExperimentD()
    {
	CoordCommPacket ccp = null;
	StatsRecord initStats = null;
	StatsRecord finalStats = null;
	StatsRecord diffStats = null;
	DirectoryInterestSet dis = null;

	/*
	 * Subscribe to IS for invals, demand bodies
	 */
	this.restartRMIRegistrySync();
	this.startNode(9);
	this.startNode(10);
	this.waitStartNode(9);
	this.waitStartNode(10);

	// Send all invalidates to the receiver
	this.sendPopulateFullScript(9);
	ccp = this.recv(9);
	assert(ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
	assert(ccp.getData() instanceof AcceptStamp);
	dis = this.makeInterestSet();
	System.out.println("dis = " + dis);
	this.issueSubscribe(9,
			    10,
			    AcceptVV.makeVVAllNegatives(),
			    -1L,
			    dis,
			    SUBSCRIPTION_DURATION_MS,
			    MAX_DELAY_MS);
	this.sendSync(10, (AcceptStamp)ccp.getData());
	ccp = this.recv(10);
	assert(ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	assert(ccp.getData() == null);
	System.out.println("Received a SYNC_DONE");
	// Sender and receiver have synchronized

	initStats = this.getAllStats();

	// Ask A to randomly write files and then demand push some to B.
	this.sendRandomWritesScript(9, false);
	ccp = this.recv(9);
	assert(ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
	assert(ccp.getData() instanceof AcceptStamp);
	this.sendSync(10, (AcceptStamp)ccp.getData());
	ccp = this.recv(10);
	assert(ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	assert(ccp.getData() == null);
	System.out.println("Received the second SYNC_DONE");
	// A is done doing random writes, and B has received invals for them

	// Demand push random files to B and wait for the last read
	this.sendRandomDemandFetches(9, 10, this.getRandFileBaseGen());
	ccp = this.recv(10);
	assert(ccp.getSignalType() == CoordCommPacket.READ_DONE);
	assert(ccp.getData() instanceof AcceptStamp);
	System.out.println("Read AcceptStamp = " + ccp.getData());

	finalStats = this.getAllStats();
	diffStats = finalStats.getDiff(initStats);
	System.out.println("---------------------------------------");
	System.out.println("" + diffStats);
	System.out.println("Exit value for node 9 = " + this.killNode(9));
	System.out.println("Exit value for node 10 = " + this.killNode(10));
    }

 /** 
 *  Program starting point 
 **/ 
    public static void main(String[] argv)
    {
	CoordExptD coord = null;

	if (argv.length < 2){
	    System.out.println("Usage: <exptConfigfile> <shellType>");
	    System.exit(-1);
	}
	coord = new CoordExptD(argv[0], argv[1]);
	coord.runExperimentD();
    }
}

 /** 
 *  $Log: CoordExptD.java,v $ 
 *  Revision 1.1  2004/07/07 21:26:49  nayate 
 *  Added new sub-experiments for experiment 1. 
 *  
 **/ 
