 /** 
 *  Global Coordinator 
 *  Read scripts from standard input 
 *  Currently have 4 kinds of commands: subscribe, subscribeBody, 
 *                                      issueDemandRead, and sleep 
 **/ 
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.HashMap;
import java.util.Random;
import java.util.Vector;

public class CoordExptF extends CoordExptD
{
    public static long SUBSCRIPTION_DURATION_MS = 1000000;  // 1000 seconds
    public static long MAX_DELAY_MS = 1000; // 1 second

 /** 
 *  Constructor 
 **/ 
    public CoordExptF(String exptConfigFileName, String shellType_)
    {
	super(exptConfigFileName, shellType_);
    }

    /*
    //-----------------------------------------------------------------------
    // Return an interest set that contains the directories we are interested
    // in. Note that we may not care about all files in those directories.
    //-----------------------------------------------------------------------
    public DirectoryInterestSet makeInterestSet()
    {
	DirectoryInterestSet dis = null;

	switch(this.exptConfig.getExptNum()){
	case 1:  // Fall through
	case 2:
	    // The (10/100) and the (10/10) cases
	    dis = new DirectoryInterestSet("/0/*");
	    break;
	case 3:
	case 4:
	    // The (1/100) and the (1/10) cases
	    dis = new DirectoryInterestSet("/0/0/*");
	    break;
	default:
	    assert (false):"Unimplemented";
	}
	return(dis);
    }
    */

 /** 
 *  Return the file name generator based on the current experiment number 
 **/ 
    public RandFileBaseGen getRandFileBaseGen()
    {
	RandFileBaseGen rfbg = null;

	switch(this.exptConfig.getExptNum()){
	case 1:
	    // The (10/100) case
	    rfbg = new Case1RandFileBaseGen(this.exptConfig.getNumFiles(), 10);
	    break;
	case 2:
	    // The (10/10) case
	    rfbg = new Case2RandFileBaseGen(this.exptConfig.getNumFiles(), 10);
	    break;
	case 3:
	    // The (1/100) case
	    rfbg = new Case3RandFileBaseGen(this.exptConfig.getNumFiles(), 10);
	    break;
	case 4:
	    // The (1/10) case
	    rfbg = new Case4RandFileBaseGen(this.exptConfig.getNumFiles(), 10);
	    break;
	default:
	    assert (false):"Unimplemented";
	}
	return(rfbg);
    }

 /** 
 *  Return an interest set that contains exactly those files we are 
 *  interested in for cases 2 and 4; i.e. with 1 file per low-level 
 *  directory. 
 **/ 
    public DirectoryInterestSet makeFileInterestSet(int quotient)
    {
	int numFiles = 0;
	int fileBase = 0;
	String fileName = null;
	DirectoryInterestSet dis = null;
	Vector directoryVec = null;
	String[] allFiles = null;

	numFiles = this.exptConfig.getNumFiles();
	directoryVec = new Vector();
	// Divide by 10 because we only want a 1 in the unit digit
	for(int i = 0; i < ((numFiles / quotient) / 10); i++){
	    fileName = this.senderScriptGen.createFileName(i * 10, numFiles);
	    directoryVec.add(fileName);
	}
	allFiles = (String[])directoryVec.toArray(new String[0]);
	dis = new DirectoryInterestSet(allFiles);
	return(dis);
    }

 /** 
 *  Return an interest set that contains exactly those files we are 
 *  interested in 
 **/ 
    public DirectoryInterestSet makeInterestSet()
    {
	DirectoryInterestSet dis = null;

	switch(this.exptConfig.getExptNum()){
	case 1:
	    // The (10/100) case
	    dis = new DirectoryInterestSet("/0/*");
	    break;
	case 2:
	    // The (10/10) case
	    dis = this.makeFileInterestSet(10);
	    break;
	case 3:
	    // The (1/100) case
	    dis = new DirectoryInterestSet("/0/0/*");
	    break;
	case 4:
	    // The (1/10) case
	    dis = this.makeFileInterestSet(100);
	    break;
	default:
	    assert (false):"Unimplemented";
	}
	return(dis);
    }

    //-----------------------------------------------------------------------
    // Perform experiment actions
    //-----------------------------------------------------------------------
    public void runExperimentF()
    {
	CoordCommPacket ccp = null;
	StatsRecord initStats = null;
	StatsRecord finalStats = null;
	StatsRecord diffStats = null;
	DirectoryInterestSet dis = null;

	/*
	 * Subscribe to IS for invals, demand bodies
	 */
	this.restartRMIRegistrySync();
	this.startNode(9);
	this.startNode(10);
	this.waitStartNode(9);
	this.waitStartNode(10);

	// Send all invalidates to the receiver
	this.sendPopulateFullScript(9);
	ccp = this.recv(9);
	assert(ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
	assert(ccp.getData() instanceof AcceptStamp);
	dis = this.makeInterestSet();
	System.out.println("dis = " + dis);
	this.issueSubscribe(9,
			    10,
			    AcceptVV.makeVVAllNegatives(),
			    -1L,
			    dis,
			    SUBSCRIPTION_DURATION_MS,
			    MAX_DELAY_MS);
	this.sendSync(10, (AcceptStamp)ccp.getData());
	ccp = this.recv(10);
	assert(ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	assert(ccp.getData() == null);
	System.out.println("Received a SYNC_DONE");
	// Sender and receiver have synchronized

	initStats = this.getAllStats();

	/*
	// Perform random writes on A and wait for B to receive a subset of
	// them. NOTE: B MUST have correctly-assigned interest sets
	vv = new AcceptVV(asArr);
	System.out.println("vv = " + vv);
	this.issueSubscribeBody(9,
				10,
				vv,
				dis,
				SUBSCRIPTION_DURATION_MS);
	writeEntries = this.makeRandomWrites();
	// Have A perform writes. Invals will flow to B on the inval channel
	this.sendRandomWritesScript(9, writeEntries);
	// Have B read all writes done by A and sync back after each one.
	this.sendWaitReadsFinishScript(10, writeEntries);
	*/

	// Ask A to randomly write files and then demand push some to B.
	this.sendRandomWritesScript(9, false);
	ccp = this.recv(9);
	assert(ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
	assert(ccp.getData() instanceof AcceptStamp);
	this.sendSync(10, (AcceptStamp)ccp.getData());
	ccp = this.recv(10);
	assert(ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	assert(ccp.getData() == null);
	System.out.println("Received the second SYNC_DONE");
	// A is done doing random writes, and B has received invals for them

	// Demand push random files to B and wait for the last read
	this.sendRandomDemandFetches(9, 10, this.getRandFileBaseGen());
	ccp = this.recv(10);
	assert(ccp.getSignalType() == CoordCommPacket.READ_DONE);
	assert(ccp.getData() instanceof AcceptStamp);
	System.out.println("Read AcceptStamp = " + ccp.getData());

	finalStats = this.getAllStats();
	diffStats = finalStats.getDiff(initStats);
	System.out.println("---------------------------------------");
	System.out.println("" + diffStats);
	System.out.println("Exit value for node 9 = " + this.killNode(9));
	System.out.println("Exit value for node 10 = " + this.killNode(10));
    }

 /** 
 *  Program starting point 
 **/ 
    public static void main(String[] argv)
    {
	CoordExptF coord = null;

	if (argv.length < 2){
	    System.out.println("Usage: <exptConfigfile> <shellType>");
	    System.exit(-1);
	}
	coord = new CoordExptF(argv[0], argv[1]);
	coord.runExperimentF();
    }
}

 /** 
 *  $Log: CoordExptF.java,v $ 
 *  Revision 1.1  2004/07/07 21:26:49  nayate 
 *  Added new sub-experiments for experiment 1. 
 *  
 **/ 
