 /** 
 *  Global Coordinator For Testing 
 *  Read scripts from standard input 
 *  Currently have 4 kinds of commands: subscribe, subscribeBody, 
 *                                      issueDemandRead, and sleep 
 **/ 
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.HashMap;
import java.util.Random;

public class CoordExpt extends CoordExpt2
{
    public CoordExpt(String exptConfigFileName, String shellType_){
	super(exptConfigFileName, shellType_);
    }
    
 /** 
 *  Perform experiment actions 
 **/ 
    public static void runSmallExpt(CoordExpt expt)
    {
	CoordCommPacket ccp = null;
	StatsRecord initStats = null;
	StatsRecord finalStats = null;
	StatsRecord diffStats = null;
	DirectoryInterestSet dis = null;

	//start A and B
	expt.restartRMIRegistrySync();
	expt.startNode(9);
	expt.startNode(10);
	expt.waitStartNode(9);
	expt.waitStartNode(10);
	
	
	initStats= expt.getAllStats();
	for (int i = 0; i <1; i++)
	expt.sendWrite(9, "/0", 0, 10, UNBOUND);
	//expt.sendWrite(9, "/0", 0, 10, UNBOUND);

	expt.sendGetAcceptStamp(9);
	  //send "g" first to use the following
	ccp = expt.recv(9);
	assert(ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
	assert(ccp.getData() instanceof AcceptStamp);
       
	//case 1. subscribe / for invals and bodies
       
	dis = new DirectoryInterestSet("/a");
	expt.issueSubscribe(9,
			    10,
			    AcceptVV.makeVVAllNegatives(),
			    -1L,
			    dis,
			    SUBSCRIPTION_DURATION_MS,
			    MAX_DELAY_MS);
       

	expt.sendSync(10, (AcceptStamp)ccp.getData());
	//expt.sendSync(9, new AcceptStamp(0, new NodeId(9)));
	
	ccp = expt.recv(10);
	assert(ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	assert(ccp.getData() == null);
	System.out.println("Received a SYNC_DONE");
	// now 9 and 10 have the same invalidates.
	
	finalStats = expt.getAllStats();
	
	System.out.println("========Get a precise inval: ");
	System.out.println(finalStats.getDiff(initStats));
	// Now let the real part of the experiment start
	initStats = expt.getAllStats();
	
	//String randomFileName = expt.getUnInterestedFileName();
	//expt.sendRead(10, randomFileName, 0, 10000);
	
	expt.issueDemandRead(9, 10, "/0", 0, 10, 5);
	expt.sendRead(10, "/0", 0, 10);
	ccp = expt.recv(10);
	assert(ccp.getSignalType() == CoordCommPacket.READ_DONE);
	assert(ccp.getData() instanceof AcceptStamp);
	
	/*
	expt.sendRead(10, "/0", 0, 10);
	ccp = expt.recv(10);
	assert(ccp.getSignalType() == CoordCommPacket.READ_DONE);
	assert(ccp.getData() instanceof AcceptStamp);
	*/
	System.out.println("========Issue a demand Read:" + (AcceptStamp)ccp.getData());
	finalStats = expt.getAllStats();
	diffStats = finalStats.getDiff(initStats);
	System.out.println("---------------------------------------");
	System.out.println("" + diffStats);
	System.out.println("Exit value for node 9 = " + expt.killNode(9));
	System.out.println("Exit value for node 10 = " + expt.killNode(10));
    }

 /** 
 *  Perform experiment actions 
 **/ 
    public static void runSmallExpt2(CoordExpt expt)
    {
	CoordCommPacket ccp = null;
	StatsRecord initStats = null;
	StatsRecord finalStats = null;
	StatsRecord diffStats = null;
	DirectoryInterestSet dis = null;

	//start A and B
	expt.restartRMIRegistrySync();
	expt.startNode(9);
	expt.startNode(10);
	expt.waitStartNode(9);
	expt.waitStartNode(10);
	
	//Sequentially write every file and set bound
	//expt.sendPopulateFullScript(9, BOUND);
	//CoordCommPacket.setD(true);
	
	expt.sendWrite(9, "/0", 0, 10, UNBOUND);
	//expt.sendWrite(9, "/1", 0, 10, UNBOUND);
	
	//send "g" first to use the following
	ccp = expt.recv(9);
	assert(ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
	assert(ccp.getData() instanceof AcceptStamp);
	
	initStats = expt.getAllStats();
	//case 1. subscribe / for invals and bodies
	dis = new DirectoryInterestSet("/*");
	expt.issueSubscribe(9,
			    10,
			    AcceptVV.makeVVAllNegatives(),
			    -1L,
			    dis,
			    SUBSCRIPTION_DURATION_MS,
			    MAX_DELAY_MS);

	expt.sendSync(10, (AcceptStamp)ccp.getData());
	//expt.sendSync(10, new AcceptStamp(0, new NodeId(9)));
	
	ccp = expt.recv(10);
	assert(ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	assert(ccp.getData() == null);
	System.out.println("Received a SYNC_DONE");

	finalStats = expt.getAllStats();
	System.out.println("=======Read Two Precise Message");
	System.out.println(finalStats.getDiff(initStats));
	// now 9 and 10 have the same invalidates.
	
	// Now let the real part of the experiment start
	initStats = expt.getAllStats();
	
	//String randomFileName = expt.getUnInterestedFileName();
	//expt.sendRead(10, randomFileName, 0, 10000);
	expt.sendRead(10, "/0", 0, 10);
	ccp = expt.recv(10);
	assert(ccp.getSignalType() == CoordCommPacket.READ_DONE);
	assert(ccp.getData() instanceof AcceptStamp);
	
	expt.sendRead(10, "/0", 0, 10);
	ccp = expt.recv(10);
	assert(ccp.getSignalType() == CoordCommPacket.READ_DONE);
	assert(ccp.getData() instanceof AcceptStamp);
	
	System.out.println("======Two Read done" + (AcceptStamp)ccp.getData());
	finalStats = expt.getAllStats();
	diffStats = finalStats.getDiff(initStats);
	System.out.println("---------------------------------------");
	System.out.println("" + diffStats);
	System.out.println("Exit value for node 9 = " + expt.killNode(9));
	System.out.println("Exit value for node 10 = " + expt.killNode(10));
    }

    //-----------------------------------------------------------------------
    // Perform experiment 2-1
    //-----------------------------------------------------------------------
    public static void runExperiment21(CoordExpt expt)
    {
	CoordCommPacket ccp = null;
	StatsRecord initStats = null;
	StatsRecord finalStats = null;
	StatsRecord diffStats = null;
	DirectoryInterestSet dis = null;

	//start A and B
	expt.restartRMIRegistrySync();
	expt.startNode(9);
	expt.startNode(10);
	expt.waitStartNode(9);
	expt.waitStartNode(10);
	
	//Sequentially write every file and set bound
	expt.sendPopulateFullScript(9, BOUND);
	//CoordCommPacket.setD(true);
	
	ccp = expt.recv(9);
	assert(ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
	assert(ccp.getData() instanceof AcceptStamp);
	
	//case 1. subscribe / for invals and bodies
	dis = new DirectoryInterestSet("/*");
	expt.issueSubscribe(9,
			    10,
			    AcceptVV.makeVVAllNegatives(),
			    -1L,
			    dis,
			    SUBSCRIPTION_DURATION_MS,
			    MAX_DELAY_MS);

	expt.sendSync(10, (AcceptStamp)ccp.getData());
	ccp = expt.recv(10);
	assert(ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	assert(ccp.getData() == null);
	System.out.println("Received a SYNC_DONE");
	// now 9 and 10 have the same invalidates.
	
	// Now let the real part of the experiment start
	initStats = expt.getAllStats();
	
	String randomFileName = expt.getUnInterestedFileName();
	expt.sendRead(10, randomFileName, 0, 10);
	
	ccp = expt.recv(10);
	assert(ccp.getSignalType() == CoordCommPacket.READ_DONE);
	assert(ccp.getData() instanceof AcceptStamp);
	
	System.out.println("****Read done" + (AcceptStamp)ccp.getData());
	finalStats = expt.getAllStats();
	diffStats = finalStats.getDiff(initStats);
	diffStats.writeToFile("Expt21.dat");
	System.out.println("---------------------------------------");
	System.out.println("" + diffStats);
	System.out.println("Exit value for node 9 = " + expt.killNode(9));
	System.out.println("Exit value for node 10 = " + expt.killNode(10));
    }

    public static void testImpreciseCount(CoordExpt22 coord){
	CoordCommPacket ccp = null;
	StatsRecord initStats = null;
	StatsRecord finalStats = null;
	StatsRecord diffStats = null;
	DirectoryInterestSet dis = null;

	//start A and B
	coord.restartRMIRegistrySync();
	coord.startNode(9);
	coord.startNode(10);
	coord.waitStartNode(9);
	coord.waitStartNode(10);
	
	//Sequentially write every file and set unbound
	coord.sendPopulateFullScript(9, UNBOUND);
	ccp = coord.recv(9);
	assert(ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
	assert(ccp.getData() instanceof AcceptStamp);
	
	//case 6. subscribe file IS for invals
	initStats = coord.getAllStats();
	System.out.println("original interestSet = /0");
	dis = new DirectoryInterestSet("/10/*");
	
	coord.issueSubscribe(9,
			    10,
			    AcceptVV.makeVVAllNegatives(),
			    -1L,
			    dis,
			    100000000,
			    10000);

	coord.sendSync(10, (AcceptStamp)ccp.getData());
	ccp = coord.recv(10);
	assert(ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	assert(ccp.getData() == null);
	System.out.println("Received a SYNC_DONE");
	// 10 have all interested invalidates.

	//Randomly write files
	/*
	coord.sendRandomWritesScript(9, coord.coordConfig.getNumWrites(), coord.numFiles, 1, UNBOUND);
	ccp = coord.recv(9);
	assert(ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
	assert(ccp.getData() instanceof AcceptStamp);

	coord.sendSync(10, (AcceptStamp)ccp.getData());
	ccp = coord.recv(10);
	assert(ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	assert(ccp.getData() == null);
	System.out.println("Received second SYNC_DONE");
	
	*/
	// Now let the real part of the experiment start..................
	
	
	String randomFileName = coord.getUnInterestedFileName();
	coord.issueDemandRead(9, 10, randomFileName, 0, 100, 0);
	coord.sendRead(10, randomFileName, 0, 10);
	
	ccp = coord.recv(10);
	assert(ccp.getSignalType() == CoordCommPacket.READ_DONE);
	assert(ccp.getData() instanceof AcceptStamp);
	
	System.out.println("****Read done" + (AcceptStamp)ccp.getData());
    
	finalStats = coord.getAllStats();
	diffStats = finalStats.getDiff(initStats);
	diffStats.writeToFile("test.dat");
	System.out.println("---------------------------------------");
	System.out.println("" + diffStats);
	System.out.println("Exit value for node 9 = " + coord.killNode(9));
	System.out.println("Exit value for node 10 = " + coord.killNode(10));
	
    }
    
 /** 
 *  Perform experiment 2-2 
 **/ 
    public static void runExperiment22(CoordExpt expt)
    {
	CoordCommPacket ccp = null;
	StatsRecord initStats = null;
	StatsRecord finalStats = null;
	StatsRecord diffStats = null;
	DirectoryInterestSet dis = null;

	//start A and B
	expt.restartRMIRegistrySync();
	expt.startNode(9);
	expt.startNode(10);
	expt.waitStartNode(9);
	expt.waitStartNode(10);
	
	//Sequentially write every file and set unbound
	expt.sendPopulateFullScript(9, UNBOUND);
	ccp = expt.recv(9);
	assert(ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
	assert(ccp.getData() instanceof AcceptStamp);
	
	//case 2. subscribe "/" for invals
	System.out.println("original interestSet = /*");
	dis = new DirectoryInterestSet("/*");
	expt.issueSubscribe(9,
			    10,
			    AcceptVV.makeVVAllNegatives(),
			    -1L,
			    dis,
			    CoordExpt2.SUBSCRIPTION_DURATION_MS,
			    CoordExpt2.MAX_DELAY_MS);

	expt.sendSync(10, (AcceptStamp)ccp.getData());
	ccp = expt.recv(10);
	assert(ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	assert(ccp.getData() == null);
	System.out.println("Received a SYNC_DONE");
	// 10 have all interested invalidates.

	//Randomly write files
	/*
	expt.sendRandomWritesScript(9, expt.exptConfig.getNumWrites(), expt.numFiles, 1, UNBOUND);
	ccp = expt.recv(9);
	assert(ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
	assert(ccp.getData() instanceof AcceptStamp);

	expt.sendSync(10, (AcceptStamp)ccp.getData());
	ccp = expt.recv(10);
	assert(ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	assert(ccp.getData() == null);
	System.out.println("Received second SYNC_DONE");
	*/
	
	// Now let the real part of the experiment start..................
	initStats = expt.getAllStats();
	
	String randomFileName = expt.getUnInterestedFileName();
	expt.issueDemandRead(9, 10, randomFileName, 0, 10, 0);
	expt.sendRead(10, randomFileName, 0, 10);
	
	ccp = expt.recv(10);
	assert(ccp.getSignalType() == CoordCommPacket.READ_DONE);
	assert(ccp.getData() instanceof AcceptStamp);
	
	/*
	finalStats = expt.getAllStats();
	diffStats = finalStats.getDiff(initStats);
	System.out.println(" *** for first read" + diffStats);
	*/
	/*
	  //second read
	initStats = expt.getAllStats();
	
	randomFileName = expt.getUnInterestedFileName();
	expt.issueDemandRead(9, 10, randomFileName, 0, 10000, 0);
	expt.sendRead(10, randomFileName, 0, 10);
	
	ccp = expt.recv(10);
	assert(ccp.getSignalType() == CoordCommPacket.READ_DONE);
	assert(ccp.getData() instanceof AcceptStamp);
	*/
	System.out.println("****Read done" + (AcceptStamp)ccp.getData());
	finalStats = expt.getAllStats();
	diffStats = finalStats.getDiff(initStats);
	diffStats.writeToFile("Expt22.dat");
	System.out.println("---------------------------------------");
	System.out.println("" + diffStats);
	System.out.println("Exit value for node 9 = " + expt.killNode(9));
	System.out.println("Exit value for node 10 = " + expt.killNode(10));
    }
    
 /** 
 *  Perform experiment 2-4 
 **/ 
    public static void runExperiment24(CoordExpt expt)
    {
	CoordCommPacket ccp = null;
	StatsRecord initStats = null;
	StatsRecord finalStats = null;
	StatsRecord diffStats = null;
	DirectoryInterestSet dis = null;

	//start A and B
	expt.restartRMIRegistrySync();
	expt.startNode(9);
	expt.startNode(10);
	expt.waitStartNode(9);
	expt.waitStartNode(10);
	
	//Sequentially write every file and set unbound
	expt.sendPopulateFullScript(9, UNBOUND);
	ccp = expt.recv(9);
	assert(ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
	assert(ccp.getData() instanceof AcceptStamp);
	
	/* commented because the second sync will return even if the second
	   subscribed InterestSet stream is still not finished.
	   
	//case 4. subscribe Dir IS for invals
	System.out.println("original interestSet = " + expt.getDirInterestSet());
	dis = new DirectoryInterestSet(expt.getDirInterestSet());
	expt.issueSubscribe(9,
			    10,
			    AcceptVV.makeVVAllNegatives(),
			    -1L,
			    dis,
			    SUBSCRIPTION_DURATION_MS,
			    MAX_DELAY_MS);

	expt.sendSync(10, (AcceptStamp)ccp.getData());
	ccp = expt.recv(10);
	assert(ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	assert(ccp.getData() == null);
	System.out.println("Received a SYNC_DONE");
	// 10 have all interested invalidates.
       

	//Randomly write files
	expt.sendRandomWritesScript(9, expt.exptConfig.getNumWrites(), expt.numFiles, 1, UNBOUND);
	ccp = expt.recv(9);
	assert(ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
	assert(ccp.getData() instanceof AcceptStamp);

	*/

	// Now let the real part of the experiment start..................

	//subscribe the corresponding DirInterestSet for the interested file
	String randomFileName = expt.getUnInterestedFileName();
	String randomDirName = "/6/*";

	/*
	if (randomFileName.length()==6) 
	    randomDirName = randomFileName.substring(0, 
						     randomFileName.length()-4)
		+ "/*";
	else if ( randomFileName.length()==8)
	    randomDirName = randomFileName.substring(0, 
						     randomFileName.length()-6)
		+ "/*";
	else
	randomDirName = randomFileName.substring(0, randomFileName.length()-2)
	    +"/*";
	       */ 
	System.out.println("new interestSet = " + randomDirName);
	dis = new DirectoryInterestSet(randomDirName);	
	
	initStats = expt.getAllStats();
	expt.issueSubscribe(9,
			    10,
			    AcceptVV.makeVVAllNegatives(),
			    -1L,
			    dis,
			    SUBSCRIPTION_DURATION_MS,
			    MAX_DELAY_MS);
	
	expt.sendSync(10, (AcceptStamp)ccp.getData());
	ccp = expt.recv(10);
	assert(ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	assert(ccp.getData() == null);
	System.out.println("Received second SYNC_DONE");
	
	expt.issueDemandRead(9, 10, randomFileName, 0, 10, 0);
	expt.sendRead(10, randomFileName, 0, 10);
	
	ccp = expt.recv(10);
	assert(ccp.getSignalType() == CoordCommPacket.READ_DONE);
	assert(ccp.getData() instanceof AcceptStamp);
	
	System.out.println("****Read done" + (AcceptStamp)ccp.getData());
	finalStats = expt.getAllStats();
	diffStats = finalStats.getDiff(initStats);
	diffStats.writeToFile("Expt24.dat");
	System.out.println("---------------------------------------");
	System.out.println("" + diffStats);
	System.out.println("Exit value for node 9 = " + expt.killNode(9));
	System.out.println("Exit value for node 10 = " + expt.killNode(10));
    }
    
 /** 
 *  Perform experiment actions 
 **/ 
    public static void runExperiment26(CoordExpt expt)
    {
	CoordCommPacket ccp = null;
	StatsRecord initStats = null;
	StatsRecord finalStats = null;
	StatsRecord diffStats = null;
	DirectoryInterestSet dis = null;

	//start A and B
	expt.restartRMIRegistrySync();
	expt.startNode(9);
	expt.startNode(10);
	expt.waitStartNode(9);
	expt.waitStartNode(10);
	
	//Sequentially write every file and set unbound
	expt.sendPopulateFullScript(9, UNBOUND);
	ccp = expt.recv(9);
	assert(ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
	assert(ccp.getData() instanceof AcceptStamp);
	
	/*
	//case 6. subscribe file IS for invals
	System.out.println("original interestSet = " + expt.getFileInterestSet());
	dis = new DirectoryInterestSet(expt.getFileInterestSet());
	expt.issueSubscribe(9,
			    10,
			    AcceptVV.makeVVAllNegatives(),
			    -1L,
			    dis,
			    SUBSCRIPTION_DURATION_MS,
			    MAX_DELAY_MS);

	expt.sendSync(10, (AcceptStamp)ccp.getData());
	ccp = expt.recv(10);
	assert(ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	assert(ccp.getData() == null);
	System.out.println("Received a SYNC_DONE");
	// 10 have all interested invalidates.

	//Randomly write files
	expt.sendRandomWritesScript(9, expt.exptConfig.getNumWrites(), expt.numFiles, 1, UNBOUND);
	ccp = expt.recv(9);
	assert(ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
	assert(ccp.getData() instanceof AcceptStamp);
	*/

	// Now let the real part of the experiment start..................
	initStats = expt.getAllStats();

	//subscribe new file
	String randomFileName = expt.getUnInterestedFileName();
	System.out.println("new interestSet = " + randomFileName);
	dis = new DirectoryInterestSet(randomFileName);	
	expt.issueSubscribe(9,
			    10,
			    AcceptVV.makeVVAllNegatives(),
			    -1L,
			    dis,
			    SUBSCRIPTION_DURATION_MS,
			    MAX_DELAY_MS);
	
	expt.sendSync(10, (AcceptStamp)ccp.getData());
	ccp = expt.recv(10);
	assert(ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	assert(ccp.getData() == null);
	System.out.println("Received second SYNC_DONE");
	//Note:: the first subscribe might make the sync return
	// so at this time the file might still not exist

	expt.issueDemandRead(9, 10, randomFileName, 0, 10, 0);
	expt.sendRead(10, randomFileName, 0, 10);
	
	ccp = expt.recv(10);
	assert(ccp.getSignalType() == CoordCommPacket.READ_DONE);
	assert(ccp.getData() instanceof AcceptStamp);
	
	System.out.println("****Read done" + (AcceptStamp)ccp.getData());
	finalStats = expt.getAllStats();
	diffStats = finalStats.getDiff(initStats);
	diffStats.writeToFile("Expt26.dat");
	System.out.println("---------------------------------------");
	System.out.println("" + diffStats);
	System.out.println("Exit value for node 9 = " + expt.killNode(9));
	System.out.println("Exit value for node 10 = " + expt.killNode(10));
    }
 /** 
 *  Program starting point 
 **/ 
    public static void main(String[] argv)
    {
	CoordExpt coord = null;

	if (argv.length < 2){
	    System.out.println("Usage: <exptConfigfile> <shellType>");
	    System.exit(-1);
	}

	coord = new CoordExpt(argv[0], argv[1]);
	/*
	CoordExpt.runExperiment21(coord);
	CoordExpt.runExperiment22(coord);
	CoordExpt.runExperiment24(coord);
	CoordExpt.runExperiment26(coord);
	
	*/

	//CoordExpt.runExperiment2(coord);
	CoordExpt.runSmallExpt(coord);
    }
}




