 /** 
 *  Global Coordinator Base Class For Experiment 2 
 *  Read scripts from standard input 
 **/ 
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.HashMap;
import java.util.Random;

public class CoordExpt2 extends CoordExptA
{
    public final static boolean BOUND = true;
    public final static boolean UNBOUND = false;
    private Random rand;

    public CoordExpt2(String exptConfigFileName, String shellType_){
	super(exptConfigFileName, shellType_);
	this.rand = new Random(1977);
    }
 /** 
 *  Send a write message to the receiver 
 **/ 
    public void sendWrite(int nodeId, String filename, long offset, long length, boolean bound)
    {
	OutputStream os = null;
	PrintStream ps = null;

	os = this.getProcessOutputStream(nodeId);
	ps = new PrintStream(os);
	ps.println("w " + filename + " " + offset + " " + length + " " + (bound ? 1 : 0));
	try{
	    os.flush();
	}catch(IOException e){
	    System.err.println("Failed to send all object mods over stdout" +
			       e);
	    e.printStackTrace();
	}
    }

 /** 
 *  Send a getAcceptstamp message to the receiver and wait for a reply 
 **/ 
    public void sendGetAcceptStamp(int nodeId)
    {
	OutputStream os = null;
	PrintStream ps = null;

	os = this.getProcessOutputStream(nodeId);
	ps = new PrintStream(os);
	ps.println("g " + nodeId);
	try{
	    os.flush();
	}catch(IOException e){
	    System.err.println("Failed to send all object mods over stdout" +
			       e);
	    e.printStackTrace();
	}
    }

 /** 
 *  Send the populate script to standard output for node nodeId 
 **/ 
    public void sendPopulateFullScript(int nodeId, boolean bound)
    {
	OutputStream os = null;
	PrintStream ps = null;

	os = this.getProcessOutputStream(nodeId);
	this.senderScriptGen.createSequentialWrites(this.numFiles,
						    this.exptConfig.getFileSize(),
						    bound,
						    os);
	ps = new PrintStream(os);
	ps.println("g " + nodeId);
	try{
	    os.flush();
	}catch(IOException e){
	    System.err.println("Failed to send all object mods over stdout" +
			       e);
	    e.printStackTrace();
	}
    }

 /** 
 *  Get a Random File Name which does not overlapping my current InterestSet 
 **/ 
    public String getUnInterestedFileName(){
	long depth = 0;
	long lastFileNum = this.exptConfig.getNumFiles()-1;
	String str = "/";
	int rootnum = 0; //anything but 0
	while (rootnum == 0)
	    rootnum = (int)(this.rand.nextDouble() * 10);
	
	str += rootnum;

	while (lastFileNum >0){
	    assert((lastFileNum %10) == 9);
	    depth++;
	    lastFileNum = lastFileNum/10;
	}
	for (int i = 0; i <depth-1; i++){
	    str += "/";
	    str += (long)(this.rand.nextDouble() * 10); 
	}
	return str;
    }

 /** 
 *  Get 1% directory InterestSet String 
 **/ 
    public String getDirInterestSet(){
	if (this.exptConfig.getNumFiles()<=1000) return "/0/*";
	return "/0/0/*";
    }

    //------------------------------------------------------------------------
    // Get 10% File InterestSet String Under the 1% Dir InterestSet
    //------------------------------------------------------------------------
    public String getFileInterestSet(){
	String pre = "/0/0";
	String str = "";
	long depth = 0;
	long lastFileNum = this.exptConfig.getNumFiles()-1;
	long dirnum = 0;
	while (lastFileNum >0){
	    assert((lastFileNum %10) == 9);
	    depth++;
	    lastFileNum = lastFileNum/10;
	}
	
	dirnum = depth-3;
	long total = (long)Math.pow(10, dirnum);
	str = pre + this.senderScriptGen.createFileName(0, total)+"/0";
	
	for (int i = 1; i < total; i++){
	    str = str + ":" + pre + this.senderScriptGen.createFileName(i, total)+"/0";
	}
	
	//TEMPORARY
	//if (this.exptConfig.getNumFiles()<=1000) return "/0/0";
	//return "/0/0/0";
	return str;
    }

    //-----------------------------------------------------------------------
    // Perform experiment actions for 2
    //-----------------------------------------------------------------------
    public static void runExperiment(CoordExpt expt)
    {
	CoordCommPacket ccp = null;
	StatsRecord initStats = null;
	StatsRecord finalStats = null;
	StatsRecord diffStats = null;
	DirectoryInterestSet dis = null;
	
	System.out.println("Start expt21.....");
	//start A and B
	expt.restartRMIRegistrySync();
	expt.startNode(9);
	expt.startNode(10);
	expt.waitStartNode(9);
	expt.waitStartNode(10);
	
	expt.sendWrite(9, "/a", 0, 1000, UNBOUND);
	//subscribe for an outside file
	expt.issueSubscribe(9,
			    10,
			    AcceptVV.makeVVAllNegatives(),
			    -1L,
			    new DirectoryInterestSet("/a"),
			    SUBSCRIPTION_DURATION_MS,
			    MAX_DELAY_MS);

	//write all the files
	//CoordCommPacket.setD(true);
	expt.sendPopulateFullScript(9, UNBOUND);
	ccp = expt.recv(9);
	assert(ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
	assert(ccp.getData() instanceof AcceptStamp);
	
	//wait till all invalidate arrive for the outside subscribe
	expt.sendSync(10, (AcceptStamp)ccp.getData());
	ccp = expt.recv(10);
	assert(ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	assert(ccp.getData() == null);
	System.out.println("Received first SYNC_DONE");

	//subscribe for interestSet "/" case 0
	initStats= expt.getAllStats();
	expt.issueSubscribe(9,
			    10,
			    AcceptVV.makeVVAllNegatives(),
			    -1L,
			    new DirectoryInterestSet("/*"),
			    SUBSCRIPTION_DURATION_MS,
			    MAX_DELAY_MS);
	
	expt.issueDemandRead(9, 10, "/9/9/9", 0, 1000, 5);
	//expt.sendWrite(9, "/0/0/0", 0, 1000, UNBOUND);
	expt.sendRead(10, "/9/9/9", 0, 1000);

	ccp = expt.recv(10);
	assert(ccp.getSignalType() == CoordCommPacket.READ_DONE);
	assert(ccp.getData() instanceof AcceptStamp);
	
	//subscribe for interestSet "/0/*" 10% case 1
	//subscribe for interestSet "/0/0/*"" 1% case 2
	//subscribe for all the interestSet files case 3
	
	System.out.println("****Read done" + (AcceptStamp)ccp.getData());
	finalStats = expt.getAllStats();
	diffStats = finalStats.getDiff(initStats);
	diffStats.writeToFile("Expt21.dat");
	System.out.println("---------------------------------------");
	System.out.println("" + diffStats);
	System.out.println("Exit value for node 9 = " + expt.killNode(9));
	System.out.println("Exit value for node 10 = " + expt.killNode(10));
    }

    //-----------------------------------------------------------------------
    // Program starting point
    //-----------------------------------------------------------------------
    public static void main(String[] argv)
    {
	CoordExpt coord = null;

	if (argv.length < 2){
	    System.out.println("Usage: <exptConfigfile> <shellType>");
	    System.exit(-1);
	}
	coord = new CoordExpt(argv[0], argv[1]);
	//for (int i = 0; i <10; i++)
	//  System.err.println("get Name: "+coord.getUnInterestedFileName());
	CoordExpt.runExperiment(coord);
    }
}
