 /** 
 *  Global Coordinator For Experiment 2 Case 4 ("/0/0", "/0/0") 
 *  Read scripts from standard input 
 *  Currently have 4 kinds of commands: subscribe, subscribeBody, 
 *                                      issueDemandRead, and sleep 
 **/ 
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.HashMap;
import java.util.Random;

public class CoordExpt24 extends CoordExpt2
{
    public CoordExpt24(String exptConfigFileName, String shellType_){
	super(exptConfigFileName, shellType_);
    }
    
 /** 
 *  Perform experiment actions for 2 
 **/ 
    public static void runExperiment(CoordExpt expt)
    {
	CoordCommPacket ccp = null;
	StatsRecord initStats = null;
	StatsRecord finalStats = null;
	StatsRecord diffStats = null;
	DirectoryInterestSet dis = null;
	
	System.out.println("Start expt24.....");
	//start A and B
	expt.restartRMIRegistrySync();
	expt.startNode(9);
	expt.startNode(10);
	expt.waitStartNode(9);
	expt.waitStartNode(10);
	
	expt.sendWrite(9, "/a", 0, 1000, UNBOUND);
	//subscribe for an outside file
	expt.issueSubscribe(9,
			    10,
			    AcceptVV.makeVVAllNegatives(),
			    -1L,
			    new DirectoryInterestSet("/a"),
			    SUBSCRIPTION_DURATION_MS,
			    MAX_DELAY_MS);

	System.err.println("Here");

	//write all the files
	expt.sendPopulateFullScript(9, UNBOUND);
	ccp = expt.recv(9);
	assert(ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
	assert(ccp.getData() instanceof AcceptStamp);
	
	//wait till all invalidate arrive for the outside subscribe
	expt.sendSync(10, (AcceptStamp)ccp.getData());
	ccp = expt.recv(10);
	assert(ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	assert(ccp.getData() == null);
	System.out.println("Received first SYNC_DONE");

	//subscribe for interestSet "/" case 0
	initStats= expt.getAllStats();
	expt.issueSubscribe(9,
			    10,
			    AcceptVV.makeVVAllNegatives(),
			    -1L,
			    new DirectoryInterestSet("/0/0/*"),
			    SUBSCRIPTION_DURATION_MS,
			    MAX_DELAY_MS);
	
	expt.issueDemandRead(9, 10, "/9/9/9", 0, 1000, 5);
	expt.sendRead(10, "/9/9/9", 0, 1000);

	ccp = expt.recv(10);
	assert(ccp.getSignalType() == CoordCommPacket.READ_DONE);
	assert(ccp.getData() instanceof AcceptStamp);
	
	//subscribe for interestSet "/0/*" 10% case 1
	//subscribe for interestSet "/0/0/*"" 1% case 2
	//subscribe for all the interestSet files case 3
	
	System.out.println("****Read done" + (AcceptStamp)ccp.getData());
	finalStats = expt.getAllStats();
	diffStats = finalStats.getDiff(initStats);
	diffStats.writeToFile("Expt24.dat");
	System.out.println("---------------------------------------");
	System.out.println("" + diffStats);
	System.out.println("Exit value for node 9 = " + expt.killNode(9));
	System.out.println("Exit value for node 10 = " + expt.killNode(10));
    }

    //-----------------------------------------------------------------------
    // Program starting point
    //-----------------------------------------------------------------------
    public static void main(String[] argv)
    {
	CoordExpt24 coord = null;

	if (argv.length < 2){
	    System.out.println("Usage: <exptConfigfile> <shellType>");
	    System.exit(-1);
	}
	coord = new CoordExpt24(argv[0], argv[1]);
	//for (int i = 0; i <10; i++)
	//  System.err.println("get Name: "+coord.getUnInterestedFileName());
	CoordExpt24.runExperiment(coord);
    }
}
