import java.io.*;

public class TIExpt extends CoordExptA{
    
    public static final int PHONE = 9;
    public static final int PDA = 10;
    public static final int LAPTOP = 11;
    public static final int SERVER = 12;

    public static final int PHONE_READ_SYNC = 99;
    public static final int PDA_READ_SYNC = 999;
    public static final int LAPTOP_READ_SYNC = 9999;
    public static final int SERVER_READ_SYNC = 99999;

    public static long SUBSCRIPTION_TIMEOUT_MS = 3000000; // 3000 SECONDS
    public static long MAX_DELAY_MS = 3000; // 3000 seconds
    
    public TIExpt(String exptConfigFileName, String shellType){
	super(exptConfigFileName, shellType);
    }

    public void sendPartialWritesScript(int nodeId, boolean bound){
	double dirPct = 0.0;
	double filePct = 0.0;
	
	switch(nodeId){
	case PHONE:
	    dirPct = 0.001;
	    filePct = 1.0;
	    break;
	case PDA:
	    dirPct = 0.01;
	    filePct = 1.0;
	    break;
	case LAPTOP:
	    dirPct = 0.1;
	    filePct = 1.0;
	    break;
	case SERVER:
	    dirPct = 1.0;
	    filePct = 1.0;
	    break;
	default:
	    System.err.println("Unrecoganized type!!!");
	    System.exit(-1);
	}
	super.sendPartialWritesScript(nodeId, dirPct, filePct, bound);
    }


    public void sendRandomPartialWritesScript(int nodeId, boolean bound){
	double dirPct = 0.0;
	double filePct = 0.0;
	long numWrites = 0;

	switch(nodeId){
	case PHONE:
	    dirPct = 0.001;
	    filePct = 1.0;
	    break;
	case PDA:
	    dirPct = 0.01;
	    filePct = 1.0;
	    break;
	case LAPTOP:
	    dirPct = 0.1;
	    filePct = 1.0;
	    break;
	case SERVER:
	    dirPct = 1.0;
	    filePct = 1.0;
	    break;
	default:
	    System.err.println("Unrecoganized type!!!");
	    System.exit(-1);
	}
	numWrites = Math.round(numFiles * dirPct * filePct * 0.01);
	super.sendRandomWritesScript(nodeId, numWrites, numFiles, dirPct*filePct, bound);
    }

    public String getFileName(long n){
	long numLen = Math.round(Math.log(numFiles)/Math.log(10));
	int fileLen = 2 * (int)numLen; // including /'s as seperator
	byte [] bName = new byte[fileLen];
	for(int i=0; i<fileLen; i++){
	    if(i%2 == 0){// even position
		bName[i] = '/';
	    } else {// odd position
		long base = Math.round(Math.pow(10, numLen-(i+1)/2));
		bName[i] = (byte) ('0' + n/base);
		n = n%base;
		assert(bName[i]>='0' && bName[i]<='9');
	    }
	}
	return new String(bName);
    }

    public DirectoryInterestSet getInterestSet(int nodeId){
	DirectoryInterestSet dis = null;

	switch(nodeId){
	case PHONE:
	    dis = new DirectoryInterestSet("/0/0/0/*");
	    break;
	case PDA:
	    dis = new DirectoryInterestSet("/0/0/*");
	    break;
	case LAPTOP:
	    dis = new DirectoryInterestSet("/0/*");
	    break;
	case SERVER:
	    dis = new DirectoryInterestSet("/*");
	    break;
	default:
	    System.err.println("Unimplemented");
	    System.exit(-1);
	    break;
	}
	return(dis);
    }

    public VV getHighestTimeStamps(int nodeId){
	OutputStream os = getProcessOutputStream(nodeId);
	PrintStream ps = new PrintStream(os);
	ps.println("v");
	try{
	    os.flush();
	}catch (IOException e){
	    System.err.println("Failed to send all object mods over stdout" + e);
	    e.printStackTrace();
	}
	CoordCommPacket ccp = recv(nodeId);
	assert(ccp.getSignalType() == CoordCommPacket.CURRENT_VV);
	assert(ccp.getData() instanceof VV);
	VV cvv = (VV)ccp.getData();
	return cvv;
    }

    public static void startup(TIExpt expt, boolean all){
	expt.startNode(PHONE);
	expt.startNode(PDA);
	if(all){
	    expt.startNode(SERVER);
	    expt.startNode(LAPTOP);
	}
	expt.waitStartNode(PHONE);
	expt.waitStartNode(PDA);
	if(all){
	    expt.waitStartNode(LAPTOP);
	    expt.waitStartNode(SERVER);
	}
    }

    public static void runExperiment1(TIExpt expt){
	boolean all = true;
	
	CoordCommPacket done_ccp = null;
	CoordCommPacket pda_ccp = null;
	CoordCommPacket phone_ccp = null;
	CoordCommPacket laptop_ccp = null;
	DirectoryInterestSet pda_dis = null;
	DirectoryInterestSet phone_dis = null;
	DirectoryInterestSet laptop_dis = null;
	StatsRecord initStats = null;
	StatsRecord finalStats = null;
	StatsRecord diffStats = null;
	CounterVV laptop_cvv = null;
	CounterVV pda_cvv = null;
	CounterVV phone_cvv = null;

	startup(expt, all);

	// Initial data population
	if(all){
	    expt.sendRandomPartialWritesScript(LAPTOP, true);
	    laptop_ccp = expt.recv(LAPTOP);
	    assert(laptop_ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
	    assert(laptop_ccp.getData() instanceof AcceptStamp);
	}

	expt.sendRandomPartialWritesScript(PDA, true);
	pda_ccp = expt.recv(PDA);
	assert(pda_ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
	assert(pda_ccp.getData() instanceof AcceptStamp);

	expt.sendRandomPartialWritesScript(PHONE, true);
	phone_ccp = expt.recv(PHONE);
	assert(phone_ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
	assert(phone_ccp.getData() instanceof AcceptStamp);

	// get experimental specific interest sets
	pda_dis = expt.getInterestSet(SERVER); 
	phone_dis = expt.getInterestSet(SERVER);
	laptop_dis = expt.getInterestSet(SERVER);

	initStats = expt.getAllStats();
	long startT = System.currentTimeMillis();

	// pda subscribe to laptop
	if(all){
	    expt.issueSubscribe(LAPTOP, PDA, AcceptVV.makeVVAllNegatives(), -1L,
				pda_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);
	    expt.sendSync(PDA, (AcceptStamp)laptop_ccp.getData());
	}
	
	// pda subscribe to phone
	expt.issueSubscribe(PHONE, PDA, AcceptVV.makeVVAllNegatives(), -1L,
			    pda_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);
	expt.sendSync(PDA, (AcceptStamp)phone_ccp.getData());

 	// laptop subscribe to pda, but also sync for phone writes
	if(all){
	    expt.issueSubscribe(PDA, LAPTOP, AcceptVV.makeVVAllNegatives(), -1L,
				laptop_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);
	    expt.sendSync(LAPTOP, (AcceptStamp)pda_ccp.getData());
	    expt.sendSync(LAPTOP, (AcceptStamp)phone_ccp.getData());
	}

        // phone subscribe to pda, but also sync for laptop writes
	expt.issueSubscribe(PDA, PHONE, AcceptVV.makeVVAllNegatives(), -1L,
			    phone_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);
	expt.sendSync(PHONE, (AcceptStamp)pda_ccp.getData());
	if(all){
	    expt.sendSync(PHONE, (AcceptStamp)laptop_ccp.getData());
	}

        done_ccp = expt.recv(PDA);
	assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	assert(done_ccp.getData() == null);
	System.out.println("Received a SYNC_DONE from node " + PDA);
	if(all){
	    done_ccp = expt.recv(PDA);
	    assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	    assert(done_ccp.getData() == null);
	    System.out.println("Received a SYNC_DONE from node " + PDA);
	}

	done_ccp = expt.recv(PHONE);
	assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	assert(done_ccp.getData() == null);
	System.out.println("Received a SYNC_DONE from node " + PHONE);
	
	if(all){
	    done_ccp = expt.recv(PHONE);
	    assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	    assert(done_ccp.getData() == null);
	    System.out.println("Received a SYNC_DONE from node " + PHONE);
	    done_ccp = expt.recv(LAPTOP);
	    assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	    assert(done_ccp.getData() == null);
	    System.out.println("Received a SYNC_DONE from node " + LAPTOP);
	    done_ccp = expt.recv(LAPTOP);
	    assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	    assert(done_ccp.getData() == null);
	    System.out.println("Received a SYNC_DONE from node " + LAPTOP);
	}

	long endT = System.currentTimeMillis();
	finalStats = expt.getAllStats();
	diffStats = finalStats.getDiff(initStats);
	System.out.println(diffStats);
	System.out.println("Total_time " + (endT-startT) + "ms");
	phone_cvv = (CounterVV)expt.getHighestTimeStamps(PHONE);
	pda_cvv = (CounterVV)expt.getHighestTimeStamps(PDA);
	laptop_cvv = null;
	if(all){
	    laptop_cvv = (CounterVV)expt.getHighestTimeStamps(LAPTOP);
	}

	assert(pda_cvv.equals(phone_cvv));
	if(all){
	    assert(pda_cvv.equals(laptop_cvv));
	}

	System.out.println("---------------------------------------");
	System.out.println("Exit value for node " + PHONE + " = " + expt.killNode(PHONE));
	System.out.println("Exit value for node " + PDA + " = " + expt.killNode(PDA));
	if(all){
	    System.out.println("Exit value for node " + LAPTOP + " = " + expt.killNode(LAPTOP));
	}
    }

    public static void runExperiment2(TIExpt expt){
	boolean all = true;
	
	CoordCommPacket done_ccp = null;
	CoordCommPacket pda_ccp = null;
	CoordCommPacket phone_ccp = null;
	CoordCommPacket laptop_ccp = null;
	DirectoryInterestSet pda_dis = null;
	DirectoryInterestSet phone_dis = null;
	DirectoryInterestSet laptop_dis = null;
	StatsRecord initStats = null;
	StatsRecord finalStats = null;
	StatsRecord diffStats = null;
	StatsRecord statsSummary = null;
	long startT = 0;
	long endT = 0;
	long timeSummary = 0;
	CounterVV laptop_cvv = null;
	CounterVV pda_cvv = null;
	CounterVV phone_cvv = null;

	startup(expt, all);

        // get experimental specific interest sets
	pda_dis = expt.getInterestSet(SERVER); 
	phone_dis = expt.getInterestSet(SERVER);
	laptop_dis = expt.getInterestSet(SERVER);

	// phone subscribe to pda
	expt.sendRandomPartialWritesScript(PDA, false);
	pda_ccp = expt.recv(PDA);
	assert(pda_ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
	assert(pda_ccp.getData() instanceof AcceptStamp);
	phone_cvv = (CounterVV)expt.getHighestTimeStamps(PHONE);

	initStats = expt.getAllStats();
	startT = System.currentTimeMillis();
	expt.issueSubscribe(PDA, PHONE, phone_cvv, -1L,
			    phone_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);
	expt.issueSubscribeBody(PDA, PHONE, phone_cvv, 
				expt.getInterestSet(PHONE), SUBSCRIPTION_TIMEOUT_MS);
	expt.sendSync(PHONE, (AcceptStamp)pda_ccp.getData());
        done_ccp = expt.recv(PHONE);
	assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	assert(done_ccp.getData() == null);
	System.out.println("Received a SYNC_DONE from node " + PHONE);
	// inval sync has to be done before body read sync
	// we need to read the lastest file that is within the receivers interestset && written by the sender.
	expt.sendRead(PHONE, expt.getFileName(PHONE_READ_SYNC), 0, 10000);
	done_ccp = expt.recv(PHONE);
	assert(done_ccp.getSignalType() == CoordCommPacket.READ_DONE);
	assert(done_ccp.getData() instanceof AcceptStamp);
	System.out.println(PHONE + "****Read done " + (AcceptStamp)done_ccp.getData());
	endT = System.currentTimeMillis();
	finalStats = expt.getAllStats();
	diffStats = finalStats.getDiff(initStats);	
	System.out.println(diffStats);
	System.out.println("Total_time " + (endT-startT) + "ms");
	timeSummary += endT-startT;
	statsSummary = diffStats;

	// pda subscribe to phone
	expt.sendRandomPartialWritesScript(PHONE, false);
	phone_ccp = expt.recv(PHONE);
	assert(phone_ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
	assert(phone_ccp.getData() instanceof AcceptStamp);
	pda_cvv = (CounterVV)expt.getHighestTimeStamps(PDA);

	initStats = expt.getAllStats();
	startT = System.currentTimeMillis();
	expt.issueSubscribe(PHONE, PDA, pda_cvv, -1L,
			    pda_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);
	expt.issueSubscribeBody(PHONE, PDA, pda_cvv,
				expt.getInterestSet(PDA), SUBSCRIPTION_TIMEOUT_MS);
	expt.sendSync(PDA, (AcceptStamp)phone_ccp.getData());
        done_ccp = expt.recv(PDA);
	assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	assert(done_ccp.getData() == null);
	System.out.println("Received a SYNC_DONE from node " + PDA);
	// inval sync has to be done before body read sync
	// we need to read the lastest file that is within the receivers interestset && written by the sender.
	expt.sendRead(PDA, expt.getFileName(PHONE_READ_SYNC), 0, 10000);
	done_ccp = expt.recv(PDA);
	assert(done_ccp.getSignalType() == CoordCommPacket.READ_DONE);
	assert(done_ccp.getData() instanceof AcceptStamp);
	System.out.println(PDA + "****Read done " + (AcceptStamp)done_ccp.getData());
	endT = System.currentTimeMillis();
	finalStats = expt.getAllStats();
	diffStats = finalStats.getDiff(initStats);	
	System.out.println(diffStats);
	System.out.println("Total_time " + (endT-startT) + "ms");
	timeSummary += endT-startT;
	statsSummary = statsSummary.addStats(diffStats);

	if(all){
	    // laptop subscribe to PDA FOR updates by both phone and pda.
	    laptop_cvv = (CounterVV)expt.getHighestTimeStamps(LAPTOP);
	    
	    initStats = expt.getAllStats();
	    startT = System.currentTimeMillis();
	    expt.issueSubscribe(PDA, LAPTOP, laptop_cvv, -1L,
				laptop_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);
	    expt.issueSubscribeBody(PDA, LAPTOP, laptop_cvv,
				    expt.getInterestSet(LAPTOP), SUBSCRIPTION_TIMEOUT_MS);
	    expt.sendSync(LAPTOP, (AcceptStamp)phone_ccp.getData());
	    done_ccp = expt.recv(LAPTOP);
	    assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	    assert(done_ccp.getData() == null);
	    System.out.println("Received a SYNC_DONE from node " + LAPTOP);
	    // inval sync has to be done before body read sync
	    expt.sendRead(LAPTOP, expt.getFileName(PDA_READ_SYNC), 0, 10000);
	    done_ccp = expt.recv(LAPTOP);
	    assert(done_ccp.getSignalType() == CoordCommPacket.READ_DONE);
	    assert(done_ccp.getData() instanceof AcceptStamp);
	    System.out.println(LAPTOP + "****Read done " + (AcceptStamp)done_ccp.getData());
	    endT = System.currentTimeMillis();
	    finalStats = expt.getAllStats();
	    diffStats = finalStats.getDiff(initStats);	
	    System.out.println(diffStats);
	    System.out.println("Total_time " + (endT-startT) + "ms");
	    timeSummary += endT-startT;
	    statsSummary = statsSummary.addStats(diffStats);
	    

	// pda subscribe to laptop
	// updates from laptop will be forwarded to phone by pda
	   expt.sendRandomPartialWritesScript(LAPTOP, false);
	    laptop_ccp = expt.recv(LAPTOP);
	    assert(laptop_ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
	    assert(laptop_ccp.getData() instanceof AcceptStamp);

	    pda_cvv = (CounterVV)expt.getHighestTimeStamps(PDA);

	    initStats = expt.getAllStats();
	    startT = System.currentTimeMillis();
	    expt.issueSubscribe(LAPTOP, PDA, pda_cvv, -1L,
				pda_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);
	    expt.issueSubscribeBody(LAPTOP, PDA, pda_cvv,
				expt.getInterestSet(PDA), SUBSCRIPTION_TIMEOUT_MS);
	    expt.sendSync(PDA, (AcceptStamp)laptop_ccp.getData());
	    done_ccp = expt.recv(PDA);
	    assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	    assert(done_ccp.getData() == null);
	    System.out.println("Received a SYNC_DONE from node " + PDA);
	    expt.sendSync(PHONE, (AcceptStamp)laptop_ccp.getData());
	    done_ccp = expt.recv(PHONE);
	    assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	    assert(done_ccp.getData() == null);
	    System.out.println("Received a SYNC_DONE from node " + PHONE);
	    // inval sync has to be done before body read sync
	    expt.sendRead(PDA, expt.getFileName(PDA_READ_SYNC), 0, 10000);
	    done_ccp = expt.recv(PDA);
	    assert(done_ccp.getSignalType() == CoordCommPacket.READ_DONE);
	    assert(done_ccp.getData() instanceof AcceptStamp);
	    System.out.println(PDA + "****Read done " + (AcceptStamp)done_ccp.getData());
	    expt.sendRead(PHONE, expt.getFileName(PHONE_READ_SYNC), 0, 10000);
	    done_ccp = expt.recv(PHONE);
	    assert(done_ccp.getSignalType() == CoordCommPacket.READ_DONE);
	    assert(done_ccp.getData() instanceof AcceptStamp);
	    System.out.println(PHONE + "****Read done " + (AcceptStamp)done_ccp.getData());

	    endT = System.currentTimeMillis();
	    finalStats = expt.getAllStats();
	    diffStats = finalStats.getDiff(initStats);	
	    System.out.println(diffStats);
	    System.out.println("Total_time " + (endT-startT) + "ms");

	}



	System.out.println("=====================");
	timeSummary += endT-startT;
	statsSummary = statsSummary.addStats(diffStats);	
	System.out.println(statsSummary);
	System.out.println("Total_time " + timeSummary + "ms");
	phone_cvv = (CounterVV)expt.getHighestTimeStamps(PHONE);
	pda_cvv = (CounterVV)expt.getHighestTimeStamps(PDA);
	if(all){
	    laptop_cvv = (CounterVV)expt.getHighestTimeStamps(LAPTOP);
                }
	assert(pda_cvv.equals(phone_cvv));
	if(all){
	    assert(pda_cvv.equals(laptop_cvv));
	 }

	 System.out.println("---------------------------------------");
	System.out.println("Exit value for node " + PHONE + " = " + expt.killNode(PHONE));
	System.out.println("Exit value for node " + PDA + " = " + expt.killNode(PDA));
	System.out.println("Exit value for node " + LAPTOP + " = " + expt.killNode(LAPTOP));

    }

    public static void runExperiment3(TIExpt expt){
	boolean all = true;

	CoordCommPacket done_ccp = null;
	CoordCommPacket pda_ccp = null;
	CoordCommPacket phone_ccp = null;
	CoordCommPacket laptop_ccp = null;
	DirectoryInterestSet pda_dis = null;
	DirectoryInterestSet phone_dis = null;
	DirectoryInterestSet laptop_dis = null;
	StatsRecord initStats = null;
	StatsRecord finalStats = null;
	StatsRecord diffStats = null;
	StatsRecord statsSummary = null;
	long startT = 0;
	long endT = 0;
	long timeSummary = 0;
	CounterVV laptop_cvv = null;
	CounterVV pda_cvv = null;
	CounterVV phone_cvv = null;

	startup(expt, all);

        // get experimental specific interest sets
	pda_dis = expt.getInterestSet(PDA); 
	phone_dis = expt.getInterestSet(PHONE);
	laptop_dis = expt.getInterestSet(LAPTOP);

	// phone subscribe to pda
	expt.sendRandomPartialWritesScript(PDA, false);
	pda_ccp = expt.recv(PDA);
	assert(pda_ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
	assert(pda_ccp.getData() instanceof AcceptStamp);
	phone_cvv = (CounterVV)expt.getHighestTimeStamps(PHONE);

	initStats = expt.getAllStats();
	startT = System.currentTimeMillis();
	expt.issueSubscribe(PDA, PHONE, phone_cvv, -1L,
			    phone_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);
	expt.issueSubscribeBody(PDA, PHONE, phone_cvv, 
				phone_dis, SUBSCRIPTION_TIMEOUT_MS);
	expt.sendSync(PHONE, (AcceptStamp)pda_ccp.getData());
        done_ccp = expt.recv(PHONE);
	assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	assert(done_ccp.getData() == null);
	System.out.println("Received a SYNC_DONE from node " + PHONE);
	// inval sync has to be done before body read sync
	// we need to read the lastest file that is within the receivers interestset && written by the sender.
	expt.sendRead(PHONE, expt.getFileName(PHONE_READ_SYNC), 0, 10000);
	done_ccp = expt.recv(PHONE);
	assert(done_ccp.getSignalType() == CoordCommPacket.READ_DONE);
	assert(done_ccp.getData() instanceof AcceptStamp);
	System.out.println(PHONE + "****Read done " + (AcceptStamp)done_ccp.getData());
	endT = System.currentTimeMillis();
	finalStats = expt.getAllStats();
	diffStats = finalStats.getDiff(initStats);	
	System.out.println(diffStats);
	System.out.println("Total_time " + (endT-startT) + "ms");
	timeSummary += endT-startT;
	statsSummary = diffStats;

	// pda subscribe to phone
	expt.sendRandomPartialWritesScript(PHONE, false);
	phone_ccp = expt.recv(PHONE);
	assert(phone_ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
	assert(phone_ccp.getData() instanceof AcceptStamp);
	pda_cvv = (CounterVV)expt.getHighestTimeStamps(PDA);

	initStats = expt.getAllStats();
	startT = System.currentTimeMillis();
	expt.issueSubscribe(PHONE, PDA, pda_cvv, -1L,
			    pda_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);
	expt.issueSubscribeBody(PHONE, PDA, pda_cvv,
				pda_dis, SUBSCRIPTION_TIMEOUT_MS);
	expt.sendSync(PDA, (AcceptStamp)phone_ccp.getData());
        done_ccp = expt.recv(PDA);
	assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	assert(done_ccp.getData() == null);
	System.out.println("Received a SYNC_DONE from node " + PDA);
	// inval sync has to be done before body read sync
	// we need to read the lastest file that is within the receivers interestset && written by the sender.
	expt.sendRead(PDA, expt.getFileName(PHONE_READ_SYNC), 0, 10000);
	done_ccp = expt.recv(PDA);
	assert(done_ccp.getSignalType() == CoordCommPacket.READ_DONE);
	assert(done_ccp.getData() instanceof AcceptStamp);
	System.out.println(PDA + "****Read done " + (AcceptStamp)done_ccp.getData());
	endT = System.currentTimeMillis();
	finalStats = expt.getAllStats();
	diffStats = finalStats.getDiff(initStats);	
	System.out.println(diffStats);
	System.out.println("Total_time " + (endT-startT) + "ms");
	timeSummary += endT-startT;
	statsSummary = statsSummary.addStats(diffStats);

	if(all){
	    // laptop subscribe to PDA FOR updates by both phone and pda.
	    laptop_cvv = (CounterVV)expt.getHighestTimeStamps(LAPTOP);
	    
	    initStats = expt.getAllStats();
	    startT = System.currentTimeMillis();
	    expt.issueSubscribe(PDA, LAPTOP, laptop_cvv, -1L,
				laptop_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);
	    expt.issueSubscribeBody(PDA, LAPTOP, laptop_cvv,
				    laptop_dis, SUBSCRIPTION_TIMEOUT_MS);
	    expt.sendSync(LAPTOP, (AcceptStamp)phone_ccp.getData());
	    done_ccp = expt.recv(LAPTOP);
	    assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	    assert(done_ccp.getData() == null);
	    System.out.println("Received a SYNC_DONE from node " + LAPTOP);
	    // inval sync has to be done before body read sync
	    expt.sendRead(LAPTOP, expt.getFileName(PDA_READ_SYNC), 0, 10000);
	    done_ccp = expt.recv(LAPTOP);
	    assert(done_ccp.getSignalType() == CoordCommPacket.READ_DONE);
	    assert(done_ccp.getData() instanceof AcceptStamp);
	    System.out.println(LAPTOP + "****Read done " + (AcceptStamp)done_ccp.getData());
	    endT = System.currentTimeMillis();
	    finalStats = expt.getAllStats();
	    diffStats = finalStats.getDiff(initStats);	
	    System.out.println(diffStats);
	    System.out.println("Total_time " + (endT-startT) + "ms");
	    timeSummary += endT-startT;
	    statsSummary = statsSummary.addStats(diffStats);
	    
	// pda subscribe to laptop
	// updates from laptop will be forwarded to phone by pda
	    expt.sendRandomPartialWritesScript(LAPTOP, false);
	    laptop_ccp = expt.recv(LAPTOP);
	    assert(laptop_ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
	    assert(laptop_ccp.getData() instanceof AcceptStamp);

	    pda_cvv = (CounterVV)expt.getHighestTimeStamps(PDA);

	    initStats = expt.getAllStats();
	    startT = System.currentTimeMillis();
	    expt.issueSubscribe(LAPTOP, PDA, pda_cvv, -1L,
				pda_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);
	    expt.issueSubscribeBody(LAPTOP, PDA, pda_cvv,
				pda_dis, SUBSCRIPTION_TIMEOUT_MS);
	    expt.sendSync(PDA, (AcceptStamp)laptop_ccp.getData());
	    done_ccp = expt.recv(PDA);
	    assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	    assert(done_ccp.getData() == null);
	    System.out.println("Received a SYNC_DONE from node " + PDA);
	    expt.sendSync(PHONE, (AcceptStamp)laptop_ccp.getData());
	    done_ccp = expt.recv(PHONE);
	    assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	    assert(done_ccp.getData() == null);
	    System.out.println("Received a SYNC_DONE from node " + PHONE);
	    // inval sync has to be done before body read sync
	    expt.sendRead(PDA, expt.getFileName(PDA_READ_SYNC), 0, 10000);
	    done_ccp = expt.recv(PDA);
	    assert(done_ccp.getSignalType() == CoordCommPacket.READ_DONE);
	    assert(done_ccp.getData() instanceof AcceptStamp);
	    System.out.println(PDA + "****Read done " + (AcceptStamp)done_ccp.getData());
	    expt.sendRead(PHONE, expt.getFileName(PHONE_READ_SYNC), 0, 10000);
	    done_ccp = expt.recv(PHONE);
	    assert(done_ccp.getSignalType() == CoordCommPacket.READ_DONE);
	    assert(done_ccp.getData() instanceof AcceptStamp);
	    System.out.println(PHONE + "****Read done " + (AcceptStamp)done_ccp.getData());

	    endT = System.currentTimeMillis();
	    finalStats = expt.getAllStats();
	    diffStats = finalStats.getDiff(initStats);	
	    System.out.println(diffStats);
	    System.out.println("Total_time " + (endT-startT) + "ms");
	    timeSummary += endT-startT;
	    statsSummary = statsSummary.addStats(diffStats);
	}



	System.out.println("=====================");
	System.out.println(statsSummary);
	System.out.println("Total_time " + timeSummary + "ms");
	phone_cvv = (CounterVV)expt.getHighestTimeStamps(PHONE);
	pda_cvv = (CounterVV)expt.getHighestTimeStamps(PDA);
	if(all){
	    laptop_cvv = (CounterVV)expt.getHighestTimeStamps(LAPTOP);
                }
	assert(pda_cvv.equals(phone_cvv));
	if(all){
	    assert(pda_cvv.equals(laptop_cvv));
	 }

	 System.out.println("---------------------------------------");
	System.out.println("Exit value for node " + PHONE + " = " + expt.killNode(PHONE));
	System.out.println("Exit value for node " + PDA + " = " + expt.killNode(PDA));
	System.out.println("Exit value for node " + LAPTOP + " = " + expt.killNode(LAPTOP));
    }


    public static void main(String[] argv){
	TIExpt expt = null;
	int exptNum = 1 ;

	if(argv.length < 2){
	    System.out.println("Usage: <exptConfigfile> <shellType>");
	    System.exit(-1);
	}

	if(argv.length > 2) {
	    exptNum = new Integer(argv[2]).intValue() ;
	}

	expt = new TIExpt(argv[0], argv[1]);
	
	if(exptNum == 1) {
	    runExperiment1(expt); // bayou approach
	}
	else if(exptNum == 2) {
	    runExperiment2(expt); 
	}
	else if(exptNum == 3) {
	    runExperiment3(expt);
	}
	else {
	    System.err.println("Experiment number "+exptNum+" not defined here") ;
	    assert(false) ;
	}
    }
	
}

/*
 * $Log
 */
