import java.io.*;

public class TIExptB extends TIExpt{
    
    public TIExptB(String exptConfigFileName, String shellType){
	super(exptConfigFileName, shellType);
    }

    public static CoordCommPacket createWrites(TIExpt expt, int nodeId, boolean bound){
	CoordCommPacket ccp = null;
	expt.sendRandomPartialWritesScript(nodeId, bound);
	ccp = expt.recv(nodeId);
	assert(ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
	assert(ccp.getData() instanceof AcceptStamp);
	return ccp;
    }

    public static void startup(TIExpt expt, boolean all){
	expt.startNode(PHONE);
	expt.startNode(PDA);
	if(all){
	    expt.startNode(LAPTOP);
	    expt.startNode(SERVER);
	}
	expt.waitStartNode(PHONE);
	expt.waitStartNode(PDA);
	if(all){
	    expt.waitStartNode(LAPTOP);
	    expt.waitStartNode(SERVER);
	}
    }

    public static void finalize(TIExpt expt, long timeSummary, StatsRecord statsSummary, boolean all){
	System.out.println("=====================");
	System.out.println(statsSummary);
	System.out.println("Total_time " + timeSummary + "ms");
	CounterVV phone_cvv = (CounterVV)expt.getHighestTimeStamps(PHONE);
	CounterVV pda_cvv = (CounterVV)expt.getHighestTimeStamps(PDA);
	CounterVV laptop_cvv = null;
	CounterVV server_cvv = null;
	if(all){
	    laptop_cvv = (CounterVV)expt.getHighestTimeStamps(LAPTOP);
	    server_cvv = (CounterVV)expt.getHighestTimeStamps(SERVER);
                }
	assert(pda_cvv.equals(phone_cvv));
	if(all){
	    assert(pda_cvv.equals(laptop_cvv));
	    assert(pda_cvv.equals(server_cvv));
	 }

	System.out.println("---------------------------------------");
	System.out.println("Exit value for node " + PHONE + " = " + expt.killNode(PHONE));
	System.out.println("Exit value for node " + PDA + " = " + expt.killNode(PDA));
	System.out.println("Exit value for node " + LAPTOP + " = " + expt.killNode(LAPTOP));
	System.out.println("Exit value for node " + SERVER + " = " + expt.killNode(SERVER));
    }

    public static void runExperiment1(TIExptB expt){
	boolean all = true;
	
	CoordCommPacket done_ccp = null;
	CoordCommPacket pda_ccp = null;
	CoordCommPacket phone_ccp = null;
	CoordCommPacket laptop_ccp = null;
	CoordCommPacket server_ccp = null;
	DirectoryInterestSet pda_dis = null;
	DirectoryInterestSet phone_dis = null;
	DirectoryInterestSet laptop_dis = null;
	DirectoryInterestSet server_dis = null;
	StatsRecord initStats = null;
	StatsRecord finalStats = null;
	StatsRecord diffStats = null;
	CounterVV laptop_cvv = null;
	CounterVV pda_cvv = null;
	CounterVV phone_cvv = null;
	CounterVV server_cvv = null;

	startup(expt, all);


	initStats = expt.getAllStats();
	long startT = System.currentTimeMillis();

	// Initial data population
	if(all){
	    server_ccp = createWrites(expt, SERVER, true);
	    laptop_ccp = createWrites(expt, LAPTOP, true);
	}
	pda_ccp =  createWrites(expt, PDA, true);
	phone_ccp = createWrites(expt, PHONE, true);


	// get experimental specific interest sets
	pda_dis = expt.getInterestSet(SERVER); 
	phone_dis = expt.getInterestSet(SERVER);
	laptop_dis = expt.getInterestSet(SERVER);
	server_dis = expt.getInterestSet(SERVER);

	// pda subscribe to laptop
	if(all){
	    expt.issueSubscribe(LAPTOP, PDA, AcceptVV.makeVVAllNegatives(), -1L,
				pda_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);
	    expt.sendSync(PDA, (AcceptStamp)laptop_ccp.getData());
	}
	
	// pda subscribe to phone
	expt.issueSubscribe(PHONE, PDA, AcceptVV.makeVVAllNegatives(), -1L,
			    pda_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);
	expt.sendSync(PDA, (AcceptStamp)phone_ccp.getData());

 	// laptop subscribe to pda, but also sync for phone writes
	if(all){
	    expt.issueSubscribe(PDA, LAPTOP, AcceptVV.makeVVAllNegatives(), -1L,
				laptop_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);
	    expt.sendSync(LAPTOP, (AcceptStamp)pda_ccp.getData());
	    expt.sendSync(LAPTOP, (AcceptStamp)phone_ccp.getData());
	}

        // phone subscribe to pda, but also sync for laptop writes
	expt.issueSubscribe(PDA, PHONE, AcceptVV.makeVVAllNegatives(), -1L,
			    phone_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);
	expt.sendSync(PHONE, (AcceptStamp)pda_ccp.getData());
	if(all){
	    expt.sendSync(PHONE, (AcceptStamp)laptop_ccp.getData());
	}

	//  laptop subscribe server
	if(all){
	    expt.issueSubscribe(SERVER, LAPTOP, AcceptVV.makeVVAllNegatives(), -1L,
				laptop_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);
	    expt.sendSync(LAPTOP, (AcceptStamp)server_ccp.getData());
	    expt.sendSync(PHONE, (AcceptStamp)server_ccp.getData());
	    expt.sendSync(PDA, (AcceptStamp)server_ccp.getData());
	    
	    // server subscribe to laptop, pda, phone
	    expt.issueSubscribe(LAPTOP, SERVER, AcceptVV.makeVVAllNegatives(), -1L,
				server_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);
	    expt.sendSync(SERVER, (AcceptStamp)pda_ccp.getData());
	    expt.sendSync(SERVER, (AcceptStamp)laptop_ccp.getData());
	    expt.sendSync(SERVER, (AcceptStamp)phone_ccp.getData());
	}


        done_ccp = expt.recv(PDA);
	assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	assert(done_ccp.getData() == null);
	System.out.println("Received a SYNC_DONE from node " + PDA);
	if(all){
	    done_ccp = expt.recv(PDA);
	    assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	    assert(done_ccp.getData() == null);
	    System.out.println("Received a SYNC_DONE from node " + PDA);
	    done_ccp = expt.recv(PDA);
	    assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	    assert(done_ccp.getData() == null);
	    System.out.println("Received a SYNC_DONE from node " + PDA);
	}

	done_ccp = expt.recv(PHONE);
	assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	assert(done_ccp.getData() == null);
	System.out.println("Received a SYNC_DONE from node " + PHONE);
	
	if(all){
	    done_ccp = expt.recv(PHONE);
	    assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	    assert(done_ccp.getData() == null);
	    System.out.println("Received a SYNC_DONE from node " + PHONE);
	    done_ccp = expt.recv(PHONE);
	    assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	    assert(done_ccp.getData() == null);
	    System.out.println("Received a SYNC_DONE from node " + PHONE);
	    done_ccp = expt.recv(LAPTOP);
	    assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	    assert(done_ccp.getData() == null);
	    System.out.println("Received a SYNC_DONE from node " + LAPTOP);
	    done_ccp = expt.recv(LAPTOP);
	    assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	    assert(done_ccp.getData() == null);
	    System.out.println("Received a SYNC_DONE from node " + LAPTOP);
	    done_ccp = expt.recv(LAPTOP);
	    assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	    assert(done_ccp.getData() == null);
	    System.out.println("Received a SYNC_DONE from node " + LAPTOP);

	    done_ccp = expt.recv(SERVER);
	    assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	    assert(done_ccp.getData() == null);
	    System.out.println("Received a SYNC_DONE from node " + SERVER);
	    done_ccp = expt.recv(SERVER);
	    assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	    assert(done_ccp.getData() == null);
	    System.out.println("Received a SYNC_DONE from node " + SERVER);
	    done_ccp = expt.recv(SERVER);
	    assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	    assert(done_ccp.getData() == null);
	    System.out.println("Received a SYNC_DONE from node " + SERVER);
	}

	long endT = System.currentTimeMillis();
	finalStats = expt.getAllStats();
	diffStats = finalStats.getDiff(initStats);

	finalize(expt, (endT-startT), diffStats, all);
    }

    public static void runExperiment2(TIExptB expt){
	boolean all = true;
	boolean runb = true;

	CoordCommPacket done_ccp = null;
	CoordCommPacket pda_ccp = null;
	CoordCommPacket phone_ccp = null;
	CoordCommPacket laptop_ccp = null;
	CoordCommPacket server_ccp = null;
	DirectoryInterestSet pda_dis = null;
	DirectoryInterestSet phone_dis = null;
	DirectoryInterestSet laptop_dis = null;
	DirectoryInterestSet server_dis = null;
	StatsRecord initStats = null;
	StatsRecord finalStats = null;
	StatsRecord diffStats = null;
	StatsRecord statsSummary = null;
	long startT = 0;
	long endT = 0;
	long timeSummary = 0;
	CounterVV laptop_cvv = null;
	CounterVV pda_cvv = null;
	CounterVV phone_cvv = null;
	CounterVV server_cvv = null;

	startup(expt, all);

        // get experimental specific interest sets
	pda_dis = expt.getInterestSet(SERVER); 
	phone_dis = expt.getInterestSet(SERVER);
	laptop_dis = expt.getInterestSet(SERVER);
	server_dis = expt.getInterestSet(SERVER);

	// phone subscribe to pda
	expt.sendRandomPartialWritesScript(PDA, false);
	pda_ccp = expt.recv(PDA);
	assert(pda_ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
	assert(pda_ccp.getData() instanceof AcceptStamp);
	phone_cvv = (CounterVV)expt.getHighestTimeStamps(PHONE);

	initStats = expt.getAllStats();
	startT = System.currentTimeMillis();
	expt.issueSubscribe(PDA, PHONE, phone_cvv, -1L,
			    phone_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);
	expt.issueSubscribeBody(PDA, PHONE, phone_cvv, 
				expt.getInterestSet(PHONE), SUBSCRIPTION_TIMEOUT_MS);
	expt.sendSync(PHONE, (AcceptStamp)pda_ccp.getData());
        done_ccp = expt.recv(PHONE);
	assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	assert(done_ccp.getData() == null);
	System.out.println("Received a SYNC_DONE from node " + PHONE);
	// inval sync has to be done before body read sync
	// we need to read the lastest file that is within the receivers interestset && written by the sender.
	expt.sendRead(PHONE, expt.getFileName(PHONE_READ_SYNC), 0, 10000);
	done_ccp = expt.recv(PHONE);
	assert(done_ccp.getSignalType() == CoordCommPacket.READ_DONE);
	assert(done_ccp.getData() instanceof AcceptStamp);
	System.out.println(PHONE + "****Read done " + (AcceptStamp)done_ccp.getData());
	endT = System.currentTimeMillis();
	finalStats = expt.getAllStats();
	diffStats = finalStats.getDiff(initStats);	
	System.out.println(diffStats);
	System.out.println("Total_time " + (endT-startT) + "ms");
	timeSummary += endT-startT;
	statsSummary = diffStats;

	// pda subscribe to phone
	expt.sendRandomPartialWritesScript(PHONE, false);
	phone_ccp = expt.recv(PHONE);
	assert(phone_ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
	assert(phone_ccp.getData() instanceof AcceptStamp);
	pda_cvv = (CounterVV)expt.getHighestTimeStamps(PDA);

	initStats = expt.getAllStats();
	startT = System.currentTimeMillis();
	expt.issueSubscribe(PHONE, PDA, pda_cvv, -1L,
			    pda_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);
	expt.issueSubscribeBody(PHONE, PDA, pda_cvv,
				expt.getInterestSet(PDA), SUBSCRIPTION_TIMEOUT_MS);
	expt.sendSync(PDA, (AcceptStamp)phone_ccp.getData());
        done_ccp = expt.recv(PDA);
	assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	assert(done_ccp.getData() == null);
	System.out.println("Received a SYNC_DONE from node " + PDA);
	// inval sync has to be done before body read sync
	// we need to read the lastest file that is within the receivers interestset && written by the sender.
	expt.sendRead(PDA, expt.getFileName(PHONE_READ_SYNC), 0, 10000);
	done_ccp = expt.recv(PDA);
	assert(done_ccp.getSignalType() == CoordCommPacket.READ_DONE);
	assert(done_ccp.getData() instanceof AcceptStamp);
	System.out.println(PDA + "****Read done " + (AcceptStamp)done_ccp.getData());
	endT = System.currentTimeMillis();
	finalStats = expt.getAllStats();
	diffStats = finalStats.getDiff(initStats);	
	System.out.println(diffStats);
	System.out.println("Total_time " + (endT-startT) + "ms");
	timeSummary += endT-startT;
	statsSummary = statsSummary.addStats(diffStats);

	if(all){
	    // laptop subscribe to PDA FOR updates by both phone and pda.
	    laptop_cvv = (CounterVV)expt.getHighestTimeStamps(LAPTOP);
	    
	    initStats = expt.getAllStats();
	    startT = System.currentTimeMillis();
	    expt.issueSubscribe(PDA, LAPTOP, laptop_cvv, -1L,
				laptop_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);
	    expt.issueSubscribeBody(PDA, LAPTOP, laptop_cvv,
				    expt.getInterestSet(LAPTOP), SUBSCRIPTION_TIMEOUT_MS);
	    expt.sendSync(LAPTOP, (AcceptStamp)phone_ccp.getData());
	    done_ccp = expt.recv(LAPTOP);
	    assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	    assert(done_ccp.getData() == null);
	    System.out.println("Received a SYNC_DONE from node " + LAPTOP);
	    // inval sync has to be done before body read sync
	    expt.sendRead(LAPTOP, expt.getFileName(PDA_READ_SYNC), 0, 10000);
	    done_ccp = expt.recv(LAPTOP);
	    assert(done_ccp.getSignalType() == CoordCommPacket.READ_DONE);
	    assert(done_ccp.getData() instanceof AcceptStamp);
	    System.out.println(LAPTOP + "****Read done " + (AcceptStamp)done_ccp.getData());
	    endT = System.currentTimeMillis();
	    finalStats = expt.getAllStats();
	    diffStats = finalStats.getDiff(initStats);	
	    System.out.println(diffStats);
	    System.out.println("Total_time " + (endT-startT) + "ms");
	    timeSummary += endT-startT;
	    statsSummary = statsSummary.addStats(diffStats);
	    

	// pda subscribe to laptop
	// updates from laptop will be forwarded to phone by pda
	   expt.sendRandomPartialWritesScript(LAPTOP, false);
	    laptop_ccp = expt.recv(LAPTOP);
	    assert(laptop_ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
	    assert(laptop_ccp.getData() instanceof AcceptStamp);

	    pda_cvv = (CounterVV)expt.getHighestTimeStamps(PDA);

	    initStats = expt.getAllStats();
	    startT = System.currentTimeMillis();
	    expt.issueSubscribe(LAPTOP, PDA, pda_cvv, -1L,
				pda_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);
	    expt.issueSubscribeBody(LAPTOP, PDA, pda_cvv,
				expt.getInterestSet(PDA), SUBSCRIPTION_TIMEOUT_MS);
	    expt.sendSync(PDA, (AcceptStamp)laptop_ccp.getData());
	    done_ccp = expt.recv(PDA);
	    assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	    assert(done_ccp.getData() == null);
	    System.out.println("Received a SYNC_DONE from node " + PDA);
	    expt.sendSync(PHONE, (AcceptStamp)laptop_ccp.getData());
	    done_ccp = expt.recv(PHONE);
	    assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	    assert(done_ccp.getData() == null);
	    System.out.println("Received a SYNC_DONE from node " + PHONE);
	    // inval sync has to be done before body read sync
	    expt.sendRead(PDA, expt.getFileName(PDA_READ_SYNC), 0, 10000);
	    done_ccp = expt.recv(PDA);
	    assert(done_ccp.getSignalType() == CoordCommPacket.READ_DONE);
	    assert(done_ccp.getData() instanceof AcceptStamp);
	    System.out.println(PDA + "****Read done " + (AcceptStamp)done_ccp.getData());
	    expt.sendRead(PHONE, expt.getFileName(PHONE_READ_SYNC), 0, 10000);
	    done_ccp = expt.recv(PHONE);
	    assert(done_ccp.getSignalType() == CoordCommPacket.READ_DONE);
	    assert(done_ccp.getData() instanceof AcceptStamp);
	    System.out.println(PHONE + "****Read done " + (AcceptStamp)done_ccp.getData());

	    endT = System.currentTimeMillis();
	    finalStats = expt.getAllStats();
	    diffStats = finalStats.getDiff(initStats);	
	    System.out.println(diffStats);
	    System.out.println("Total_time " + (endT-startT) + "ms");

	}

	if(runb){
	    // server subscribe to laptop FOR updates by all three devices
	    server_cvv = (CounterVV)expt.getHighestTimeStamps(SERVER);
	    
	    initStats = expt.getAllStats();
	    startT = System.currentTimeMillis();
	    expt.issueSubscribe(LAPTOP, SERVER, server_cvv, -1L,
				server_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);
	    expt.issueSubscribeBody(LAPTOP, SERVER, server_cvv,
				    expt.getInterestSet(SERVER), SUBSCRIPTION_TIMEOUT_MS);
	    expt.sendSync(SERVER, (AcceptStamp)laptop_ccp.getData());
	    done_ccp = expt.recv(SERVER);
	    assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	    assert(done_ccp.getData() == null);
	    System.out.println("Received a SYNC_DONE from node " + SERVER);
	    // inval sync has to be done before body read sync
	    expt.sendRead(SERVER, expt.getFileName(LAPTOP_READ_SYNC), 0, 10000);
	    done_ccp = expt.recv(SERVER);
	    assert(done_ccp.getSignalType() == CoordCommPacket.READ_DONE);
	    assert(done_ccp.getData() instanceof AcceptStamp);
	    System.out.println(SERVER + "****Read done " + (AcceptStamp)done_ccp.getData());
	    endT = System.currentTimeMillis();
	    finalStats = expt.getAllStats();
	    diffStats = finalStats.getDiff(initStats);	
	    System.out.println(diffStats);
	    System.out.println("Total_time " + (endT-startT) + "ms");
	    timeSummary += endT-startT;
	    statsSummary = statsSummary.addStats(diffStats);
	    

	// laptop subscribe to server
	// updates from server will be forwarded to all three devices
	    expt.sendRandomPartialWritesScript(SERVER, false);
	    server_ccp = expt.recv(SERVER);
	    assert(server_ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
	    assert(server_ccp.getData() instanceof AcceptStamp);

	    laptop_cvv = (CounterVV)expt.getHighestTimeStamps(LAPTOP);

	    initStats = expt.getAllStats();
	    startT = System.currentTimeMillis();
	    expt.issueSubscribe(SERVER, LAPTOP, laptop_cvv, -1L,
				laptop_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);
	    expt.issueSubscribeBody(SERVER, LAPTOP, laptop_cvv,
				expt.getInterestSet(LAPTOP), SUBSCRIPTION_TIMEOUT_MS);
	    expt.sendSync(LAPTOP, (AcceptStamp)server_ccp.getData());
	    done_ccp = expt.recv(LAPTOP);
	    assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	    assert(done_ccp.getData() == null);
	    System.out.println("Received a SYNC_DONE from node " + LAPTOP);
	    expt.sendSync(PDA, (AcceptStamp)server_ccp.getData());
	    done_ccp = expt.recv(PDA);
	    assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	    assert(done_ccp.getData() == null);
	    System.out.println("Received a SYNC_DONE from node " + PDA);
	    expt.sendSync(PHONE, (AcceptStamp)server_ccp.getData());
	    done_ccp = expt.recv(PHONE);
	    assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	    assert(done_ccp.getData() == null);
	    System.out.println("Received a SYNC_DONE from node " + PHONE);
	    // inval sync has to be done before body read sync
	    expt.sendRead(LAPTOP, expt.getFileName(LAPTOP_READ_SYNC), 0, 10000);
	    done_ccp = expt.recv(LAPTOP);
	    assert(done_ccp.getSignalType() == CoordCommPacket.READ_DONE);
	    assert(done_ccp.getData() instanceof AcceptStamp);
	    System.out.println(LAPTOP + "****Read done " + (AcceptStamp)done_ccp.getData());
	    expt.sendRead(PDA, expt.getFileName(PDA_READ_SYNC), 0, 10000);
	    done_ccp = expt.recv(PDA);
	    assert(done_ccp.getSignalType() == CoordCommPacket.READ_DONE);
	    assert(done_ccp.getData() instanceof AcceptStamp);
	    System.out.println(PDA + "****Read done " + (AcceptStamp)done_ccp.getData());
	    expt.sendRead(PHONE, expt.getFileName(PHONE_READ_SYNC), 0, 10000);
	    done_ccp = expt.recv(PHONE);
	    assert(done_ccp.getSignalType() == CoordCommPacket.READ_DONE);
	    assert(done_ccp.getData() instanceof AcceptStamp);
	    System.out.println(PHONE + "****Read done " + (AcceptStamp)done_ccp.getData());

	    endT = System.currentTimeMillis();
	    finalStats = expt.getAllStats();
	    diffStats = finalStats.getDiff(initStats);	
	    System.out.println(diffStats);
	    System.out.println("Total_time " + (endT-startT) + "ms");
	    timeSummary += endT-startT;
	    statsSummary = statsSummary.addStats(diffStats);
	}


	finalize(expt, timeSummary, statsSummary, all);
    }

    public static void runExperiment3(TIExptB expt){
	boolean all = true;
	boolean runb = true;

	CoordCommPacket done_ccp = null;
	CoordCommPacket pda_ccp = null;
	CoordCommPacket phone_ccp = null;
	CoordCommPacket laptop_ccp = null;
	CoordCommPacket server_ccp = null;
	DirectoryInterestSet pda_dis = null;
	DirectoryInterestSet phone_dis = null;
	DirectoryInterestSet laptop_dis = null;
	DirectoryInterestSet server_dis = null;
	StatsRecord initStats = null;
	StatsRecord finalStats = null;
	StatsRecord diffStats = null;
	StatsRecord statsSummary = null;
	long startT = 0;
	long endT = 0;
	long timeSummary = 0;
	CounterVV laptop_cvv = null;
	CounterVV pda_cvv = null;
	CounterVV phone_cvv = null;
	CounterVV server_cvv = null;

	startup(expt, all);

        // get experimental specific interest sets
	pda_dis = expt.getInterestSet(PDA); 
	phone_dis = expt.getInterestSet(PHONE);
	laptop_dis = expt.getInterestSet(LAPTOP);
	server_dis = expt.getInterestSet(SERVER);

	// phone subscribe to pda
	expt.sendRandomPartialWritesScript(PDA, false);
	pda_ccp = expt.recv(PDA);
	assert(pda_ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
	assert(pda_ccp.getData() instanceof AcceptStamp);
	phone_cvv = (CounterVV)expt.getHighestTimeStamps(PHONE);

	initStats = expt.getAllStats();
	startT = System.currentTimeMillis();
	expt.issueSubscribe(PDA, PHONE, phone_cvv, -1L,
			    phone_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);
	expt.issueSubscribeBody(PDA, PHONE, phone_cvv, 
				phone_dis, SUBSCRIPTION_TIMEOUT_MS);
	expt.sendSync(PHONE, (AcceptStamp)pda_ccp.getData());
        done_ccp = expt.recv(PHONE);
	assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	assert(done_ccp.getData() == null);
	System.out.println("Received a SYNC_DONE from node " + PHONE);
	// inval sync has to be done before body read sync
	// we need to read the lastest file that is within the receivers interestset && written by the sender.
	expt.sendRead(PHONE, expt.getFileName(PHONE_READ_SYNC), 0, 10000);
	done_ccp = expt.recv(PHONE);
	assert(done_ccp.getSignalType() == CoordCommPacket.READ_DONE);
	assert(done_ccp.getData() instanceof AcceptStamp);
	System.out.println(PHONE + "****Read done " + (AcceptStamp)done_ccp.getData());
	endT = System.currentTimeMillis();
	finalStats = expt.getAllStats();
	diffStats = finalStats.getDiff(initStats);	
	System.out.println(diffStats);
	System.out.println("Total_time " + (endT-startT) + "ms");
	timeSummary += endT-startT;
	statsSummary = diffStats;

	// pda subscribe to phone
	expt.sendRandomPartialWritesScript(PHONE, false);
	phone_ccp = expt.recv(PHONE);
	assert(phone_ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
	assert(phone_ccp.getData() instanceof AcceptStamp);
	pda_cvv = (CounterVV)expt.getHighestTimeStamps(PDA);

	initStats = expt.getAllStats();
	startT = System.currentTimeMillis();
	expt.issueSubscribe(PHONE, PDA, pda_cvv, -1L,
			    pda_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);
	expt.issueSubscribeBody(PHONE, PDA, pda_cvv,
				pda_dis, SUBSCRIPTION_TIMEOUT_MS);
	expt.sendSync(PDA, (AcceptStamp)phone_ccp.getData());
        done_ccp = expt.recv(PDA);
	assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	assert(done_ccp.getData() == null);
	System.out.println("Received a SYNC_DONE from node " + PDA);
	// inval sync has to be done before body read sync
	// we need to read the lastest file that is within the receivers interestset && written by the sender.
	expt.sendRead(PDA, expt.getFileName(PHONE_READ_SYNC), 0, 10000);
	done_ccp = expt.recv(PDA);
	assert(done_ccp.getSignalType() == CoordCommPacket.READ_DONE);
	assert(done_ccp.getData() instanceof AcceptStamp);
	System.out.println(PDA + "****Read done " + (AcceptStamp)done_ccp.getData());
	endT = System.currentTimeMillis();
	finalStats = expt.getAllStats();
	diffStats = finalStats.getDiff(initStats);	
	System.out.println(diffStats);
	System.out.println("Total_time " + (endT-startT) + "ms");
	timeSummary += endT-startT;
	statsSummary = statsSummary.addStats(diffStats);

	if(all){
	    // laptop subscribe to PDA FOR updates by both phone and pda.
	    laptop_cvv = (CounterVV)expt.getHighestTimeStamps(LAPTOP);
	    
	    initStats = expt.getAllStats();
	    startT = System.currentTimeMillis();
	    expt.issueSubscribe(PDA, LAPTOP, laptop_cvv, -1L,
				laptop_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);
	    expt.issueSubscribeBody(PDA, LAPTOP, laptop_cvv,
				    laptop_dis, SUBSCRIPTION_TIMEOUT_MS);
	    expt.sendSync(LAPTOP, (AcceptStamp)phone_ccp.getData());
	    done_ccp = expt.recv(LAPTOP);
	    assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	    assert(done_ccp.getData() == null);
	    System.out.println("Received a SYNC_DONE from node " + LAPTOP);
	    // inval sync has to be done before body read sync
	    expt.sendRead(LAPTOP, expt.getFileName(PDA_READ_SYNC), 0, 10000);
	    done_ccp = expt.recv(LAPTOP);
	    assert(done_ccp.getSignalType() == CoordCommPacket.READ_DONE);
	    assert(done_ccp.getData() instanceof AcceptStamp);
	    System.out.println(LAPTOP + "****Read done " + (AcceptStamp)done_ccp.getData());
	    endT = System.currentTimeMillis();
	    finalStats = expt.getAllStats();
	    diffStats = finalStats.getDiff(initStats);	
	    System.out.println(diffStats);
	    System.out.println("Total_time " + (endT-startT) + "ms");
	    timeSummary += endT-startT;
	    statsSummary = statsSummary.addStats(diffStats);
	    
	// pda subscribe to laptop
	// updates from laptop will be forwarded to phone by pda
	    expt.sendRandomPartialWritesScript(LAPTOP, false);
	    laptop_ccp = expt.recv(LAPTOP);
	    assert(laptop_ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
	    assert(laptop_ccp.getData() instanceof AcceptStamp);

	    pda_cvv = (CounterVV)expt.getHighestTimeStamps(PDA);

	    initStats = expt.getAllStats();
	    startT = System.currentTimeMillis();
	    expt.issueSubscribe(LAPTOP, PDA, pda_cvv, -1L,
				pda_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);
	    expt.issueSubscribeBody(LAPTOP, PDA, pda_cvv,
				pda_dis, SUBSCRIPTION_TIMEOUT_MS);
	    expt.sendSync(PDA, (AcceptStamp)laptop_ccp.getData());
	    done_ccp = expt.recv(PDA);
	    assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	    assert(done_ccp.getData() == null);
	    System.out.println("Received a SYNC_DONE from node " + PDA);
	    expt.sendSync(PHONE, (AcceptStamp)laptop_ccp.getData());
	    done_ccp = expt.recv(PHONE);
	    assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	    assert(done_ccp.getData() == null);
	    System.out.println("Received a SYNC_DONE from node " + PHONE);
	    // inval sync has to be done before body read sync
	    expt.sendRead(PDA, expt.getFileName(PDA_READ_SYNC), 0, 10000);
	    done_ccp = expt.recv(PDA);
	    assert(done_ccp.getSignalType() == CoordCommPacket.READ_DONE);
	    assert(done_ccp.getData() instanceof AcceptStamp);
	    System.out.println(PDA + "****Read done " + (AcceptStamp)done_ccp.getData());
	    expt.sendRead(PHONE, expt.getFileName(PHONE_READ_SYNC), 0, 10000);
	    done_ccp = expt.recv(PHONE);
	    assert(done_ccp.getSignalType() == CoordCommPacket.READ_DONE);
	    assert(done_ccp.getData() instanceof AcceptStamp);
	    System.out.println(PHONE + "****Read done " + (AcceptStamp)done_ccp.getData());

	    endT = System.currentTimeMillis();
	    finalStats = expt.getAllStats();
	    diffStats = finalStats.getDiff(initStats);	
	    System.out.println(diffStats);
	    System.out.println("Total_time " + (endT-startT) + "ms");
	    timeSummary += endT-startT;
	    statsSummary = statsSummary.addStats(diffStats);
	}

	if(runb){
	    // server subscribe to laptop FOR updates by all three devices
	    server_cvv = (CounterVV)expt.getHighestTimeStamps(SERVER);
	    
	    initStats = expt.getAllStats();
	    startT = System.currentTimeMillis();
	    expt.issueSubscribe(LAPTOP, SERVER, server_cvv, -1L,
				server_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);
	    expt.issueSubscribeBody(LAPTOP, SERVER, server_cvv,
				    server_dis, SUBSCRIPTION_TIMEOUT_MS);
	    expt.sendSync(SERVER, (AcceptStamp)laptop_ccp.getData());
	    done_ccp = expt.recv(SERVER);
	    assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	    assert(done_ccp.getData() == null);
	    System.out.println("Received a SYNC_DONE from node " + SERVER);
	    // inval sync has to be done before body read sync
	    expt.sendRead(SERVER, expt.getFileName(LAPTOP_READ_SYNC), 0, 10000);
	    done_ccp = expt.recv(SERVER);
	    assert(done_ccp.getSignalType() == CoordCommPacket.READ_DONE);
	    assert(done_ccp.getData() instanceof AcceptStamp);
	    System.out.println(SERVER + "****Read done " + (AcceptStamp)done_ccp.getData());
	    endT = System.currentTimeMillis();
	    finalStats = expt.getAllStats();
	    diffStats = finalStats.getDiff(initStats);	
	    System.out.println(diffStats);
	    System.out.println("Total_time " + (endT-startT) + "ms");
	    timeSummary += endT-startT;
	    statsSummary = statsSummary.addStats(diffStats);
	    

	// laptop subscribe to server
	// updates from server will be forwarded to all three devices
	    expt.sendRandomPartialWritesScript(SERVER, false);
	    server_ccp = expt.recv(SERVER);
	    assert(server_ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
	    assert(server_ccp.getData() instanceof AcceptStamp);

	    laptop_cvv = (CounterVV)expt.getHighestTimeStamps(LAPTOP);

	    initStats = expt.getAllStats();
	    startT = System.currentTimeMillis();
	    expt.issueSubscribe(SERVER, LAPTOP, laptop_cvv, -1L,
				laptop_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);
	    expt.issueSubscribeBody(SERVER, LAPTOP, laptop_cvv,
				laptop_dis, SUBSCRIPTION_TIMEOUT_MS);
	    expt.sendSync(LAPTOP, (AcceptStamp)server_ccp.getData());
	    done_ccp = expt.recv(LAPTOP);
	    assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	    assert(done_ccp.getData() == null);
	    System.out.println("Received a SYNC_DONE from node " + LAPTOP);
	    expt.sendSync(PDA, (AcceptStamp)server_ccp.getData());
	    done_ccp = expt.recv(PDA);
	    assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	    assert(done_ccp.getData() == null);
	    System.out.println("Received a SYNC_DONE from node " + PDA);
	    expt.sendSync(PHONE, (AcceptStamp)server_ccp.getData());
	    done_ccp = expt.recv(PHONE);
	    assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	    assert(done_ccp.getData() == null);
	    System.out.println("Received a SYNC_DONE from node " + PHONE);
	    // inval sync has to be done before body read sync
	    expt.sendRead(LAPTOP, expt.getFileName(LAPTOP_READ_SYNC), 0, 10000);
	    done_ccp = expt.recv(LAPTOP);
	    assert(done_ccp.getSignalType() == CoordCommPacket.READ_DONE);
	    assert(done_ccp.getData() instanceof AcceptStamp);
	    System.out.println(LAPTOP + "****Read done " + (AcceptStamp)done_ccp.getData());
	    expt.sendRead(PDA, expt.getFileName(PDA_READ_SYNC), 0, 10000);
	    done_ccp = expt.recv(PDA);
	    assert(done_ccp.getSignalType() == CoordCommPacket.READ_DONE);
	    assert(done_ccp.getData() instanceof AcceptStamp);
	    System.out.println(PDA + "****Read done " + (AcceptStamp)done_ccp.getData());
	    expt.sendRead(PHONE, expt.getFileName(PHONE_READ_SYNC), 0, 10000);
	    done_ccp = expt.recv(PHONE);
	    assert(done_ccp.getSignalType() == CoordCommPacket.READ_DONE);
	    assert(done_ccp.getData() instanceof AcceptStamp);
	    System.out.println(PHONE + "****Read done " + (AcceptStamp)done_ccp.getData());

	    endT = System.currentTimeMillis();
	    finalStats = expt.getAllStats();
	    diffStats = finalStats.getDiff(initStats);	
	    System.out.println(diffStats);
	    System.out.println("Total_time " + (endT-startT) + "ms");
	    timeSummary += endT-startT;
	    statsSummary = statsSummary.addStats(diffStats);
	}

	finalize(expt, timeSummary, statsSummary, all);


    }

    public static void runExperiment4(TIExptB expt){
	boolean all = true;
	
	CoordCommPacket done_ccp = null;
	CoordCommPacket pda_ccp = null;
	CoordCommPacket phone_ccp = null;
	CoordCommPacket laptop_ccp = null;
	CoordCommPacket server_ccp = null;
	DirectoryInterestSet pda_dis = null;
	DirectoryInterestSet phone_dis = null;
	DirectoryInterestSet laptop_dis = null;
	DirectoryInterestSet server_dis = null;
	StatsRecord initStats = null;
	StatsRecord finalStats = null;
	StatsRecord diffStats = null;
	StatsRecord statsSummary = null;
	long startT = 0;
	long endT = 0;
	long timeSummary = 0;
	CounterVV laptop_cvv = null;
	CounterVV pda_cvv = null;
	CounterVV phone_cvv = null;
	CounterVV server_cvv = null;

	startup(expt, all);

        // get experimental specific interest sets
	pda_dis = expt.getInterestSet(PDA); 
	phone_dis = expt.getInterestSet(PHONE);
	laptop_dis = expt.getInterestSet(LAPTOP);
	server_dis = expt.getInterestSet(SERVER);

	// server subscribe to phone
	expt.sendRandomPartialWritesScript(PHONE, false);
	phone_ccp = expt.recv(PHONE);
	assert(phone_ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
	assert(phone_ccp.getData() instanceof AcceptStamp);
	server_cvv = (CounterVV)expt.getHighestTimeStamps(SERVER);

	initStats = expt.getAllStats();
	startT = System.currentTimeMillis();
	expt.issueSubscribe(PHONE, SERVER, server_cvv, -1L,
			    server_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);
	expt.issueSubscribeBody(PHONE, SERVER, server_cvv, 
				server_dis, SUBSCRIPTION_TIMEOUT_MS);
	expt.sendSync(SERVER, (AcceptStamp)phone_ccp.getData());
        done_ccp = expt.recv(SERVER);
	assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	assert(done_ccp.getData() == null);
	System.out.println("Received a SYNC_DONE from node " + SERVER);
	// inval sync has to be done before body read sync
	// we need to read the lastest file that is within the receivers interestset && written by the sender.
	expt.sendRead(SERVER, expt.getFileName(PHONE_READ_SYNC), 0, 10000);
	done_ccp = expt.recv(SERVER);
	assert(done_ccp.getSignalType() == CoordCommPacket.READ_DONE);
	assert(done_ccp.getData() instanceof AcceptStamp);
	System.out.println(SERVER + "****Read done " + (AcceptStamp)done_ccp.getData());
	endT = System.currentTimeMillis();
	finalStats = expt.getAllStats();
	diffStats = finalStats.getDiff(initStats);	
	System.out.println(diffStats);
	System.out.println("Total_time " + (endT-startT) + "ms");
	timeSummary += endT-startT;
	statsSummary = diffStats;

	// server subscribe to pda
	expt.sendRandomPartialWritesScript(PDA, false);
	pda_ccp = expt.recv(PDA);
	assert(pda_ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
	assert(pda_ccp.getData() instanceof AcceptStamp);
	server_cvv = (CounterVV)expt.getHighestTimeStamps(SERVER);

	initStats = expt.getAllStats();
	startT = System.currentTimeMillis();
	expt.issueSubscribe(PDA, SERVER, server_cvv, -1L,
			    server_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);
	expt.issueSubscribeBody(PDA, SERVER, server_cvv, 
				server_dis, SUBSCRIPTION_TIMEOUT_MS);
	expt.sendSync(SERVER, (AcceptStamp)pda_ccp.getData());
        done_ccp = expt.recv(SERVER);
	assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	assert(done_ccp.getData() == null);
	System.out.println("Received a SYNC_DONE from node " + SERVER);
	// inval sync has to be done before body read sync
	// we need to read the lastest file that is within the receivers interestset && written by the sender.
	expt.sendRead(SERVER, expt.getFileName(PDA_READ_SYNC), 0, 10000);
	done_ccp = expt.recv(SERVER);
	assert(done_ccp.getSignalType() == CoordCommPacket.READ_DONE);
	assert(done_ccp.getData() instanceof AcceptStamp);
	System.out.println(SERVER + "****Read done " + (AcceptStamp)done_ccp.getData());
	endT = System.currentTimeMillis();
	finalStats = expt.getAllStats();
	diffStats = finalStats.getDiff(initStats);	
	System.out.println(diffStats);
	System.out.println("Total_time " + (endT-startT) + "ms");
	timeSummary += endT-startT;
	statsSummary = diffStats;


	// server subscribe to laptop
	expt.sendRandomPartialWritesScript(LAPTOP, false);
	laptop_ccp = expt.recv(LAPTOP);
	assert(laptop_ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
	assert(laptop_ccp.getData() instanceof AcceptStamp);
	server_cvv = (CounterVV)expt.getHighestTimeStamps(SERVER);

	initStats = expt.getAllStats();
	startT = System.currentTimeMillis();
	expt.issueSubscribe(LAPTOP, SERVER, server_cvv, -1L,
			    server_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);
	expt.issueSubscribeBody(LAPTOP, SERVER, server_cvv, 
				server_dis, SUBSCRIPTION_TIMEOUT_MS);
	expt.sendSync(SERVER, (AcceptStamp)laptop_ccp.getData());
        done_ccp = expt.recv(SERVER);
	assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	assert(done_ccp.getData() == null);
	System.out.println("Received a SYNC_DONE from node " + SERVER);
	// inval sync has to be done before body read sync
	// we need to read the lastest file that is within the receivers interestset && written by the sender.
	expt.sendRead(SERVER, expt.getFileName(LAPTOP_READ_SYNC), 0, 10000);
	done_ccp = expt.recv(SERVER);
	assert(done_ccp.getSignalType() == CoordCommPacket.READ_DONE);
	assert(done_ccp.getData() instanceof AcceptStamp);
	System.out.println(SERVER + "****Read done " + (AcceptStamp)done_ccp.getData());
	endT = System.currentTimeMillis();
	finalStats = expt.getAllStats();
	diffStats = finalStats.getDiff(initStats);	
	System.out.println(diffStats);
	System.out.println("Total_time " + (endT-startT) + "ms");
	timeSummary += endT-startT;
	statsSummary = diffStats;


	// all subscribe to server
	expt.sendRandomPartialWritesScript(SERVER, false);
	server_ccp = expt.recv(SERVER);
	assert(server_ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
	assert(server_ccp.getData() instanceof AcceptStamp);

	phone_cvv = (CounterVV)expt.getHighestTimeStamps(PHONE);
	pda_cvv = (CounterVV)expt.getHighestTimeStamps(PDA);
	laptop_cvv = (CounterVV)expt.getHighestTimeStamps(LAPTOP);

	initStats = expt.getAllStats();
	startT = System.currentTimeMillis();

	expt.issueSubscribe(SERVER, PHONE, phone_cvv, -1L,
			    phone_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);
	expt.issueSubscribeBody(SERVER, PHONE, phone_cvv, 
				phone_dis, SUBSCRIPTION_TIMEOUT_MS);
	expt.issueSubscribe(SERVER, PDA, pda_cvv, -1L,
			    pda_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);
	expt.issueSubscribeBody(SERVER, PDA, pda_cvv, 
				pda_dis, SUBSCRIPTION_TIMEOUT_MS);
	expt.issueSubscribe(SERVER, LAPTOP, laptop_cvv, -1L,
			    laptop_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);
	expt.issueSubscribeBody(SERVER, LAPTOP, laptop_cvv, 
				laptop_dis, SUBSCRIPTION_TIMEOUT_MS);

	expt.sendSync(PHONE, (AcceptStamp)server_ccp.getData());
        done_ccp = expt.recv(PHONE);
	assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	assert(done_ccp.getData() == null);
	System.out.println("Received a SYNC_DONE from node " + PHONE);
	expt.sendSync(PDA, (AcceptStamp)server_ccp.getData());
        done_ccp = expt.recv(PDA);
	assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	assert(done_ccp.getData() == null);
	System.out.println("Received a SYNC_DONE from node " + PDA);
	expt.sendSync(LAPTOP, (AcceptStamp)server_ccp.getData());
        done_ccp = expt.recv(LAPTOP);
	assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	assert(done_ccp.getData() == null);
	System.out.println("Received a SYNC_DONE from node " + LAPTOP);

	// inval sync has to be done before body read sync
	// we need to read the lastest file that is within the receivers interestset && written by the sender.
	expt.sendRead(PHONE, expt.getFileName(PHONE_READ_SYNC), 0, 10000);
	done_ccp = expt.recv(PHONE);
	assert(done_ccp.getSignalType() == CoordCommPacket.READ_DONE);
	assert(done_ccp.getData() instanceof AcceptStamp);
	System.out.println(PHONE + "****Read done " + (AcceptStamp)done_ccp.getData());
	expt.sendRead(PDA, expt.getFileName(PDA_READ_SYNC), 0, 10000);
	done_ccp = expt.recv(PDA);
	assert(done_ccp.getSignalType() == CoordCommPacket.READ_DONE);
	assert(done_ccp.getData() instanceof AcceptStamp);
	System.out.println(PDA + "****Read done " + (AcceptStamp)done_ccp.getData());
	expt.sendRead(LAPTOP, expt.getFileName(LAPTOP_READ_SYNC), 0, 10000);
	done_ccp = expt.recv(LAPTOP);
	assert(done_ccp.getSignalType() == CoordCommPacket.READ_DONE);
	assert(done_ccp.getData() instanceof AcceptStamp);
	System.out.println(LAPTOP + "****Read done " + (AcceptStamp)done_ccp.getData());
	endT = System.currentTimeMillis();
	finalStats = expt.getAllStats();
	diffStats = finalStats.getDiff(initStats);	
	System.out.println(diffStats);
	System.out.println("Total_time " + (endT-startT) + "ms");

	finalStats = expt.getAllStats();
	diffStats = finalStats.getDiff(initStats);	
	System.out.println(diffStats);
	System.out.println("Total_time " + (endT-startT) + "ms");
	timeSummary += endT-startT;
	statsSummary = diffStats;

	finalize(expt, timeSummary, statsSummary, all);
    }

    public static void runExperiment5(TIExptB expt){
	boolean all = true;
	
	CoordCommPacket done_ccp = null;
	CoordCommPacket pda_ccp = null;
	CoordCommPacket phone_ccp = null;
	CoordCommPacket laptop_ccp = null;
	CoordCommPacket server_ccp = null;
	DirectoryInterestSet pda_dis = null;
	DirectoryInterestSet phone_dis = null;
	DirectoryInterestSet laptop_dis = null;
	DirectoryInterestSet server_dis = null;
	StatsRecord initStats = null;
	StatsRecord finalStats = null;
	StatsRecord diffStats = null;
	StatsRecord statsSummary = null;
	long startT = 0;
	long endT = 0;
	long timeSummary = 0;
	CounterVV laptop_cvv = null;
	CounterVV pda_cvv = null;
	CounterVV phone_cvv = null;
	CounterVV server_cvv = null;

	startup(expt, all);

        // get experimental specific interest sets
	pda_dis = expt.getInterestSet(PDA); 
	phone_dis = expt.getInterestSet(PHONE);
	laptop_dis = expt.getInterestSet(LAPTOP);
	server_dis = expt.getInterestSet(SERVER);


	// server subscribe inval to phone
	expt.sendRandomPartialWritesScript(PHONE, false);
	phone_ccp = expt.recv(PHONE);
	assert(phone_ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
	assert(phone_ccp.getData() instanceof AcceptStamp);
	server_cvv = (CounterVV)expt.getHighestTimeStamps(SERVER);

	initStats = expt.getAllStats();
	startT = System.currentTimeMillis();
	expt.issueSubscribe(PHONE, SERVER, server_cvv, -1L,
			    server_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);
	expt.sendSync(SERVER, (AcceptStamp)phone_ccp.getData());
        done_ccp = expt.recv(SERVER);
	assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	assert(done_ccp.getData() == null);
	System.out.println("Received a SYNC_DONE from node " + SERVER);
	endT = System.currentTimeMillis();
	finalStats = expt.getAllStats();
	diffStats = finalStats.getDiff(initStats);	
	System.out.println(diffStats);
	System.out.println("Total_time " + (endT-startT) + "ms");
	timeSummary += endT-startT;
	statsSummary = diffStats;

	// server subscribe inval to pda
	expt.sendRandomPartialWritesScript(PDA, false);
	pda_ccp = expt.recv(PDA);
	assert(pda_ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
	assert(pda_ccp.getData() instanceof AcceptStamp);
	server_cvv = (CounterVV)expt.getHighestTimeStamps(SERVER);

	initStats = expt.getAllStats();
	startT = System.currentTimeMillis();
	expt.issueSubscribe(PDA, SERVER, server_cvv, -1L,
			    server_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);
	expt.sendSync(SERVER, (AcceptStamp)pda_ccp.getData());
        done_ccp = expt.recv(SERVER);
	assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	assert(done_ccp.getData() == null);
	System.out.println("Received a SYNC_DONE from node " + SERVER);
	endT = System.currentTimeMillis();
	finalStats = expt.getAllStats();
	diffStats = finalStats.getDiff(initStats);	
	System.out.println(diffStats);
	System.out.println("Total_time " + (endT-startT) + "ms");
	timeSummary += endT-startT;
	statsSummary = diffStats;


	// server subscribe inval to laptop
	expt.sendRandomPartialWritesScript(LAPTOP, false);
	laptop_ccp = expt.recv(LAPTOP);
	assert(laptop_ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
	assert(laptop_ccp.getData() instanceof AcceptStamp);
	server_cvv = (CounterVV)expt.getHighestTimeStamps(SERVER);

	initStats = expt.getAllStats();
	startT = System.currentTimeMillis();
	expt.issueSubscribe(LAPTOP, SERVER, server_cvv, -1L,
			    server_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);
	expt.sendSync(SERVER, (AcceptStamp)laptop_ccp.getData());
        done_ccp = expt.recv(SERVER);
	assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	assert(done_ccp.getData() == null);
	System.out.println("Received a SYNC_DONE from node " + SERVER);
	endT = System.currentTimeMillis();
	finalStats = expt.getAllStats();
	diffStats = finalStats.getDiff(initStats);	
	System.out.println(diffStats);
	System.out.println("Total_time " + (endT-startT) + "ms");
	timeSummary += endT-startT;
	statsSummary = diffStats;


	// all subscribe inval to server
	expt.sendRandomPartialWritesScript(SERVER, false);
	server_ccp = expt.recv(SERVER);
	assert(server_ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
	assert(server_ccp.getData() instanceof AcceptStamp);

	phone_cvv = (CounterVV)expt.getHighestTimeStamps(PHONE);
	pda_cvv = (CounterVV)expt.getHighestTimeStamps(PDA);
	laptop_cvv = (CounterVV)expt.getHighestTimeStamps(LAPTOP);

	initStats = expt.getAllStats();
	startT = System.currentTimeMillis();

	expt.issueSubscribe(SERVER, PHONE, phone_cvv, -1L,
			    phone_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);
	expt.issueSubscribe(SERVER, PDA, pda_cvv, -1L,
			    pda_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);
	expt.issueSubscribe(SERVER, LAPTOP, laptop_cvv, -1L,
			    laptop_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);

	expt.sendSync(PHONE, (AcceptStamp)server_ccp.getData());
        done_ccp = expt.recv(PHONE);
	assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	assert(done_ccp.getData() == null);
	System.out.println("Received a SYNC_DONE from node " + PHONE);
	expt.sendSync(PDA, (AcceptStamp)server_ccp.getData());
        done_ccp = expt.recv(PDA);
	assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	assert(done_ccp.getData() == null);
	System.out.println("Received a SYNC_DONE from node " + PDA);
	expt.sendSync(LAPTOP, (AcceptStamp)server_ccp.getData());
        done_ccp = expt.recv(LAPTOP);
	assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	assert(done_ccp.getData() == null);
	System.out.println("Received a SYNC_DONE from node " + LAPTOP);

	endT = System.currentTimeMillis();
	finalStats = expt.getAllStats();
	diffStats = finalStats.getDiff(initStats);	
	System.out.println(diffStats);
	System.out.println("Total_time " + (endT-startT) + "ms");

	initStats = expt.getAllStats();
	startT = System.currentTimeMillis();

	// phone subscribe body to pda
	phone_cvv = (CounterVV)expt.getHighestTimeStamps(PHONE);
	expt.issueSubscribeBody(PDA, PHONE, phone_cvv, 
				phone_dis, SUBSCRIPTION_TIMEOUT_MS);
	expt.sendRead(PHONE, expt.getFileName(PHONE_READ_SYNC), 0, 10000);
	done_ccp = expt.recv(PHONE);
	assert(done_ccp.getSignalType() == CoordCommPacket.READ_DONE);
	assert(done_ccp.getData() instanceof AcceptStamp);
	System.out.println(PHONE + "****Read done " + (AcceptStamp)done_ccp.getData());

	// pda subscribe body to phone
	pda_cvv = (CounterVV)expt.getHighestTimeStamps(PDA);
	expt.issueSubscribeBody(PHONE, PDA, pda_cvv, 
				pda_dis, SUBSCRIPTION_TIMEOUT_MS);
	expt.sendRead(PDA, expt.getFileName(PHONE_READ_SYNC), 0, 10000);
	done_ccp = expt.recv(PDA);
	assert(done_ccp.getSignalType() == CoordCommPacket.READ_DONE);
	assert(done_ccp.getData() instanceof AcceptStamp);
	System.out.println(PDA + "****Read done " + (AcceptStamp)done_ccp.getData());

	// pda subscribe body to laptop
	pda_cvv = (CounterVV)expt.getHighestTimeStamps(PDA);
	expt.issueSubscribeBody(LAPTOP, PDA, pda_cvv,
				pda_dis, SUBSCRIPTION_TIMEOUT_MS);
	expt.sendRead(PDA, expt.getFileName(PDA_READ_SYNC), 0, 10000);
	done_ccp = expt.recv(PDA);
	assert(done_ccp.getSignalType() == CoordCommPacket.READ_DONE);
	assert(done_ccp.getData() instanceof AcceptStamp);
	System.out.println(PDA + "****Read done " + (AcceptStamp)done_ccp.getData());

	// laptop subscribe body to pda
	laptop_cvv = (CounterVV)expt.getHighestTimeStamps(LAPTOP);
	expt.issueSubscribeBody(PDA, LAPTOP, laptop_cvv, 
				laptop_dis, SUBSCRIPTION_TIMEOUT_MS);
	expt.sendRead(LAPTOP, expt.getFileName(PDA_READ_SYNC), 0, 10000);
	done_ccp = expt.recv(LAPTOP);
	assert(done_ccp.getSignalType() == CoordCommPacket.READ_DONE);
	assert(done_ccp.getData() instanceof AcceptStamp);
	System.out.println(LAPTOP + "****Read done " + (AcceptStamp)done_ccp.getData());

	// laptop subscribe body to server
	laptop_cvv = (CounterVV)expt.getHighestTimeStamps(LAPTOP);
	expt.issueSubscribeBody(SERVER, LAPTOP, laptop_cvv, 
				laptop_dis, SUBSCRIPTION_TIMEOUT_MS);
	expt.sendRead(LAPTOP, expt.getFileName(LAPTOP_READ_SYNC), 0, 10000);
	done_ccp = expt.recv(LAPTOP);
	assert(done_ccp.getSignalType() == CoordCommPacket.READ_DONE);
	assert(done_ccp.getData() instanceof AcceptStamp);
	System.out.println(LAPTOP + "****Read done " + (AcceptStamp)done_ccp.getData());

	// server subscribe body to laptop
	server_cvv = (CounterVV)expt.getHighestTimeStamps(SERVER);
	expt.issueSubscribeBody(LAPTOP, SERVER, server_cvv, 
				server_dis, SUBSCRIPTION_TIMEOUT_MS);
	expt.sendRead(SERVER, expt.getFileName(LAPTOP_READ_SYNC), 0, 10000);
	done_ccp = expt.recv(SERVER);
	assert(done_ccp.getSignalType() == CoordCommPacket.READ_DONE);
	assert(done_ccp.getData() instanceof AcceptStamp);
	System.out.println(SERVER + "****Read done " + (AcceptStamp)done_ccp.getData());

	endT = System.currentTimeMillis();
	finalStats = expt.getAllStats();
	diffStats = finalStats.getDiff(initStats);	
	System.out.println(diffStats);
	System.out.println("Total_time " + (endT-startT) + "ms");
	timeSummary += endT-startT;
	statsSummary = diffStats;

	finalize(expt, timeSummary, statsSummary, all);
    }


    public static void main(String[] argv){
	TIExptB expt = null;
	int exptNum = 1 ;

	if(argv.length < 2){
	    System.out.println("Usage: <exptConfigfile> <shellType>");
	    System.exit(-1);
	}

	if(argv.length > 2) {
	    exptNum = new Integer(argv[2]).intValue() ;
	}

	expt = new TIExptB(argv[0], argv[1]);
	System.err.println(exptNum);
	if(exptNum == 1) {
	    runExperiment1(expt); // bayou approach
	}
	else if(exptNum == 2) {
	    runExperiment2(expt); 
	}
	else if(exptNum == 3) {
	    runExperiment3(expt);
	}
	else if(exptNum == 4) {
	    runExperiment4(expt);
	}
	else {
	    System.err.println("Experiment number "+exptNum+" not defined here") ;
	    assert(false);
	}
    }

}

/*
 * $Log: TIExptB.java,v $
 * Revision 1.11  2004/05/27 03:23:16  lgao
 * *** empty log message ***
 *
 * Revision 1.10  2004/05/27 03:12:36  lgao
 * *** empty log message ***
 *
 * Revision 1.9  2004/05/27 01:55:06  ypraveen
 * bug fix
 *
 * Revision 1.8  2004/05/26 22:26:59  ypraveen
 * *** empty log message ***
 *
 * Revision 1.7  2004/05/26 22:25:57  lgao
 * Last checking from Lei :)
 *
 */
