 /** 
 *  Make a local controller Object 
 **/ 
public class CPExptController implements Controller
{
  private boolean cpUpdateDone = false;
  private long cpStart;
  private long cpEnd;

  private long logStart;
  private long logEnd;
  private long logMaxStamp;
  private Core core;
  
 /** 
 *  Constructor 
 **/ 
  public CPExptController(Core core_, long logMaxStamp_)
    {
	this.core = core_;
        logMaxStamp = logMaxStamp_;
        cpStart = -1;
        cpEnd = -1;
        logStart = -1;
        logEnd = -1;
    }

 /** 
 *  This inform method is called by InvalRecvWorker 
 *  after the InvalRecvWorker receives a corrent header(Magic, senderId, 
 *  startVV, subscribeSet) 
 **/ 
    public void informInvalStreamInitiated(NodeId senderNodeId, 
					   SubscriptionSet is,
					   VV vvStart, 
					   boolean placeholderWriterSet)
    {
	Env.printDebug("informInvalStreamInitiated");
        assert logEnd < 0;
        logStart = System.currentTimeMillis();
    }

 /** 
 *  Fake method 
 **/ 
    public void informCommitStreamInitiated(NodeId senderNodeId)
    {
	Env.printDebug("informCommitStreamInitiated");
    }

 /** 
 *  Fake method 
 **/ 
    public void informBodyStreamInitiated(NodeId senderNodeId)
    {
	Env.printDebug("informBodyStreamInitiated");
    }

 /** 
 *  Fake method 
 **/ 
    public void informUnbindStreamInitiated(NodeId senderNodeId)
    {
	Env.printDebug("informUnbindStreamInitiated");
    }

 /** 
 *  Fake method 
 **/ 
    public void informSyncRplyStreamInitiated(NodeId senderNodeId)
    {
	Env.printDebug("informSyncRplyStreamInitiated");
    }

 /** 
 *  Fake method 
 **/ 
    public void informOutgoingInvalStreamInitiated(NodeId targetNodeId, 
						   SubscriptionSet is, 
						   VV startVV,
						   boolean placeholderWriterSet)
    {
	Env.printDebug("informOutgoingInvalStreamInitiated");
    }

 /** 
 *  Fake method 
 **/ 
    public void informOutgoingBodyStreamInitiated(NodeId targetNodeId, 
						   SubscriptionSet is, 
						   VV startVV,
						   boolean placeholderWriterSet)
    {
	Env.printDebug("informOutgoingBodyStreamInitiated");
    }


 /** 
 *  Fake method 
 **/ 
    public void informInvalStreamTerminated(NodeId senderNodeId, 
					   SubscriptionSet is,
					   VV vvStart, 
					   boolean placeholderWriterSet)
    {
	Env.printDebug("informInvalStreamTerminated");
        
    }

 /** 
 *  Fake method 
 **/ 
    public void informCommitStreamTerminated(NodeId senderNodeId)
    {
	Env.printDebug("informCommitStreamTerminated");
    }

 /** 
 *  Fake method 
 **/ 
    public void informBodyStreamTerminated(NodeId senderNodeId)
    {
	Env.printDebug("informBodyStreamTerminated");
    }

 /** 
 *  Fake method 
 **/ 
    public void informUnbindStreamTerminated(NodeId senderNodeId)
    {
	Env.printDebug("informUnbindStreamTerminated");
    }

 /** 
 *  Fake method 
 **/ 
    public void informSyncRplyStreamTerminated(NodeId senderNodeId)
    {
	Env.printDebug("informSyncRplyStreamTerminated");
    }

 /** 
 *  Fake method 
 **/ 
    public void informOutgoingInvalStreamTerminated(NodeId targetNodeId, 
						   SubscriptionSet is, 
						   VV startVV,
						   boolean placeholderWriterSet)
    {
	Env.printDebug("informOutgoingInvalStreamTerminated");
    }

 /** 
 *  Fake method 
 **/ 
    public void informOutgoingBodyStreamTerminated(NodeId targetNodeId, 
						   SubscriptionSet is, 
						   VV startVV,
						   boolean placeholderWriterSet)
    {
	Env.printDebug("informOutgoingBodyStreamTerminated");
    }

 /** 
 *  Fake method 
 **/ 
    public void recvSyncReply(AcceptStamp acceptStamp, NodeId sender)
    {
	Env.printDebug("recvSyncReply");
        
        
    }

 /** 
 *  Fake method 
 **/ 
    public void informReceivePushBody(BodyMsg msg)
    {
	Env.printDebug("informReceivePushBody");
    }
 /** 
 *  Fake method 
 **/ 
    public void informReceiveInval(GeneralInv inv)
    {
	Env.printDebug("informReceiveInval");
        if(inv.getEndVV().getMaxTimeStamp() >= logMaxStamp){
          logEnd = System.currentTimeMillis();
        }
    }

 /** 
 *  Fake method 
 **/ 
    public void informLocalWrite(ObjId objId, long offset, long length,
				 AcceptStamp as)
    {
	Env.printDebug("informLocalWrite");
    }

 /** 
 *  Fake method 
 **/ 
    public void informLocalDelete(ObjId objId)
    {
	Env.printDebug("informLocalDelete");
    }

 /** 
 *  Fake method 
 **/ 
    public void informDemandReadMiss(ObjId objId, long offset, long length)
    {
	Env.printDebug("informDemandReadMiss");
    }

 /** 
 *  Fake method 
 **/ 
    public void informReceiveDemandReply(BodyMsg msg)
    {
	Env.printDebug("informReceiveDemandReply");
    }

 /** 
 *  Fake method 
 **/ 
    public void informDemandReadHit(ObjId objId, long offset, long length)
    {
	Env.printDebug("informDemandReadHit");
    }
 /** 
 *  Fake method 
 **/ 
    public void informDemandImprecise(ObjId objId, 
                                      PreciseSet enclosingIS, 
                                      VV lpVV)
    {
	Env.printDebug("informDemandImprecise");
    }

 /** 
 *  Fake method 
 **/ 
    public void informBecameImprecise(PreciseSet is)
    {
	Env.printDebug("informBecameImprecise");
    }

 /** 
 *  Fake method 
 **/ 
    public void informBecamePrecise(PreciseSet is)
    {
	Env.printDebug("informBecamePrecise");
    }
 /** 
 **/ 
  //    inform methods for send-checkpoint protocol
 /** 
 **/ 
  
 /** 
 *  called in SubscribeInvalWorker when !(this.omitVV < startVV) i.e 
 *  gap exist between the sender's omitVV and the requested stream's  
 *  startVV. It implies that the ongoing subscribe inval stream is  
 *  failed. 
 *  
 *  What expected in the controller is to make the decision whether 
 *  to subscribe inval from other nodes for the receiver or invoke 
 *  a subscribeCheckpoint request to the same node optionally followed  
 *  by a subscribeInval request with a higher startVV 
 **/ 
  public void informGapExistForSubscribeInv(NodeId invReceiver,
                                            SubscriptionSet is,
                                            VV startVV,
                                            VV omitVV){
    Env.printDebug("informGapExistForSubscribeInv");
  }

 /** 
 *  inform Outgoing Checkpoint Stream initiated called in CPSendWorker 
 **/ 
  public void
  informOutgoingCheckpointStreamInitiated(NodeId targetNodeId, 
                                          String cpPath, 
                                          String[] exclChildNames,
                                          VV startVV,
                                          boolean placeholderWriterSet){
    Env.printDebug("informOutgoingCheckpointStreamInitiated");
  }
 /** 
 *  inform Outgoing Checkpoint Stream initiated called in CPSendWorker 
 **/ 
  public void
  informOutgoingCheckpointStreamTerminated(NodeId receiverNodeId,
                                           String cpPath,
                                           String[] exclChildNames,
                                           VV startVV, 
                                           boolean placeholderWriterSet){
    Env.printDebug("informOutgoingCheckpointStreamTerminated");
  }
 /** 
 *  inform a Checkpoint Stream initiated called in CPRecvWorker 
 **/ 
  public void
  informCheckpointStreamInitiated(NodeId senderNodeId, 
                                  String cpPath,
                                  String[] exclChildNames,
                                  VV vvStart,
                                  boolean placeholderWriterSet){
    Env.printDebug("informCheckpointStreamInitiated");
    cpStart = System.currentTimeMillis();
  }

 /** 
 *  inform a Checkpoint Stream terminated called in CPRecvWorker 
 **/ 
  public void
  informCheckpointStreamTerminated(NodeId senderNodeId, 
                                   String cpPath,
                                   String[] exclChildNames,
                                   VV vvStart, 
                                   boolean placeholderWriterSet){
    Env.printDebug("informCheckpointStreamTerminated");
  }

 /** 
 *  inform a Checkpoint Stream apply status called in CPRecvWorker 
 **/ 
  public void
  informCheckpointStreamReceiveStatus(NodeId senderNodeId, 
                                      String cpPath,
                                      String[] exclChildNames,
                                      VV vvStart, 
                                      boolean applyStatus,
                                      boolean placeholderWriterSet){
    Env.tbd("Controller needs to maintian a queue to store the status");
    if(applyStatus){
      cpUpdateDone = true;
      cpEnd = System.currentTimeMillis();
    }
  }

 /** 
 *  inform subscribe invalidate for a certain subscription set failed 
 **/ 
  public void
  informIncommingConnectionTerminated(NodeId senderNodeId,
                                      NodeId receiverNodeId,
                                      SubscriptionSet ss,
                                      VV vvStart,
                                      StreamId sId){
    Env.printDebug("informIncommingConnectionTerminated");
  }

 /** 
 *  inform subscribe invalidate for a certain subscription set failed 
 **/ 
  public void
  informSubscribeInvalFailed(NodeId senderNodeId,
                             NodeId receiverNodeId,
                             SubscriptionSet ss,
                             VV vvStart){
    Env.printDebug("informSubscribeInvalFailed");
  }

 /** 
 *  inform subscribe invalidate for a certain subscription set failed 
 **/ 
  public void
  informSubscribeInvalSucceeded(NodeId senderNodeId,
                                NodeId receiverNodeId,
                                SubscriptionSet ss,
                                VV vvStart){
    Env.printDebug("informSubscribeInvalSucceeded");
  }

  public boolean getCPUpdateStatus(){
    return cpUpdateDone;
  }
  
 /** 
 *  return the sync duration for cp  
 *   
 *  -1: cp has not done 
 **/ 
  public long cpSyncTime(){
    if(cpUpdateDone){
      return cpEnd - cpStart;
    }else{
      return -1;
    }
  }

 /** 
 *  return the sync duration for cp  
 *   
 *  -1: cp has not done 
 **/ 
  public long logSyncTime(){
    
    return logEnd - logStart;
  }
}
