 /** 
 *  This class is the receiver of the TwoNodeLogExchange  
 *  for the garbage collection robustness during the 
 *  synchronization of two physical nodes 
 *  
 *  note: the barrier server is runing on the same machine as sender  
 **/ 
import java.io.IOException;
import java.rmi.RemoteException;

public class LogReceiver{
  public static void main(String[] argv)
    throws Exception{
    if(argv.length < 5){
      System.out.println("Usage: LogReceiver [file number] [server ipaddress] [write number] [log|CP] [fileSize]");
      System.exit(0);
    }
	
    //start barrier server
    int port = 9494;
    int count = 2;
    int fileNumber = new Integer(argv[0]).intValue();
    long writeNumber = new Long(argv[2]).longValue();
    boolean useLog = false;
    if(argv[3].compareToIgnoreCase("log")==0){
      useLog = true;
    }

    int fileSize = new Integer(argv[4]).intValue();
    long senderId = 0;
    long receiverId = 1;
        
        
    BarrierClient bcReceiver = new BarrierClient(argv[1], 
                                                 port, 
                                                 1);

    Config.readConfig("logInTwoNodes.config");
    LogReceiverThread rt = new LogReceiverThread(bcReceiver,
                                                 fileNumber,
                                                 fileSize,
                                                 receiverId,
                                                 senderId,
                                                 true,
                                                 useLog,
                                                 writeNumber);
    rt.start();
    rt.join();
    
    System.exit(0);	
  }
}
