 /** 
 *  This class is the sender of the TwoNodeLogExchange  
 *  for the garbage collection robustness during the 
 *  synchronization of two physical nodes 
 *  
 *  note: the barrier server is runing on the same machine as sender  
 **/ 
import java.io.IOException;
import java.rmi.RemoteException;

public class LogSender{
  public static void main(String[] argv)
    throws Exception{
    if(argv.length <4){
      System.out.println("Usage: LogSender [file number] [write number] [log|CP] [fileSize]");
      System.exit(0);
    }
	
    //start barrier server
    int port = 9494;
    int count = 2;
    int fileNumber = new Integer(argv[0]).intValue();
    long writeNumber = new Long(argv[1]).longValue();
    boolean useLog = false;
    if(argv[2].compareToIgnoreCase("log")==0){
      useLog = true;
    }
    int fileSize = new Integer(argv[3]).intValue();
    long senderId = 0;
	
    BarrierServer bs = new BarrierServer(port, count);
    bs.start();

    BarrierClient bcSender = new BarrierClient("localhost", 
                                               port, 
                                               0);

    Config.readConfig("logInTwoNodes.config");
    LogSenderThread st = new LogSenderThread(bcSender,
                                             fileNumber,
                                             fileSize,
                                             senderId,
                                             useLog,
                                             writeNumber);
    st.start();
    st.join();
    
    System.exit(0);	
  }
}
