#!/lusr/bin/bash

# this script is used to run the local URANode to test
# the system limit like maxfilesize, how many files can
# can be written for a specific size, etc.
#
# Parameters: [BarrierServer]
#  
# output: collect data in results/figs/${Type}_${FileNum}Files.data
#
export CLASSPATH=./classes:.:./../../classes:./../sosp/PlanetLabExp/classes:./../../je-1.5.1/lib/je.jar

FileSize=100

for FileNum in 500 1000 #lines
do 
    Type=cp

    for WriteNum in 100 120 144 173 208 250 300 360 432 518 622 746 895 1074 1289 1547 1856
    do
	../../killall.sh &> /dev/null
	rm -rf /tmp/ufs/* &> /dev/null
	sleep 5 #wait for the sender to start the barrier server
	rmiregistry &
	java -ea -esa -Djava.rmi.server.codebase=file://./../../classes -Djava.security.policy=./../../java.security.SecurityPermission -Xmx1000m LogReceiver $FileNum $1 $WriteNum $Type $FileSize 2>&1 |tee results/receiver.output

	errors=`grep -i exception results/receiver.output|grep -v "Rethrowing exception java.io.EOFException"`
	if [ "$errors" == "" ]; then
	    echo ""
	    echo ":) receiver has no exceptions so far"
	    echo ""
	else
	    echo ""
	    echo "!!!!!!!Receiver has exceptions:"
	    echo "$errors"
	    echo ""
	    exit 1;
	fi
	more results/receiver.output|grep "\*\*\*\*" |cat >> results/figs/${Type}_${FileNum}Files.data
    
    done
done

#last line: log with filenum==1000
FileNum=1000
Type=log

for WriteNum in 100 120 144 173 208 250 300 360 432 518 622 746 895 1074 1289 1547 1856
do

    ../../killall.sh &> /dev/null
    rm -rf /tmp/ufs/* &> /dev/null
    sleep 5 #wait for the sender to start the barrier server
    rmiregistry &
    java -ea -esa -Djava.rmi.server.codebase=file://./../../classes -Djava.security.policy=./../../java.security.SecurityPermission -Xmx1000m LogReceiver $FileNum $1 $WriteNum $Type $FileSize 2>&1 |tee results/receiver.output

    errors=`grep -i exception results/receiver.output|grep -v "Rethrowing exception java.io.EOFException"`
    if [ "$errors" == "" ]; then
	echo ""
	echo ":) receiver has no exceptions so far"
	echo ""
    else
	echo ""
	echo "!!!!!!!Receiver has exceptions:"
	echo "$errors"
	echo ""
	exit 1;
    fi
    more results/receiver.output|grep "\*\*\*\*" |cat >> results/figs/${Type}_${FileNum}Files.data

done
