#!/lusr/bin/bash

# this script is used to run the sync vs write# experiments.
# of a single sender session.
# 
# Note: you must make sure that the conressponding variables such as FileNum
#       in the runReceivers.sh has the same values in the same order.
#
# output: collect ScanTime for 1 write info to results/ScanFor1Writes.data
#

export CLASSPATH=./classes:.:./../../classes:./../sosp/PlanetLabExp/classes:./../../je-1.5.1/lib/je.jar

if [ -e results/ScanFor1Writes.data ]; then
  rm results/ScanFor1Writes.data
fi

FileSize=100

for FileNum in 500 1000 #lines
do 
    Type=cp

    for WriteNum in 100 120 144 173 208 250 300 360 432 518 622 746 895 1074 1289 1547 1856
    do 
	../../killall.sh &> /dev/null
	rm -rf /tmp/ufs/* &> /dev/null
	sleep 1 
	rmiregistry &
	java -ea -esa -Djava.rmi.server.codebase=file://./../../classes -Djava.security.policy=./../../java.security.SecurityPermission -Xmx1000m LogSender $FileNum $WriteNum $Type $FileSize 2>&1 |tee results/sender.output
	
	errors=`grep -i exception results/sender.output|grep -v "Rethrowing exception java.io.EOFException"`
	if [ "$errors" == "" ]; then
	    echo ""
	    echo ":) sender has no exceptions"
	    echo ""
	else
	    echo ""
	    echo "!!!!!!!Sender has exceptions:"
	    echo "$errors"
	    echo ""
	    exit 1;
	fi
        
	#if [ "$WriteNum" == "1" ]; then
	    echo $FileNum $WriteNum|cat >> results/ScanFor_$FileNum.data
	    more results/sender.output|grep "CPScanTime:" |cat >> results/ScanFor_$FileNum.data
	#fi
    done
done

#last line: log with filenum==1000
Type=log
FileNum=1000
for WriteNum in 100 120 144 173 208 250 300 360 432 518 622 746 895 1074 1289 1547 1856
do
    ../../killall.sh &> /dev/null
    rm -rf /tmp/ufs/* &> /dev/null
    sleep 1 
    rmiregistry &
    java -ea -esa -Djava.rmi.server.codebase=file://./../../classes -Djava.security.policy=./../../java.security.SecurityPermission -Xmx1000m LogSender $FileNum $WriteNum $Type $FileSize 2>&1 |tee results/sender.output

    errors=`grep -i exception results/sender.output|grep -v "Rethrowing exception java.io.EOFException"`
    if [ "$errors" == "" ]; then
	echo ""
	echo ":) sender has no exceptions"
	echo ""
    else
	echo ""
    	echo "!!!!!!!Sender has exceptions:"
    	echo "$errors"
    	echo ""
    	exit 1;
    fi
done
