import java.util.*;
import java.net.*;
import java.io.*;


public class BarrierServer extends Thread{
  
  private Hashtable serversMap;
  private int barrierNumber;
  private long[] intervals;
  private long[] streams;
  private int blockCount;
  private int totalCount;
  private int listernPort;

  public static final String[] stageNames = {"Init done at central", "Init. propagation starting...", "Init. propagation done at individual servers", "Stage-1-stats", "Peer-wise exchange done at individual servers", "Stage-2-stats", "Results received at central server", "Stage-3-stats"};

  public BarrierServer(int port, int tCount){
    barrierNumber = 0; 
    serversMap = new Hashtable();
    blockCount = 0;
    totalCount = tCount;
    listernPort = port;
    intervals = new long[totalCount];
    streams = new long[totalCount];
  }

  public void run(){
    
    Socket incoming = null;
    ServerSocket ss = null;
    try{
      ss = new ServerSocket(listernPort);
    } catch (Exception e){
      e.printStackTrace();
    }
    Env.inform("Barrier server ready for work...");
    while(true){
      try{
        if (this.isInterrupted()){
          return;
        }
        incoming = ss.accept();
        ObjectInputStream ois = new ObjectInputStream(incoming.getInputStream());
        BarrierMsg bMsg = (BarrierMsg) ois.readObject();
        bMsg.setSocket(incoming);
        
        addToBarrier(bMsg);

        assert blockCount == serversMap.size();
        if(totalCount == blockCount){
          Env.inform("All servers completed stage " + stageNames[barrierNumber]);
          for(int i=0; i<totalCount; i++){
            Env.inform("Server-" + i + " time: " + intervals[i] + " bytes: " + streams[i]);
          }
          removeBarrier();
        } else {
          Env.inform(totalCount + ":::" + serversMap.size());
          assert totalCount > serversMap.size();
        }

      } catch (Exception e){
        e.printStackTrace();
        break;
      }
    }
  }
  
  public void addToBarrier(BarrierMsg msg){
    int sid = msg.getServerId();
    Env.inform(msg.getBarrierNumber() + "::" + barrierNumber);
    //assert msg.getBarrierNumber() != barrierNumber;
    Integer key = new Integer(sid);
    if(serversMap.containsKey(key)){
      assert false;
    } else {
      serversMap.put(key, msg);
      streams[sid] += msg.getStream();
      intervals[sid] = msg.getInterval();
      blockCount ++;
    }
  }

  public void removeBarrier() throws IOException{
    Env.inform("Activating servers for the next stage ...");
    assert blockCount == totalCount;
    barrierNumber ++;
    for(Enumeration e = serversMap.keys(); e.hasMoreElements();){
      // this is no fault-tolerant procedure
      BarrierMsg bMsg = (BarrierMsg)serversMap.remove((Integer)e.nextElement());
      assert bMsg != null;

      ObjectOutputStream oos = new ObjectOutputStream(bMsg.getSocket().getOutputStream());
      oos.writeObject(new Integer(barrierNumber));
      oos.flush();
      blockCount --;
    }
    assert serversMap.size() == 0;
    assert blockCount == 0;
//    resetIntervals();
  }

  public static void main(String[] argv){
    int port = (new Integer(argv[0])).intValue();
    int count = (new Integer(argv[1])).intValue();
    (new BarrierServer(port, count)).start();
  }

}
