 /** 
 *  Experiment-wide constants 
 **/ 
public class Constants{

 /** 
 *  Constants 
 **/ 
  public static final int NUM_OPERATIONS = 10000;
  public static final long MAX_INTER_OPERATION_TIME_MS = 100; // 100 ms
  public static final double READ_FRAC = 0.5; // 50%
  public static final int NUM_FILES = 1000;
  public static final double ALPHA = 1.1; // Zipf-distribution parameter
  public static final int FILE_SIZE_BYTES = 1000;

  public static final int DEMAND_ONLY = 1;
  public static final int PREFETCH = 2;
  public static final int PUSH_ALL = 3;

  // Used by SenderController and ReceiverController
  public static final int BEFORE_TIME_MS = -1;

 /** 
 *  Print the algorithm name 
 **/ 
  public static void
  printAlgorithm(int algorithm){
    switch(algorithm){
    case Constants.DEMAND_ONLY:
      System.err.println("DEMAND-ONLY");
      break;
    case Constants.PREFETCH:
      System.err.println("PREFETCH");
      break;
    case Constants.PUSH_ALL:
      System.err.println("PUSH-ALL");
      break;
    default:
      System.err.println("Bad algorithm number: " + algorithm);
      System.err.println("Must be between 1, 2, or 3");
      assert(false);
    }
  }
}
