 /** 
 *  A producer/consumer queue 
 **/ 
import java.util.LinkedList;

public class ProdConsQueue{

 /** 
 *  Constructor 
 **/ 
  public
  ProdConsQueue(){
    this.queue = new LinkedList();
    this.done = false;
  }

 /** 
 *  Enqueue a request 
 **/ 
  public synchronized void
  enqueue(Object obj){
    this.queue.addLast(obj);
    this.notifyAll();
  }

 /** 
 *  Wait for the queue to become empty (to be called by producer) 
 **/ 
  public synchronized void
  waitQueueEmpty(){
    // Should only be called after the done flag is set
    assert(this.done);
    while(!this.queue.isEmpty()){
      try{
        this.wait();
      }catch(InterruptedException e){
        e.printStackTrace();
        System.err.println("" + e);
        assert(false);
      }
    }
  }

 /** 
 *  Dequeue a request (or return null if we are done) 
 **/ 
  public synchronized Object
  dequeue(){
    Object obj = null;

    while(this.queue.isEmpty() && (!this.done)){
      try{
        this.wait();
      }catch(InterruptedException e){
        e.printStackTrace();
        System.err.println("" + e);
        assert(false);
      }
    }
    if(!this.queue.isEmpty()){
      obj = this.queue.removeFirst();
    }else{
      assert(this.done);
      obj = null;
      this.notifyAll();
    }
    return(obj);
  }


 /** 
 *  Return the number of queued requests 
 **/ 
  public synchronized int
  getQueueSize(){
    return(this.queue.size());
  }

 /** 
 *  Indicate that we are done adding to the queue 
 **/ 
  public synchronized void
  setDone(){
    this.done = true;
    this.notifyAll();
  }
  
 /** 
 *  Data members 
 **/ 
  private LinkedList queue;
  private boolean done;
}