 /** 
 *  A layer that is used to serialize all reads done by our threads 
 **/ 
import java.io.IOException;

public class ReadSerializer{

 /** 
 *  Constructor 
 **/ 
  public ReadSerializer(LocalInterface newLocalInterface){
    this.localInterface = newLocalInterface;
  }

 /** 
 *  Block until we can read the specified object 
 **/ 
  public synchronized BodyMsg
  readObjBlock(ObjId objId, long size) throws IOException{
    BodyMsg bodyMsg = null;

    try{
      // Do a non-blocking read
      bodyMsg = this.localInterface.read(objId, 0, size, false, true);
    }catch(ObjNotFoundException e){
      // This should not happen. We should have seen invals for all of
      // the writes done by the sender's initialize() method.
      e.printStackTrace();
      System.err.println("" + e);
      assert(false);
    }catch(ReadOfInvalidRangeException e){
      // Inform the controller and try again
      this.localInterface.informDemandReadMiss(objId, 0, size);
    }

    if(bodyMsg == null){
      try{
        // Already sent out out a demand request for the object
        bodyMsg = this.localInterface.readBlockInvalid(objId, 0, size, true);
      }catch(ObjNotFoundException e){
        e.printStackTrace();
        System.out.println("" + e);
        assert(false);
      }
    }
    assert(bodyMsg != null);
    return(bodyMsg);
  }

 /** 
 *  Constructor 
 **/ 
  private LocalInterface localInterface;
}