 /** 
 *  Simple controller for the TCP-LP experiments 
 **/ 
import java.util.BitSet;
import java.io.IOException;

public class ReceiverController implements Controller{

 /** 
 *  Constants 
 **/ 
  private static final int THREAD_NUM = 12;

 /** 
 *  Constructor 
 **/ 
  public
  ReceiverController(RMIClient newRMIClient,
                     NodeId newSenderNodeId,
                     NodeId newMyNodeId,
                     String newMyNodeDNS,
                     int newMyNodeDemandBodyPort,
                     OutputLogger newLogger){
    this.rmiClient = newRMIClient;
    this.senderNodeId = newSenderNodeId;
    this.myNodeId = newMyNodeId;
    this.myNodeDNS = newMyNodeDNS;
    this.myNodeDemandBodyPort = newMyNodeDemandBodyPort;
    this.logger = newLogger;
    this.startTimeMS = Constants.BEFORE_TIME_MS;
  }

 /** 
 *  If the incoming stream is terminated, try to get a checkpoint and 
 *  continue 
 **/ 
  public void
  informInvalStreamInitiated(NodeId senderNodeId, 
                             SubscriptionSet is,
                             VV vvStart, 
                             boolean placeholderWriterSet){
    Env.printDebug("informInvalStreamInitiated");    
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informInvalStreamTerminated(NodeId senderNodeId, 
                              SubscriptionSet is,
                              VV vvStart, 
                              boolean placeholderWriterSet,
                              StreamId sId){
    Env.printDebug("informInvalStreamTerminated");
  }


 /** 
 *  Fake method 
 **/ 
  public void
  informCommitStreamInitiated(NodeId senderNodeId){
    Env.printDebug("informCommitStreamInitiated");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informBodyStreamInitiated(NodeId senderNodeId){
    Env.printDebug("informBodyStreamInitiated");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informUnbindStreamInitiated(NodeId senderNodeId){
    Env.printDebug("informUnbindStreamInitiated");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informSyncRplyStreamInitiated(NodeId senderNodeId){
    Env.printDebug("informSyncRplyStreamInitiated");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informOutgoingInvalStreamInitiated(NodeId targetNodeId, 
                                     VV startVV,
                                     boolean placeholderWriterSet){
    Env.printDebug("informOutgoingInvalStreamInitiated");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informCommitStreamTerminated(NodeId senderNodeId){
    Env.printDebug("informCommitStreamTerminated");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informBodyStreamTerminated(NodeId senderNodeId){
    Env.printDebug("informBodyStreamTerminated");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informUnbindStreamTerminated(NodeId senderNodeId){
    Env.printDebug("informUnbindStreamTerminated");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informSyncRplyStreamTerminated(NodeId senderNodeId){
    Env.printDebug("informSyncRplyStreamTerminated");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informOutgoingInvalStreamTerminated(NodeId targetNodeId, 
				      SubscriptionSet is,
                                      VV startVV,
                                      boolean placeholderWriterSet){
    Env.printDebug("informOutgoingInvalStreamTerminated");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  recvSyncReply(AcceptStamp acceptStamp, NodeId sender){
    Env.printDebug("recvSyncReply");
  }

 /** 
 *  See if we had been waiting for this object 
 **/ 
  public void
  informReceivePushBody(BodyMsg msg){
    long exptTimeMS = 0;
    OutputLogEntry ole = null;

    Env.printDebug("informReceivePushBody");
    // Build an OutputLogEntry from information we have:
    // - Don't have different values for trace times and scheduled times:
    //   Use the same values
    exptTimeMS = Constants.BEFORE_TIME_MS;
    if(this.startTimeMS != Constants.BEFORE_TIME_MS){
      exptTimeMS = System.currentTimeMillis() - this.startTimeMS;
    }
    ole = new OutputLogEntry(exptTimeMS,            // trace time (ms)
                             exptTimeMS,            // scheduled time (ms)
                             OutputLogEntry.PUSH_ARRIV,  // operation
                             THREAD_NUM,            // thread number
                             msg.getObjId(),        // object id
                             msg.getAcceptStamp()); // data accept stamp
    try{
      this.logger.addEntry(ole);
    }catch(IOException e){
      e.printStackTrace();
      System.err.println("" + e);
      assert(false);
    }
  }

 /** 
 *  If this is a bound inval, see if we had been waiting for this object 
 **/ 
  public void
  informReceiveInval(GeneralInv inv, NodeId senderId){
    PreciseInv pi = null;
    BoundInval bi = null;
    long exptTimeMS = 0;
    OutputLogEntry ole = null;
    int operation = 0;

    Env.printDebug("informReceiveInval");
    assert(inv instanceof PreciseInv);
    pi = (PreciseInv)inv;
    if(pi.isBound()){
      operation = OutputLogEntry.BND_ARRIV;
    }else{
      operation = OutputLogEntry.INV_ARRIV;
    }

    // Build an OutputLogEntry from information we have:
    // - Don't have different values for trace times and scheduled times:
    //   Use the same values
    exptTimeMS = Constants.BEFORE_TIME_MS;
    if(this.startTimeMS != Constants.BEFORE_TIME_MS){
      exptTimeMS = System.currentTimeMillis() - this.startTimeMS;
    }
    ole = new OutputLogEntry(exptTimeMS,            // trace time (ms)
                             exptTimeMS,            // scheduled time (ms)
                             operation,             // operation
                             THREAD_NUM,            // thread number
                             pi.getObjId(),         // object id
                             pi.getAcceptStamp());  // data accept stamp
    try{
      this.logger.addEntry(ole);
    }catch(IOException e){
      e.printStackTrace();
      System.err.println("" + e);
      assert(false);
    }
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informLocalWrite(ObjId objId,
                   long offset,
                   long length,
                   AcceptStamp as,
                   boolean isBound,
                   boolean isEmbargoed){
    Env.printDebug("informLocalWrite");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informLocalDelete(ObjId objId){
    Env.printDebug("informLocalDelete");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informLocalReadInvalid(ObjId objId,
                         long offset,
                         long length,
                         AcceptStamp inval){
    Env.printDebug("informLocalReadInvalid");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informLocalReadImprecise(ObjId objId, long offset, long length){
    Env.printDebug("informLocalReadImprecise");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informDemandReadMiss(ObjId objId, long offset, long length){
    int numBytes = 0;
    long exptTimeMS = 0;
    OutputLogEntry ole = null;

    Env.printDebug("informDemandReadMiss");
    try{
      numBytes = this.rmiClient.issueDemandRead(objId,
                                                offset,
                                                length,
                                                -1,
                                                senderNodeId,
                                                myNodeId,
                                                myNodeDNS,
                                                myNodeDemandBodyPort);

      // Build a OutputLogEntry out of whatever information we have
      // - Use the same values for the trace and scheduled times
      // - Use null for the accept stamp since we don't have it
      exptTimeMS = Constants.BEFORE_TIME_MS;
      if(this.startTimeMS != Constants.BEFORE_TIME_MS){
        exptTimeMS = System.currentTimeMillis() - this.startTimeMS;
      }
      ole = new OutputLogEntry(exptTimeMS,             // trace time (ms)
                               exptTimeMS,             // scheduled time (ms)
                               OutputLogEntry.DEMAND_REQ, // operation
                               THREAD_NUM,             // thread number
                               objId,                  // object id
                               null);                  // data accept stamp
      this.logger.addEntry(ole);
    }catch(RMINetworkException e){
      e.printStackTrace();
      System.err.println("" + e);
      assert(false);
    }catch(RMIApplicationException e){
      e.printStackTrace();
      System.err.println("" + e);
      assert(false);
    }catch(ObjNotFoundException e){
      e.printStackTrace();
      System.err.println("" + e);
      assert(false);
    }catch(ReadOfInvalidRangeException e){
      e.printStackTrace();
      System.err.println("" + e);
      assert(false);
    }catch(IOException e){
      e.printStackTrace();
      System.err.println("" + e);
      assert(false);
    }
  }

 /** 
 *  Record the fact that this object arrived 
 **/ 
  public void
  informReceiveDemandReply(NodeId senderNodeId, BodyMsg msg){
    long exptTimeMS = 0;
    OutputLogEntry ole = null;

    Env.printDebug("informReceiveDemandReply");

    // Build a OutputLogEntry out of whatever information we have
    // - Use the same values for the trace and scheduled times
    exptTimeMS = Constants.BEFORE_TIME_MS;
    if(this.startTimeMS != Constants.BEFORE_TIME_MS){
      exptTimeMS = System.currentTimeMillis() - this.startTimeMS;
    }
    ole = new OutputLogEntry(exptTimeMS,             // trace time (ms)
                             exptTimeMS,             // scheduled time (ms)
                             OutputLogEntry.DEMAND_ARRIV, // operation
                             THREAD_NUM,             // thread number
                             msg.getObjId(),         // object id
                             msg.getAcceptStamp());  // data accept stamp
    try{
      this.logger.addEntry(ole);
    }catch(IOException e){
      e.printStackTrace();
      System.err.println("" + e);
      assert(false);
    }
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informDemandReadHit(ObjId objId, long offset, long length){
    Env.printDebug("informDemandReadHit");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informDemandImprecise(ObjId objId,
                        PreciseSet enclosingIS,
                        VV lpVV){
    Env.printDebug("informDemandImprecise");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informBecameImprecise(PreciseSet is){
    Env.printDebug("informBecameImprecise");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informBecamePrecise(PreciseSet is){
    Env.printDebug("informBecamePrecise");
  }

 /** 
 **/ 
  //    inform methods for send-checkpoint protocol
 /** 
 **/ 
  
 /** 
 *  called in SubscribeInvalWorker when !(this.omitVV < startVV) i.e 
 *  gap exist between the sender's omitVV and the requested stream's  
 *  startVV. It implies that the ongoing subscribe inval stream is  
 *  failed. 
 *  
 *  What expected in the controller is to make the decision whether 
 *  to subscribe inval from other nodes for the receiver or invoke 
 *  a subscribeCheckpoint request to the same node optionally followed  
 *  by a subscribeInval request with a higher startVV 
 **/ 
  public void
  informGapExistForSubscribeInv(NodeId invReceiver,
                                SubscriptionSet is,
                                VV startVV,
                                VV omitVV){
    Env.printDebug("informGapExistForSubscribeInv");
  }

 /** 
 *  inform Outgoing Checkpoint Stream initiated called in CPSendWorker 
 **/ 
  public void
  informOutgoingCheckpointStreamInitiated(NodeId targetNodeId, 
                                          String cpPath, 
                                          String[] exclChildNames,
                                          VV startVV,
                                          boolean placeholderWriterSet){
    Env.printDebug("informOutgoingCheckpointStreamInitiated");
  }
 /** 
 *  inform Outgoing Checkpoint Stream initiated called in CPSendWorker 
 **/ 
  public void
  informOutgoingCheckpointStreamTerminated(NodeId receiverNodeId,
                                           String cpPath,
                                           String[] exclChildNames,
                                           VV startVV, 
                                           boolean placeholderWriterSet){
    Env.printDebug("informOutgoingCheckpointStreamTerminated");
  }
 /** 
 *  inform a Checkpoint Stream initiated called in CPRecvWorker 
 **/ 
  public void
  informCheckpointStreamInitiated(NodeId senderNodeId, 
                                  String cpPath,
                                  String[] exclChildNames,
                                  VV vvStart,
                                  boolean placeholderWriterSet){
    Env.printDebug("informCheckpointStreamInitiated");
  }

 /** 
 *  inform a Checkpoint Stream terminated called in CPRecvWorker 
 **/ 
  public void
  informCheckpointStreamTerminated(NodeId senderNodeId, 
                                   String cpPath,
                                   String[] exclChildNames,
                                   VV vvStart, 
                                   boolean placeholderWriterSet){
    Env.printDebug("informCheckpointStreamTerminated");
  }

 /** 
 *  inform a Checkpoint Stream apply status called in CPRecvWorker 
 **/ 
  public void
  informCheckpointStreamReceiveStatus(NodeId senderNodeId, 
                                      String cpPath,
                                      String[] exclChildNames,
                                      VV vvStart, 
                                      boolean applyStatus,
                                      boolean placeholderWriterSet){
    Env.printDebug("informCheckpointStreamTerminated"); 
  }

 /** 
 **/ 
  //    inform methods for dynamic SubscriptionSets
 /** 
 **/ 

 /** 
 *  inform subscribe invalidate for a certain subscription set failed 
 **/ 
  public void
  informSubscribeInvalFailed(NodeId senderNodeId,
                             NodeId receiverNodeId,
                             SubscriptionSet ss,
                             VV vvStart){
    Env.printDebug("informSubscribeInvalFailed");
  }

 /** 
 *  inform subscribe invalidate for a certain subscription set failed 
 **/ 
  public void
  informSubscribeInvalSucceeded(NodeId senderNodeId,
                                NodeId receiverNodeId,
                                SubscriptionSet ss,
                                VV vvStart){
    Env.printDebug("informSubscribeInvalSucceeded");
  }
  
 /** 
 *  Fake method 
 **/ 
  public void 
  informOutgoingSubscribeInvalInitiated(NodeId receiverId, 
                                        SubscriptionSet subscriptionSet){
    Env.printDebug("informOutgoingSubscribeInvalInitiated");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informOutgoingSubscribeInvalTerminated(NodeId receiverId,
					 SubscriptionSet subscriptionSet){
    Env.printDebug("informOutgoingSubscribeInvalTerminated");
  }

 /** 
 *  Fake method 
 **/ 
  public void 
  informSubscribeBodySucceeded(NodeId senderNodeId,
                               SubscriptionSet ss){
    Env.printDebug("informSubscribeBodySucceeded");
  }

 /** 
 *  Fake method 
 **/ 
  public void 
  informSubscribeBodyRemoved(NodeId senderNodeId, SubscriptionSet ss){
    Env.printDebug("informSubscribeBodyRemoved");
  }

 /** 
 *  Fake method 
 **/ 
  public void 
  informOutgoingBodyStreamInitiated(NodeId receiverNodeId, 
				    boolean placeholderWriterSet){
    Env.printDebug("informOutgoingBodyStreamInitiated");
  }
				
 /** 
 *  Fake method 
 **/ 
  public void 
  informOutgoingBodyStreamTerminated(NodeId receiverNodeId, 
				     SubscriptionSet subscriptionSet,
				     boolean placeholderWriteSet){
    Env.printDebug("informOutgoingBodyStreamTerminated");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informOutgoingSubscribeBodyInitiated(NodeId receiverID, 
				       SubscriptionSet subscriptionSet){
    Env.printDebug("informOutgoingSubscribeBodyInitiated");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informOutgoingSubscribeBodyTerminated(NodeId receiverId,
					SubscriptionSet subscriptionSet){
    Env.printDebug("informOutgoingSubscribeBodyTerminated");
  }

 /** 
 *  INDEPENDENT METHODS 
 **/ 

 /** 
 *  Inform this controller that the experiment time has started 
 **/ 
  public void
  startClock(){
    this.startTimeMS = System.currentTimeMillis();
  }

 /** 
 *  Data members 
 **/ 
  private RMIClient rmiClient;
  private NodeId senderNodeId;
  private NodeId myNodeId;
  private String myNodeDNS;
  private int myNodeDemandBodyPort;
  private OutputLogger logger;
  private long startTimeMS;
}
