 /** 
 *  Simple controller for the sender of the TCP-LP experiments 
 **/ 
import java.util.BitSet;
import java.io.IOException;

public class SenderController implements Controller{

 /** 
 *  Constants 
 **/ 
  private static final int THREAD_NUM = 11;

 /** 
 *  Constructor 
 **/ 
  public
  SenderController(OutputLogger newLogger){
    this.logger = newLogger;
    this.startTimeMS = Constants.BEFORE_TIME_MS;
    this.hasAppliedCheckpoint = false;
    this.wasCheckpointSuccessful = false;
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informInvalStreamInitiated(NodeId senderNodeId, 
                             SubscriptionSet is,
                             VV vvStart, 
                             boolean placeholderWriterSet){
    Env.printDebug("informInvalStreamInitiated");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informCommitStreamInitiated(NodeId senderNodeId){
    Env.printDebug("informCommitStreamInitiated");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informBodyStreamInitiated(NodeId senderNodeId){
    Env.printDebug("informBodyStreamInitiated");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informUnbindStreamInitiated(NodeId senderNodeId){
    Env.printDebug("informUnbindStreamInitiated");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informSyncRplyStreamInitiated(NodeId senderNodeId){
    Env.printDebug("informSyncRplyStreamInitiated");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informOutgoingInvalStreamInitiated(NodeId targetNodeId, 
                                     VV startVV,
                                     boolean placeholderWriterSet){
    Env.printDebug("informOutgoingInvalStreamInitiated");
  }

 /** 
 *  inform subscribe invalidate for a certain subscription set failed 
 **/ 
  public void
  informSubscribeInvalFailed(NodeId senderNodeId,
                             NodeId receiverNodeId,
                             SubscriptionSet ss,
                             VV vvStart){
    Env.printDebug("informSubscribeInvalFailed");
  }

 /** 
 *  inform subscribe invalidate for a certain subscription set failed 
 **/ 
  public void
  informSubscribeInvalSucceeded(NodeId senderNodeId,
                                NodeId receiverNodeId,
                                SubscriptionSet ss,
                                VV vvStart){
    Env.printDebug("informSubscribeInvalSucceeded");
  }
  
 /** 
 *  Fake method 
 **/ 
  public void 
  informOutgoingSubscribeInvalInitiated(NodeId receiverId, 
                                        SubscriptionSet subscriptionSet){
    Env.printDebug("informOutgoingSubscribeInvalInitiated");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informOutgoingSubscribeInvalTerminated(NodeId receiverId,
					 SubscriptionSet subscriptionSet){
    Env.printDebug("informOutgoingSubscribeInvalTerminated");
  }

 /** 
 *  Fake method 
 **/ 
  public void 
  informSubscribeBodySucceeded(NodeId senderNodeId,
                               SubscriptionSet ss){
    Env.printDebug("informSubscribeBodySucceeded");
  }

 /** 
 *  Fake method 
 **/ 
  public void 
  informSubscribeBodyRemoved(NodeId senderNodeId, SubscriptionSet ss){
    Env.printDebug("informSubscribeBodyRemoved");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informOutgoingBodyStreamInitiated(NodeId targetNodeId,
                                    boolean placeholderWriterSet){
    Env.printDebug("informOutgoingBodyStreamInitiated");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informInvalStreamTerminated(NodeId senderNodeId,
                              SubscriptionSet is,
                              VV vvStart, 
                              boolean placeholderWriterSet,
                              StreamId sId){
    Env.printDebug("informInvalStreamTerminated");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informCommitStreamTerminated(NodeId senderNodeId){
    Env.printDebug("informCommitStreamTerminated");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informBodyStreamTerminated(NodeId senderNodeId){
    Env.printDebug("informBodyStreamTerminated");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informUnbindStreamTerminated(NodeId senderNodeId){
    Env.printDebug("informUnbindStreamTerminated");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informSyncRplyStreamTerminated(NodeId senderNodeId){
    Env.printDebug("informSyncRplyStreamTerminated");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informOutgoingInvalStreamTerminated(NodeId targetNodeId, 
                                      SubscriptionSet is, 
                                      VV startVV,
                                      boolean placeholderWriterSet){
    Env.printDebug("informOutgoingInvalStreamTerminated");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informOutgoingBodyStreamTerminated(NodeId targetNodeId, 
                                     SubscriptionSet is, 
                                     boolean placeholderWriterSet){
    Env.printDebug("informOutgoingBodyStreamTerminated");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  recvSyncReply(AcceptStamp acceptStamp, NodeId sender){
    Env.printDebug("recvSyncReply");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informReceivePushBody(BodyMsg msg){
    Env.printDebug("informReceivePushBody");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informReceiveInval(GeneralInv inv, NodeId senderId){
    Env.printDebug("informReceiveInval");
  }

 /** 
 *  Write information about this write to the log 
 *  
 *  NOTE: We have to be very careful because technically just by 
 *  inspecting the log there is no way to correlate WRITE_START and 
 *  WRITE_FINISH events. We don't face this problem because we have 
 *  a single-threaded writer, so each WRITE_FINISH event necessarily 
 *  follows a WRITE_START event. 
 *  
 *  Also, note that WRITE_FINISH isn't really the time a write is 
 *  finished. It is only the time at which the controller has been 
 *  informed that a write is about to happen. 
 **/ 
  public void
  informLocalWrite(ObjId objId,
                   long offset,
                   long length,
                   AcceptStamp as,
                   boolean isBound,
                   boolean isEmbargoed){
    long exptTimeMS = 0;
    OutputLogEntry ole = null;

    Env.printDebug("informLocalWrite");
    // Build an OutputLogEntry from information we have:
    // - Don't have an event number: Use 0
    // - Don't have different values for trace times and scheduled times:
    //   Use the same values
    exptTimeMS = Constants.BEFORE_TIME_MS;
    if(this.startTimeMS != Constants.BEFORE_TIME_MS){
      exptTimeMS = System.currentTimeMillis() - this.startTimeMS;
    }
    ole = new OutputLogEntry(exptTimeMS,            // trace time (ms)
                             exptTimeMS,            // scheduled time (ms)
                             OutputLogEntry.WRITE_FINISH,  // operation
                             THREAD_NUM,            // thread number
                             objId,                 // object id
                             as);                   // data accept stamp
    try{
      this.logger.addEntry(ole);
    }catch(IOException e){
      e.printStackTrace();
      System.err.println("" + e);
      assert(false);
    }
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informLocalDelete(ObjId objId){
    Env.printDebug("informLocalDelete");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informDemandReadMiss(ObjId objId, long offset, long length){
    Env.printDebug("informDemandReadMiss");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informLocalReadInvalid(ObjId objId,
                         long offset,
                         long length,
                         AcceptStamp inval){
    Env.printDebug("informLocalReadInvalid");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informLocalReadImprecise(ObjId objId, long offset, long length){
    Env.printDebug("informLocalReadImprecise");
  }

 /** 
 *  Record the fact that this object arrived 
 **/ 
  public void
  informReceiveDemandReply(NodeId senderNodeId, BodyMsg msg){
    Env.printDebug("informReceiveDemandReply");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informDemandReadHit(ObjId objId, long offset, long length){
    Env.printDebug("informDemandReadHit");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informDemandImprecise(ObjId objId,
                        PreciseSet enclosingIS,
                        VV lpVV){
    Env.printDebug("informDemandImprecise");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informBecameImprecise(PreciseSet is){
    Env.printDebug("informBecameImprecise");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informBecamePrecise(PreciseSet is){
    Env.printDebug("informBecamePrecise");
  }

 /** 
 **/ 
  //    inform methods for send-checkpoint protocol
 /** 
 **/ 
  
 /** 
 *  called in SubscribeInvalWorker when !(this.omitVV < startVV) i.e 
 *  gap exist between the sender's omitVV and the requested stream's  
 *  startVV. It implies that the ongoing subscribe inval stream is  
 *  failed. 
 *  
 *  What expected in the controller is to make the decision whether 
 *  to subscribe inval from other nodes for the receiver or invoke 
 *  a subscribeCheckpoint request to the same node optionally followed  
 *  by a subscribeInval request with a higher startVV 
 **/ 
  public void
  informGapExistForSubscribeInv(NodeId invReceiver,
                                SubscriptionSet is,
                                VV startVV,
                                VV omitVV){
    Env.printDebug("informGapExistForSubscribeInv");
  }

 /** 
 *  inform Outgoing Checkpoint Stream initiated called in CPSendWorker 
 **/ 
  public void
  informOutgoingCheckpointStreamInitiated(NodeId targetNodeId, 
                                          String cpPath, 
                                          String[] exclChildNames,
                                          VV startVV,
                                          boolean placeholderWriterSet){
    Env.printDebug("informOutgoingCheckpointStreamInitiated");
  }
 /** 
 *  inform Outgoing Checkpoint Stream initiated called in CPSendWorker 
 **/ 
  public void
  informOutgoingCheckpointStreamTerminated(NodeId receiverNodeId,
                                           String cpPath,
                                           String[] exclChildNames,
                                           VV startVV, 
                                           boolean placeholderWriterSet){
    Env.printDebug("informOutgoingCheckpointStreamTerminated");
  }
 /** 
 *  inform a Checkpoint Stream initiated called in CPRecvWorker 
 **/ 
  public void
  informCheckpointStreamInitiated(NodeId senderNodeId, 
                                  String cpPath,
                                  String[] exclChildNames,
                                  VV vvStart,
                                  boolean placeholderWriterSet){
    Env.printDebug("informCheckpointStreamInitiated");
  }

 /** 
 *  inform a Checkpoint Stream terminated called in CPRecvWorker 
 **/ 
  public synchronized void
  informCheckpointStreamTerminated(NodeId senderNodeId, 
                                   String cpPath,
                                   String[] exclChildNames,
                                   VV vvStart, 
                                   boolean placeholderWriterSet){
    Env.printDebug("informCheckpointStreamTerminated");
    this.hasAppliedCheckpoint = true;
    this.notifyAll();
  }

 /** 
 *  inform a Checkpoint Stream apply status called in CPRecvWorker 
 **/ 
  public void
  informCheckpointStreamReceiveStatus(NodeId senderNodeId, 
                                      String cpPath,
                                      String[] exclChildNames,
                                      VV vvStart, 
                                      boolean applyStatus,
                                      boolean placeholderWriterSet){
    Env.printDebug("informCheckpointStreamTerminated"); 
    this.wasCheckpointSuccessful = applyStatus;
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informOutgoingSubscribeBodyInitiated(NodeId receiverID, 
				       SubscriptionSet subscriptionSet){
    Env.printDebug("informOutgoingSubscribeBodyInitiated");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informOutgoingSubscribeBodyTerminated(NodeId receiverId,
					SubscriptionSet subscriptionSet){
    Env.printDebug("informOutgoingSubscribeBodyTerminated");
  }

 /** 
 *  INDEPENDENT METHODS 
 **/ 

 /** 
 *  Wait until the checkpoint is applied 
 **/ 
  public synchronized void
  waitAppliedCheckpoint(){
    while(!this.hasAppliedCheckpoint){
      try{
        this.wait();
      }catch(InterruptedException e){
        System.err.println("" + e);
      }
    }
  }

 /** 
 *  Return true if this checkpoint was applied successfully 
 **/ 
  public synchronized boolean
  checkpointSuccessful(){
    return(this.wasCheckpointSuccessful);
  }

 /** 
 *  Inform this controller that the experiment time has started 
 **/ 
  public void
  startClock(){
    this.startTimeMS = System.currentTimeMillis();
  }

 /** 
 *  Data members 
 **/ 
  private OutputLogger logger;
  private long startTimeMS;
  private boolean hasAppliedCheckpoint;
  private boolean wasCheckpointSuccessful;
}
