 /** 
 *  Read and parse the list that contains names and sizes of all objects 
 **/ 
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.StringTokenizer;

public class AllAccessedFilesListReader{

 /** 
 *  Constructor 
 **/ 
  public
  AllAccessedFilesListReader(String gzippedFileName) throws IOException{
    InputStreamReader isr = null;
    GunzipProcess gunzipProcess = null;

    gunzipProcess = new GunzipProcess(gzippedFileName);
    gunzipProcess.startProcess();
    isr = new InputStreamReader(gunzipProcess.getInputStream());
    this.reader = new BufferedReader(isr);
    this.hasMore = this.readNextEntry();
  }

 /** 
 *  Return true if this list is not empty yet 
 **/ 
  public boolean
  hasMoreEntries(){
    return(this.hasMore);
  }

 /** 
 *  Read the next entry in the list 
 **/ 
  public void
  moveToNextEntry() throws IOException{
    assert(this.hasMore);
    this.hasMore = this.readNextEntry();
  }

 /** 
 *  Return the object ID contained in this entry 
 **/ 
  public String
  getObjectId(){
    return(this.objectId);
  }

 /** 
 *  Return the object size contained in this entry 
 **/ 
  public long
  getSize(){
    return(this.size);
  }

 /** 
 *  Used for testing 
 **/ 
  public static void main(String[] argv){
    AllAccessedFilesListReader aaflr = null;
    String objId = null;
    long size = 0;

    try{
      AllAccessedFilesListReader.generateGzippedFile("temp.dat");
      aaflr = new AllAccessedFilesListReader("temp.dat.gz");
      while(aaflr.hasMoreEntries()){
        objId = aaflr.getObjectId();
        size = aaflr.getSize();
        System.out.println("objId = " + objId + ", size = " + size);
        aaflr.moveToNextEntry();
      }
    }catch(IOException e){
      System.err.println("" + e);
    }
  }

 /** 
 *  Return the object size contained in this entry 
 **/ 
  private boolean
  readNextEntry() throws IOException{
    String line = null;
    boolean done = false;
    String[] tokens = null;

    line = this.reader.readLine();
    while((!done) && (line != null)){
      try{
        tokens = line.split("\\s");
        if(tokens.length == 2){
          this.objectId = tokens[0];
          this.size = Long.parseLong(tokens[1]);
          done = true;
        }else{
          System.err.println("AllAccessedFilesListReader: " +
                             "More than two tokens!");
          done = false;
          line = this.reader.readLine();
        }
      }catch(NumberFormatException e){
        System.err.println("" + e);
        done = false;
        line = this.reader.readLine();
      }
    }
    return(line != null);
  }

 /** 
 *  Generate a file with random entries in a format readable by this class 
 **/ 
  private static void
  generateGzippedFile(String fileName) throws IOException{
    FileOutputStream fos = null;
    PrintStream ps = null;
    Process gzipProcess = null;

    try{
      fos = new FileOutputStream(fileName);
      ps = new PrintStream(fos);
      ps.println("/a/f1\t12345");
      ps.println("/b/f2\t543");
      gzipProcess = Runtime.getRuntime().exec("c:\\cygwin\\bin\\gzip.exe " +
                                              fileName);
      try{
        gzipProcess.waitFor();
      }catch(InterruptedException e){
        System.err.println("" + e);
        assert(false);
      }
    }finally{
      if(ps != null){
        ps.close();
      }
      if(fos != null){
        try{
          fos.close();
        }catch(IOException e){
          // Do nothing;
        }
      }
    }
  }

 /** 
 *  Private data 
 **/ 
  private String objectId;
  private long size;
  private BufferedReader reader;
  private boolean hasMore;
}