 /** 
 *  CostData: Store info about how much it "costs" to prefetch an object 
 **/ 
public class CostData{

 /** 
 *  Constructor 
 **/ 
    public CostData()
    {
	this.numUpdates = 0;
	this.numAccesses = 0;
	this.sizeSum = 0;
    }

 /** 
 *  Constructor 
 **/ 
    public CostData(int numUpdates, int numAccesses, long sizeSum)
    {
	this.numUpdates = numUpdates;
	this.numAccesses = numAccesses;
	this.sizeSum = sizeSum;
    }

 /** 
 *  Indicate that there was another update to this object 
 **/ 
    public void addUpdate(long size)
    {
	this.numUpdates++;
	this.sizeSum += size;
    }

 /** 
 *  Indicate that there was another read access to this object 
 **/ 
    public void addAccess()
    {
	this.numAccesses++;
    }

 /** 
 *  Return the number of times this object was written 
 **/ 
    public int getUpdateCount()
    {
	return(this.numUpdates);
    }

 /** 
 *  Return the number of times this object was read 
 **/ 
    public int getAccessCount()
    {
	return(this.numAccesses);
    }

 /** 
 *  Return the total size of the object across all updates 
 **/ 
    public long getSizeSum()
    {
	return(this.sizeSum);
    }

 /** 
 *  Protected data 
 **/ 
    protected int numUpdates;
    protected int numAccesses;
    protected long sizeSum;
}
