import java.io.OutputStream;
import java.io.InputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.BufferedReader;
import java.util.Enumeration;
import java.util.Hashtable;

// For testing
import java.io.FileInputStream;
import java.io.FileOutputStream;

 /** 
 *  CostFile: Write information collected from an update trace to a stream 
 **/ 
public class CostFile{

 /** 
 *  Constructor 
 **/ 
    public CostFile(Hashtable costTable, OutputStream os) throws IOException
    {
	String objectID = null;
	CostData cd = null;
	String str = null;

	this.costTable = costTable;
	for(Enumeration e = this.costTable.keys(); e.hasMoreElements();){
	    objectID = (String)e.nextElement();
	    cd = (CostData)this.costTable.get(objectID);
	    str = objectID + "\t" +
		cd.getUpdateCount() + "\t" +
		cd.getAccessCount() + "\t" +
		cd.getSizeSum() + "\n";
	    os.write(str.getBytes());
	}
    }

 /** 
 *  Constructor 
 **/ 
    public CostFile(InputStream is) throws IOException
    {
	CostData cd = null;
	String line = null;
	String objectID = null;
	InputStreamReader isr = null;
	BufferedReader reader = null;

	isr = new InputStreamReader(is);
	reader = new BufferedReader(isr);
	this.costTable = new Hashtable();

	line = reader.readLine();
	while(line != null){
	    objectID = this.getObjectID(line);
	    cd = this.getCostData(line);
	    this.costTable.put(objectID, cd);
	    line = reader.readLine();
	}
    }

 /** 
 *  Return the cost table 
 **/ 
    public Hashtable getCostTable()
    {
	return(this.costTable);
    }

 /** 
 *  Extract the object ID from the passed-in line 
 **/ 
    private static String getObjectID(String line)
    {
	int tabIndex = 0;

	tabIndex = line.indexOf('\t');
	return(line.substring(0, tabIndex));
    }

 /** 
 *  Extract the cost data from the passed-in line 
 **/ 
    private static CostData getCostData(String line)
    {
	long sizeSum = 0;
	int numUpdates = 0;
	int numAccesses = 0;
	int firstTabIndex = 0;
	int secondTabIndex = 0;
	int thirdTabIndex = 0;

	firstTabIndex = line.indexOf('\t');
	secondTabIndex = line.indexOf('\t', firstTabIndex + 1);
	thirdTabIndex = line.indexOf('\t', secondTabIndex + 1);

	numUpdates = Integer.parseInt(line.substring(firstTabIndex + 1,
						     secondTabIndex));
	numAccesses = Integer.parseInt(line.substring(secondTabIndex + 1,
						      thirdTabIndex));
	sizeSum = Long.parseLong(line.substring(thirdTabIndex + 1));
	return(new CostData(numUpdates, numAccesses, sizeSum));
    }

 /** 
 *  Used for testing 
 **/ 
    public static void main(String[] argv)
    {
	Assert.affirm(argv.length == 2);
	FileOutputStream fileOS = null;
	FileInputStream fileIS = null;
	Hashtable table = null;
	CostData cd = null;
	CostFile cf = null;
	String objectID = null;

	try{
	    if(argv[1].equals("w")){
		fileOS = new FileOutputStream(argv[0]);
		table = new Hashtable();

		cd = new CostData(25, 15, 30);
		table.put("fileA", cd);
		cd = new CostData(25, 28, 30);
		cd.addUpdate(10);
		cd.addUpdate(20);
		table.put("fileB", cd);

		cf = new CostFile(table, fileOS);
		fileOS.close();
	    }else{
		fileIS = new FileInputStream(argv[0]);
		cf = new CostFile(fileIS);
		table = cf.getCostTable();
		for(Enumeration e = table.keys(); e.hasMoreElements();){
		    objectID = (String)e.nextElement();
		    cd = (CostData)table.get(objectID);
		    System.out.println(objectID + ", " +
				       cd.getUpdateCount() + ", " +
				       cd.getAccessCount() + ", " +
				       cd.getSizeSum());
		}
	    }
	}catch(IOException e){
	    System.err.println("" + e);
	}
    }

 /** 
 *  Protected data 
 **/ 
    Hashtable costTable;
}
