 /** 
 *  Generate the list of all files accessed by our traces 
 **/ 
import java.io.OutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class GenAllAccessedFilesList{

 /** 
 *  Constants 
 **/ 
  public static final long DEFAULT_FILE_SIZE = 15;

 /** 
 *  Constructor 
 **/ 
  public
  GenAllAccessedFilesList(String[] newAccessTraceFileNames)
    throws IOException{
    this.accessLogReaders =
      new AccessLogReader[newAccessTraceFileNames.length];
    for(int i = 0; i < this.accessLogReaders.length; i++){
      this.accessLogReaders[i] =
        new AccessLogReader(newAccessTraceFileNames[i]);
    }
  }

 /** 
 *  Write the generated list to OutputStream os 
 **/ 
  public void writeListToOS(OutputStream os) throws IOException{
    HashMap objTable = null;
    PrintStream ps = null;
    AccessLogRecord alr = null;
    WebLogRequest request = null;
    String objIdString = null;
    HashSet unknownSizeSet = null;

    objTable = new HashMap();
    unknownSizeSet = new HashSet();
    ps = new PrintStream(os);
    for(int i = 0; i < this.accessLogReaders.length; i++){
      alr = this.accessLogReaders[i].getNextStaticRecord();
      while(alr != null){
        request = alr.getRequest();
        objIdString = request.getFixedObjectID();
        if((!request.isDynamic()) && (!objTable.containsKey(objIdString))){
          if((alr.getStatus() != 304) && (alr.getNumBytes() >= 0)){
            objTable.put(objIdString, new Long(alr.getNumBytes()));
            ps.println(objIdString + "\t" + alr.getNumBytes());
            assert alr.getNumBytes() >= 0 : "" + alr;
            unknownSizeSet.remove(objIdString);
          }else{
            unknownSizeSet.add(objIdString);
          }
        }
        alr = this.accessLogReaders[i].getNextStaticRecord();
      }
    }
    for(Iterator i = unknownSizeSet.iterator(); i.hasNext();){
      objIdString = (String)i.next();
      ps.println(objIdString + "\t" + DEFAULT_FILE_SIZE);
    }
  }

 /** 
 *  Program starting point 
 **/ 
  public static void main(String[] argv){
    GenAllAccessedFilesList gaafl = null;

    try{
      // Usage: java GenAllAcessedFilesList <accessTrace.gz>+
      assert(GenAllAccessedFilesList.checkNames(argv));
      gaafl = new GenAllAccessedFilesList(argv);
      gaafl.writeListToOS(System.out);
    }catch(IOException e){
      System.err.println("" + e);
    }
  }

 /** 
 *  Return true if this log record represents a valid file 
 **/ 
  private static boolean
  isAccessLogRecordValid(AccessLogRecord alr){
    // Check return code + data size
    WebLogRequest request = null;
    boolean isValid = false;

    assert(alr != null);
    request = alr.getRequest();
    isValid = (alr.getStatus() != 304) && (!request.isDynamic());
    return(isValid);
  }

 /** 
 *  Sanity check: Make sure all parameters are gzipped file names 
 **/ 
  private static boolean checkNames(String[] accessTraceFileNames){
    boolean allCorrect = true;

    for(int i = 0; (i < accessTraceFileNames.length) && allCorrect; i++){
      allCorrect = accessTraceFileNames[i].endsWith(".gz");
    }
    return(allCorrect);
  }

 /** 
 *  Private data 
 **/ 
  private AccessLogReader[] accessLogReaders;
}
