 /** 
 *  GenCostFile: Generate the cost file, which stores update counts and sizes 
 **/ 
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;

public class GenCostFile{

 /** 
 *  Constants 
 **/ 
    public static final String OLD_PREFIX = "/jfs/daedalus/cddo/sink";
    public static final int OLD_PREFIX_LEN = 23;

 /** 
 *  Constructor 
 **/ 
    public GenCostFile() throws IOException
    {
	InputStreamReader isr =  null;

	isr = new InputStreamReader(System.in);
	this.stdinReader = new BufferedReader(isr);
	this.costTable = new Hashtable();
    }

 /** 
 *  Generate the file 
 **/ 
    public void genFile(String fileName) throws IOException
    {
	CostData costData = null;
	UpdateTraceRecord utr = null;
	FileOutputStream fOS = null;
	CostFile costFile = null;

	utr = this.readNextUpdateRecord();
	while(utr != null){
	    costData = (CostData)this.costTable.get(utr.getObjectID());
	    if(costData == null){
		costData = new CostData();
		this.costTable.put(utr.getObjectID(), costData);
	    }
	    costData.addUpdate(utr.getObjectSize());
	    utr = this.readNextUpdateRecord();
	}

	fOS = new FileOutputStream(fileName);
	costFile = new CostFile(this.costTable, fOS);
	fOS.close();
    }

 /** 
 *  Read the next record from the update trace 
 **/ 
    protected UpdateTraceRecord readNextUpdateRecord() throws IOException
    {
	String line = null;
	UpdateTraceRecord utr = null;
	String objectID = null;
	UpdateTraceRecord modifiedRecord = null;

	line = this.stdinReader.readLine();
	if(line != null){
	    utr = new UpdateTraceRecord(line);
	    objectID = utr.getObjectID();
	    Assert.affirm(objectID.startsWith(OLD_PREFIX));
	    objectID = objectID.substring(OLD_PREFIX_LEN);
	    modifiedRecord = new UpdateTraceRecord(objectID,
						   utr.getObjectSize(),
						   utr.getTimeMS());
	}
	return(modifiedRecord);
    }

 /** 
 *  Program starting point 
 **/ 
    public static void main(String[] argv)
    {
	GenCostFile gcf = null;

	try{
	    Assert.affirm(argv.length == 1);
	    gcf = new GenCostFile();
	    gcf.genFile(argv[0]);
	}catch(IOException e){
	    System.err.println("" + e);
	}
    }

 /** 
 *  Protected 
 **/ 
    protected BufferedReader stdinReader;
    protected Hashtable costTable;
}
