 /** 
 *  Generate the priority file from the cost file and read trace 
 **/ 
import java.io.IOException;
import java.io.FileInputStream;
import java.util.Hashtable;
import java.util.Enumeration;

public class GenPriorityFile{

 /** 
 *  Constructor 
 **/ 
  public
  GenPriorityFile(String costFileName) throws IOException{
    CostFile costFile = null;

    costFile = new CostFile(new FileInputStream(costFileName));
    this.costTable = costFile.getCostTable();
  }

 /** 
 *  Program starting point 
 **/ 
  public static void
  main(String[] argv){
    GenPriorityFile gpf = null;

    try{
      assert(argv.length == 1);
      gpf = new GenPriorityFile(argv[0]);
      gpf.writePriorities();
    }catch(IOException e){
      System.err.println("" + e);
    }
  }

 /** 
 *  Program starting point 
 **/ 
  protected void
  writePriorities(){
    CostData cd = null;
    String objectID = null;
    double cost = 0.0;

    System.out.println("0");  // Delay
    System.out.println("" + this.costTable.size());
    for(Enumeration e = this.costTable.keys(); e.hasMoreElements();){
      objectID = (String)e.nextElement();
      cd = (CostData)this.costTable.get(objectID);
      Assert.affirm(cd != null);
      // Cost = accesses / (writes * ave_size)
      // ave_size = sum_sizes / writes
      // ===> Cost = accesses / sum_sizes
      cost = (double)cd.getAccessCount() / (double)cd.getSizeSum();
      System.out.println(objectID + " " + cost);
    }
  }

  /*
  //-----------------------------------------------------------------------
  // Generate the table of read access counts
  //-----------------------------------------------------------------------
  protected void genReadCountTable() throws IOException
  {
  Integer benefitInt = null;
  String objectID = null;
  WebLogRecord wlr = null;
  CostData costData = null;
  String reqString = null;
  WebLogRequest request = null;

  wlr = this.readNextEntry();
  while(wlr != null){
  try{
  reqString = wlr.getRequest();
  request = new WebLogRequest(reqString);
  objectID = request.getObjectID();
  costData = (CostData)this.costTable.get(objectID);
  if(costData != null){
  benefitInt = (Integer)this.readCountTable.get(objectID);
  if(benefitInt != null){
  benefitInt = new Integer(benefitInt.intValue() + 1);
  }else{
  benefitInt = new Integer(1);
  }
  this.readCountTable.put(objectID, benefitInt);
  }
  }catch(WebLogRecord.UnparseableException e){
  System.err.println("" + e);
  }
  wlr = this.readNextEntry();
  }
  }

  //-----------------------------------------------------------------------
  // Generate the table of read access counts
  //-----------------------------------------------------------------------
  protected WebLogRecord readNextEntry() throws IOException
  {
  boolean done = false;
  String line = null;
  WebLogRecord webLogRecord = null;

  do{
  line = this.stdinReader.readLine();
  if(line != null){
  try{
  webLogRecord = new WebLogRecord(line);
  done = true;
  }catch(WebLogRecord.UnparseableException e){
  done = false;
  }
  }else{
  webLogRecord = null;
  done = true;
  }
  }while(!done);
  return(webLogRecord);
  }
  */

 /** 
 *  Protected data 
 **/ 
  protected Hashtable costTable;
}
