 /** 
 *  Represent a process that is gunzip'ping a file to stdout 
 **/ 
import java.io.InputStream;
import java.io.IOException;
import java.io.File;

public class GunzipProcess{

 /** 
 *  Constants 
 **/ 
  private static final String GZIP_PATH = "/bin/gzip";
  private static final String DECOMPRESSION_PARAMETER = "-d";
  private static final String STDOUT_PARAMETER = "-c";

 /** 
 *  Constructor 
 **/ 
  public GunzipProcess(String newFileName){
    this.fileName = newFileName;
    this.gunzipProcess = null;
    assert((new File(this.fileName)).exists());
  }

 /** 
 *  Start the process 
 **/ 
  public void startProcess() throws IOException{
    Runtime myRuntime = null;
    String[] cmd = null;

    myRuntime = Runtime.getRuntime();

    cmd = new String[4];
    cmd[0] = GZIP_PATH;
    cmd[1] = DECOMPRESSION_PARAMETER;
    cmd[2] = STDOUT_PARAMETER;
    cmd[3] = fileName;
    this.gunzipProcess = myRuntime.exec(cmd);
  }

 /** 
 *  Return the stream that gunzip's standard output is redirected to 
 **/ 
  public InputStream getInputStream(){
    assert (this.gunzipProcess != null):"Haven't started process yet!";
    return(this.gunzipProcess.getInputStream());
  }

 /** 
 *  Used for testing 
 **/ 
  public static void main(String[] argv){
    GunzipProcess gp = null;
    InputStream is = null;
    byte[] buffer = null;
    int numBytesRead = 0;

    try{
      assert(argv.length == 1);
      gp = new GunzipProcess(argv[0]);
      gp.startProcess();
      is = gp.getInputStream();

      // Write what we get to stdout
      buffer = new byte[1000];
      numBytesRead = is.read(buffer);
      while(numBytesRead >= 0){
        System.out.write(buffer, 0, numBytesRead);
        numBytesRead = is.read(buffer);
      }
    }catch(SecurityException e){
      System.err.println("Sec: " + e);
    }catch(IllegalArgumentException e){
      System.err.println("IAE: " + e);
    }catch(IOException e){
      System.err.println("IOE: " + e);
    }
  }

 /** 
 *  Private data 
 **/ 
  private String fileName;
  private Process gunzipProcess;
}