// NOTE: TEMPORARY COPY!

 /** 
 *  ObjId: Immutable class that represents an object ID in the system 
 **/ 
import java.io.Serializable;

public class ObjId implements Serializable, Immutable
{

    //*Notes on IMMUTABLE*
    // A bunch of primitive objects (including this one) are 
    // *immutable* classes.  We do this because references to them
    // get passed around throughout the system and they are basically
    // all just container classes.
    //
    // Immutable class as per
    // http://www-106.ibm.com/developerworks/java/library/j-jtp02183.html
    // This means we must do the following:
    //
    //  * All of its fields are final
    //  * The class is declared final
    //  * The this reference is not allowed to escape during construction
    //  * Any fields that contain references to mutable objects, such as arrays, collections, or mutable classes like Date:
    //        o Are private
    //        o Are never returned or otherwise exposed to callers
    //        o Are the only reference to the objects that they reference
    //        o Do not change the state of the referenced objects after construction

    private final String path;

    //-----------------------------------------------------------------------
    // Constructor
    //-----------------------------------------------------------------------
    public ObjId(String path_)
    {
	this.path = path_;
    }

    public Object clone()
    {
	return new ObjId(path);
    }

    //-----------------------------------------------------------------------
    // Return true if two obj ID's refer to the same object
    //-----------------------------------------------------------------------
    public final boolean equals(Object o)
    {
	boolean result = false;
	ObjId oid = null;

	if(o instanceof ObjId){
	    oid = (ObjId)o;
	    result = this.path.equals(oid.path);
	}else{
	    result = false;
	}
	return(result);
    }

    public int hashCode(){
	return path.hashCode();
    }

    public int compareTo(Object o){
	ObjId oid = (ObjId) o;
	return path.compareTo(oid.path);
    }

    //-----------------------------------------------------------------------
    // Return the path to this object
    //-----------------------------------------------------------------------
    public final String getPath()
    {
	// NOTE: toString() does the same thing as this method, but for
	// clarity we want to restrict the use of toString() to debugging
	// and testing
	return(this.path);
    }



    //-----------------------------------------------------------------------
    // Used for testing
    //-----------------------------------------------------------------------
    public static void main(String[] argv)
    {
	ObjId objId1 = null;
	ObjId objId2 = null;

	//Env.verifyAssertEnabled();
	System.err.println("ObjId self test...");

	objId1 = new ObjId("Some path");
	assert(objId1.toString().equals("Some path"));
	assert(!objId1.equals(new ObjId("Some path 2")));

	objId2 = new ObjId("Some path");
	assert(objId1.equals(objId2));
	assert((new ObjId("")).toString().equals(""));
	assert("Some path".equals(objId1.getPath()));

	System.err.println("...ObjId self test succeeds");
	System.exit(0);
    }

    /* override toString in class object */
    public String toString(){
        return path;
    }
}

 /** 
/* $Log: ObjId.java,v $
/* Revision 1.1  2005/10/03 23:06:55  nayate
/* Added the new IBM trace experiment for the NSDI paper
/*
/* Revision 1.12  2004/08/18 22:44:44  dahlin
/* Made BoundInval subclass of PreciseInval; RandomAccessState passes 2 self tests
/*
/* Revision 1.11  2004/07/28 14:27:35  dahlin
/* Added sanity checks for immutable objects
/*
/* Revision 1.10  2004/05/10 19:07:46  nayate
/* Changed testing code to use asserts
/*
/* Revision 1.9  2004/05/10 18:56:31  dahlin
/* Created PendingDemandList and PendingDemandRequest (needed by SDIMSController)
/*
/* Revision 1.8  2004/05/03 19:35:54  nayate
/* Started making changes to allow passing an interest set to all union
/* operations.
/*
/* Revision 1.7  2004/04/27 07:59:05  lgao
/* Initial implementation for UpdatePriorityQueue
/*
/* Revision 1.6  2004/04/20 04:25:18  nayate
/* Tested ObjId
/*
/* Revision 1.5  2004/04/19 23:30:04  lgao
/* Initial implementation of the RMI package and modification to Makefile.
/*
/* Revision 1.4  2004/04/18 04:13:03  nayate
/* Finished (but didn't test) ObjInvalTarget and associated classes
/*
/* Revision 1.3  2004/04/16 16:05:17  nayate
/* Subset of PreciseInv implemented + removed some compiler errors.
/*
/* Revision 1.2  2004/04/15 20:04:25  nayate
/* New Makefile; added provision to allow CVS to append file modification
/* logs to files.
/* */
 **/ 
