 /** 
 *  Generate a new cost file from the given cost file and read trace 
 **/ 
import java.io.InputStreamReader;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;

public class UpdateCostFile{

 /** 
 *  Constructor 
 **/ 
    public UpdateCostFile(String costFileName) throws IOException
    {
	CostFile costFile = null;
	FileInputStream fileIS = null;
	InputStreamReader isr = null;

	isr = new InputStreamReader(System.in);
	this.stdinReader = new BufferedReader(isr);

	fileIS = new FileInputStream(costFileName);
	costFile = new CostFile(fileIS);
	this.costTable = costFile.getCostTable();
	fileIS.close();
    }

 /** 
 *  Generate the new file 
 **/ 
  public void genFile(String costFileName) throws IOException{
    String objectID = null;
    AccessLogRecord alr = null;
    CostData costData = null;
    WebLogRequest request = null;
    FileOutputStream fileOS = null;

    alr = this.readNextEntry();
    while(alr != null){
      request = alr.getRequest();
      objectID = request.getObjectID();
      costData = (CostData)this.costTable.get(objectID);
      if(costData != null){
        costData.addAccess();
      }
      alr = this.readNextEntry();
    }

    fileOS = new FileOutputStream(costFileName);
    new CostFile(this.costTable, fileOS);
    fileOS.close();
  }

 /** 
 *  Program staring point 
 **/ 
  public static void main(String[] argv){
    UpdateCostFile upf = null;

    try{
      assert(argv.length == 1);
      upf = new UpdateCostFile(argv[0]);
      upf.genFile(argv[0]);
    }catch(IOException e){
      System.err.println("" + e);
    }
  }

 /** 
 *  Return the next entry in the web log 
 **/ 
  protected AccessLogRecord readNextEntry() throws IOException{
    boolean done = false;
    String line = null;
    AccessLogRecord accessLogRecord = null;

    do{
      line = this.stdinReader.readLine();
      if(line != null){
        try{
          accessLogRecord = new AccessLogRecord(line);
          done = true;
        }catch(AccessLogRecord.UnparseableException e){
          done = false;
        }
      }else{
        accessLogRecord = null;
        done = true;
      }
    }while(!done);
    return(accessLogRecord);
  }

 /** 
 *  Protected data 
 **/ 
  protected BufferedReader stdinReader;
  protected Hashtable costTable;
}
