 /** 
 *  Read and parse an update log 
 **/ 
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.BufferedReader;


public class UpdateLogReader{

 /** 
 *  Constants 
 **/ 
  public static final String OLD_PREFIX = "/jfs/daedalus/cddo/sink";
  public static final int OLD_PREFIX_LEN = 23;

 /** 
 *  Constructor 
 **/ 
  public UpdateLogReader(String fileName) throws IOException{
    InputStream is = null;
    GunzipProcess gunzipProcess = null;

    assert(fileName.endsWith("gz"));
    gunzipProcess = new GunzipProcess(fileName);
    gunzipProcess.startProcess();
    is = gunzipProcess.getInputStream();
    this.reader = new BufferedReader(new InputStreamReader(is));
  }

 /** 
 *  Return the next valid update trace record in the file 
 **/ 
  public UpdateTraceRecord getNextValidRecord() throws IOException{
    String line = null;
    UpdateTraceRecord utr = null;
    String objectID = null;
    UpdateTraceRecord modifiedRecord = null;

    line = this.reader.readLine();
    if(line != null){
      utr = new UpdateTraceRecord(line);
      objectID = utr.getObjectID();
      assert(objectID.startsWith(OLD_PREFIX));
      objectID = objectID.substring(OLD_PREFIX_LEN);
      modifiedRecord = new UpdateTraceRecord(objectID,
                                             utr.getObjectSize(),
                                             utr.getTimeMS());
    }
    return(modifiedRecord);
  }

 /** 
 *  Used for testing 
 **/ 
  public static void main(String[] argv){
    UpdateLogReader alr = null;
    UpdateTraceRecord utr = null;

    try{
      assert(argv.length == 1);
      alr = new UpdateLogReader(argv[0]);
      utr = alr.getNextValidRecord();
      while(utr != null){
        System.out.println("" + utr.getTimeMS());
        utr = alr.getNextValidRecord();
      }
    }catch(IOException e){
      System.err.println("" + e);
    }
  }

 /** 
 *  Private data 
 **/ 
  private BufferedReader reader;
}
