import java.util.Date;
import java.util.GregorianCalendar;

// Testing
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.IOException;

 /** 
 *  UpdateTraceRecord: Used to store records from update logs 
 **/ 
public class UpdateTraceRecord{

 /** 
 *  Constants 
 **/ 
  public final static int YEAR = 2000;

 /** 
 *  Constructor 
 **/ 
  public UpdateTraceRecord(String rawRecord){
    int si = 0;

    si = rawRecord.indexOf(' '); // "Trigger"
    si = rawRecord.indexOf(' ', si + 1); // "ID"
    si = rawRecord.indexOf(' ', si + 1); // "is:"
    si = this.extractTime(rawRecord, si + 1);

    si = rawRecord.indexOf(' ', si + 1); // Trigger ID number
    si = rawRecord.indexOf(' ', si + 1); // Trigger ID string
    si = this.extractObjectSize(rawRecord, si + 1);

    si = rawRecord.indexOf(' ', si + 1); // "Filename"
    this.objectID = rawRecord.substring(si + 1);
  }

 /** 
 *  Constructor 2 
 **/ 
  public UpdateTraceRecord(String objectID, long size, long timeMS){
    this.objectID = objectID;
    this.size = size;
    this.timeMS = timeMS;
  }

 /** 
 *  Extract the date from the update trace record 
 **/ 
  private int extractTime(String rawRecord, int dateStart){
    int si = 0;
    int dateEnd = 0;
    int timeEnd = 0;
    int timeStart = 0;
    String dateString = null;
    String timeString = null;

    dateEnd = rawRecord.indexOf(' ', dateStart);
    dateString = rawRecord.substring(dateStart, dateEnd);
    timeStart = dateEnd + 1;
    timeEnd = rawRecord.indexOf(' ', timeStart);
    timeString = rawRecord.substring(timeStart, timeEnd);
    this.timeMS = this.parseTimeStrings(dateString, timeString);
    return(timeEnd);
  }

 /** 
 *  Extract the object size from the update trace record 
 **/ 
  private int extractObjectSize(String rawRecord, int sizeStart){
    int sizeEnd = 0;

    sizeEnd = rawRecord.indexOf(' ', sizeStart);
    this.size = Long.parseLong(rawRecord.substring(sizeStart, sizeEnd));
    return(sizeEnd);
  }

 /** 
 *  Convert the date string into ms since epoch 
 **/ 
  private long parseTimeStrings(String dateString, String timeString){
    int day = 0;
    int month = 0;
    int hours = 0;
    int minutes = 0;
    int seconds = 0;
    Date date = null;
    int slashIndex = 0;
    long epochTime = 0;
    int firstColonIndex = 0;
    int secondColonIndex = 0;
    GregorianCalendar cal = null;

    slashIndex = dateString.indexOf('/');
    month = Integer.parseInt(dateString.substring(0, slashIndex));
    day = Integer.parseInt(dateString.substring(slashIndex + 1));

    firstColonIndex = timeString.indexOf(':');
    hours = Integer.parseInt(timeString.substring(0, firstColonIndex));
    secondColonIndex = timeString.indexOf(':', firstColonIndex + 1);
    minutes = Integer.parseInt(timeString.substring(firstColonIndex + 1,
                                                    secondColonIndex));
    seconds = Integer.parseInt(timeString.substring(secondColonIndex + 1));

    cal = new GregorianCalendar(UpdateTraceRecord.YEAR,
                                month - 1, // 0-indexed month count
                                day,
                                hours,
                                minutes,
                                seconds);
    date = cal.getTime();
    epochTime = date.getTime();
    return(epochTime);
  }

 /** 
 *  Return the objectID 
 **/ 
  public String getObjectID(){
    return(this.objectID);
  }

 /** 
 *  Return the time 
 **/ 
  public long getTimeMS(){
    return(this.timeMS);
  }

 /** 
 *  Return the size 
 **/ 
  public long getObjectSize(){
    return(this.size);
  }

 /** 
 *  Print the information 
 **/ 
  public String toString(){
    String str = "";
    Date date = null;

    str += "(";
    date = new Date(this.timeMS);
    str += date.toString();
    str += ", " + this.size + ", " + objectID + ")";
    return(str);
  }

 /** 
 *  For testing 
 **/ 
  public static void main(String[] argv){
    String line = null;
    BufferedReader br = null;
    InputStreamReader isr = null;
    UpdateTraceRecord utr = null;
    UpdateTraceRecord utr2 = null;

    try{
      isr = new InputStreamReader(System.in);
      br = new BufferedReader(isr);
      line = br.readLine();
      while(line != null){
        utr = new UpdateTraceRecord(line);
        utr2 = new UpdateTraceRecord(utr.getObjectID(),
                                     utr.getObjectSize(),
                                     utr.getTimeMS());
        System.out.println("" + utr);
        System.out.println("" + utr2);
        System.out.println("ObjectID = " + utr.getObjectID());
        System.out.println("Time = " + utr.getTimeMS());
        System.out.println("Size = " + utr.getObjectSize());
        line = br.readLine();
      }
    }catch(IOException e){
      System.err.println("" + e);
    }
  }

 /** 
 *  Private date 
 **/ 
  private long timeMS;
  private long size;
  private String objectID;
}
