 /** 
 *  Get the breakdown of the bandwidth for subscribeInv, demandread, and subscribeBody 
 **/ 
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.HashMap;
import java.util.Random;
import java.util.Vector;

public class Bandwidth extends CoordExptA
{
  public static long SUBSCRIPTION_DURATION_MS = 1000000;  // 1000 seconds
  public static long MAX_DELAY_MS = 1000; // 1 second

 /** 
 *  Constructor 
 **/ 
  public Bandwidth(String exptConfigFileName, String shellType_)
    {
      super(exptConfigFileName, shellType_);
    }
  
 /** 
 *  Demand Read the required percentage of files one by one and return the 
 *  last file demandReaded so that for experiments we know when it's over 
 **/ 
  public String demandReadPartialFiles(int supplierNodeId, 
                                       int receiverNodeId, 
                                       long numTotalFiles,
                                       double percentage,
                                       long fileSize){
    String fileName = null;
    long numFiles = Math.round(numTotalFiles * percentage);
    for(long i = 0; i < numFiles; i++){
      fileName = this.senderScriptGen.createFileName(i, numTotalFiles);
      this.issueDemandRead(supplierNodeId,
                           receiverNodeId,
                           fileName,
                           0,
                           fileSize,
                           i);
    }
    return fileName;
  }

 /** 
 *  Experiment 1: check the bandwidth distribution 
 *                write 1 bit, 10 bit, 100 bit unbound  -- precise 
 *                write 1 bit, 10 bit, 100 bit bound -- Boundmsg 
 *                demandread 1 bit, 10 bit, 100 bit --- bodymsg 
 **/ 
  public void runExpt1(long numFiles, long fileSize)
    {
      CoordCommPacket ccp = null;
      StatsRecord initStats = null;
      StatsRecord finalStats = null;
      StatsRecord diffStats = null;
      SubscriptionSet dis = null;
        
      long start, end;
      double avgMS;
      AcceptStamp asAfterWrite, asAfterRead;
	
      this.restartRMIRegistrySync();
      this.startNode(9);
      this.startNode(10);
      
      this.waitStartNode(9);
      this.waitStartNode(10);
      
      System.err.println("1111");
      initStats = this.getAllStats();
      System.err.println("2222");
      this.sendPopulateFullScript(9, 
                                  false, //bound
                                  numFiles, //numFiles
                                  fileSize);   // file size
      System.err.println("3333");
      ccp = this.recv(9);
      assert(ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
      assert(ccp.getData() instanceof AcceptStamp);
      System.err.println("4444");
      asAfterWrite = (AcceptStamp)ccp.getData();
      
      finalStats = this.getAllStats();
      diffStats = finalStats.getDiff(initStats);
      System.err.println("populate 1 bit file = + a g command" + diffStats);

      initStats = finalStats;
      
      dis = SubscriptionSet.makeSubscriptionSet("/a");
	
      AcceptStamp[] as1 = new AcceptStamp[1];
      as1[0] = asAfterWrite;
      this.issueSubscribe(9,
                          10,
                          AcceptVV.makeVVAllNegatives(),
                          new AcceptVV(as1),
 
                          dis,
                          SUBSCRIPTION_DURATION_MS,
                          MAX_DELAY_MS);
      this.sendSync(10, asAfterWrite);
      ccp = this.recv(10);
      assert(ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
      assert(ccp.getData() == null);
      System.out.println("Received a SYNC_DONE");
      // post condition:
      // Sender and receiver have synchronized for the first initial
      // sequential writes.
        
      finalStats = this.getAllStats();
      diffStats = finalStats.getDiff(initStats);
      System.err.println("node 10 subscribe 1 precise + sync" + diffStats);
      initStats = this.getAllStats();

      start = System.currentTimeMillis();
      String lastFile = this.demandReadPartialFiles(9,
                                             10,
                                             numFiles,
                                             1,
                                             fileSize);
      //System.err.println("111111111");
      //read the last demanded file to make sure 
      // that all the demanded files arrive.
      this.sendRead(10, lastFile, 0, fileSize);
      //System.err.println("222222222");
      ccp = this.recv(10);
      //System.err.println("333333y333333");
      assert(ccp.getSignalType() == CoordCommPacket.READ_DONE);
      assert(ccp.getData() instanceof AcceptStamp);

      end = System.currentTimeMillis();
      avgMS = ((double)((double)end - (double)start))/((double)(numFiles));
      finalStats = this.getAllStats();
      diffStats = finalStats.getDiff(initStats);
      System.err.println("DemandRead " + fileSize + " bit file time:" 
                         + avgMS + "ms");
      System.err.println("DemandRead 1 bit file" + diffStats);
      
      System.out.println("Exit value for node 9 = " + this.killNode(9));
      System.out.println("Exit value for node 10 = " + this.killNode(10));

    }

 /** 
 *  Program starting point 
 **/ 
  public static void main(String[] argv)
    {
      Bandwidth coord = null;

      if (argv.length < 4){
        System.out.println("Usage: <exptConfigfile> <shellType> <fileNum> <fileSize>");
        System.exit(-1);
      }
      coord = new Bandwidth(argv[0], argv[1]);
      coord.runExpt1(new Long(argv[2]).longValue(), 
                     new Long(argv[3]).longValue());
    }
}

 /** 
 *  $Log: Bandwidth.java,v $ 
 *  Revision 1.4  2005/03/15 21:15:35  zjiandan 
 *  Automatic GC checked in. 
 *  
 *  Revision 1.3  2005/03/02 21:44:07  zjiandan 
 *  Modified to work with new code 
 *  
 *  Revision 1.2  2005/02/28 20:26:00  zjiandan 
 *  Added Garbage Collection code and part of Checkpoint exchange protocol code 
 *  
 *  Revision 1.1  2005/01/13 20:55:41  zjiandan 
 *  Reorganized sosp experiments files into sosp subdirectory under experiments. 
 *  
 **/ 
