 /** 
 *  Start two timers when the inval stream is initiated. 
 *  Stop one when we see NUM_FILES invalidates, and stop the 
 *  other when we see NUM_FILES object bodies. 
 **/ 
import java.util.BitSet;
import java.io.IOException;

public class NiceExptController implements Controller{

 /** 
 *  Data members 
 **/ 
  private RMIClient rmiClient;
  private NodeId senderNodeId;
  private NodeId myNodeId;
  private String myNodeDNS;
  private int myNodeDemandBodyPort;

 /** 
 *  Constructor 
 **/ 
  public
  NiceExptController(RMIClient newRMIClient,
                     NodeId newSenderNodeId,
                     NodeId newMyNodeId,
                     String newMyNodeDNS,
                     int newMyNodeDemandBodyPort){
    this.rmiClient = newRMIClient;
    this.senderNodeId = newSenderNodeId;
    this.myNodeId = newMyNodeId;
    this.myNodeDNS = newMyNodeDNS;
    this.myNodeDemandBodyPort = newMyNodeDemandBodyPort;
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informInvalStreamInitiated(NodeId senderNodeId, 
                             SubscriptionSet is,
                             VV vvStart, 
                             boolean placeholderWriterSet){
    Env.printDebug("informInvalStreamInitiated");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informCommitStreamInitiated(NodeId senderNodeId){
    Env.printDebug("informCommitStreamInitiated");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informBodyStreamInitiated(NodeId senderNodeId){
    Env.printDebug("informBodyStreamInitiated");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informUnbindStreamInitiated(NodeId senderNodeId){
    Env.printDebug("informUnbindStreamInitiated");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informSyncRplyStreamInitiated(NodeId senderNodeId){
    Env.printDebug("informSyncRplyStreamInitiated");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informOutgoingInvalStreamInitiated(NodeId targetNodeId, 
                                     SubscriptionSet is, 
                                     VV startVV,
                                     boolean placeholderWriterSet){
    Env.printDebug("informOutgoingInvalStreamInitiated");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informOutgoingBodyStreamInitiated(NodeId targetNodeId,
                                    SubscriptionSet is, 
                                    VV startVV,
                                    boolean placeholderWriterSet){
    Env.printDebug("informOutgoingBodyStreamInitiated");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informInvalStreamTerminated(NodeId senderNodeId,
                              SubscriptionSet is,
                              VV vvStart, 
                              boolean placeholderWriterSet){
    Env.printDebug("informInvalStreamTerminated");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informCommitStreamTerminated(NodeId senderNodeId){
    Env.printDebug("informCommitStreamTerminated");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informBodyStreamTerminated(NodeId senderNodeId){
    Env.printDebug("informBodyStreamTerminated");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informUnbindStreamTerminated(NodeId senderNodeId){
    Env.printDebug("informUnbindStreamTerminated");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informSyncRplyStreamTerminated(NodeId senderNodeId){
    Env.printDebug("informSyncRplyStreamTerminated");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informOutgoingInvalStreamTerminated(NodeId targetNodeId, 
                                      SubscriptionSet is, 
                                      VV startVV,
                                      boolean placeholderWriterSet){
    Env.printDebug("informOutgoingInvalStreamTerminated");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informOutgoingBodyStreamTerminated(NodeId targetNodeId, 
                                     SubscriptionSet is, 
                                     VV startVV,
                                     boolean placeholderWriterSet){
    Env.printDebug("informOutgoingBodyStreamTerminated");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  recvSyncReply(AcceptStamp acceptStamp, NodeId sender){
    Env.printDebug("recvSyncReply");
  }

 /** 
 *  See if we had been waiting for this object 
 **/ 
  public void
  informReceivePushBody(BodyMsg msg){

    Env.printDebug("informReceivePushBody");
    /*
      if((this.mbox != null) && (this.mbox.getObjId().equals(msg.getObjId()))){
      // Wake the mailbox and indicate that we are no longer waiting
      // for anything
      this.mbox.wake(msg.getAcceptStamp());
      this.mbox = null;
      }
    */
  }

 /** 
 *  If this is a bound inval, see if we had been waiting for this object 
 **/ 
  public void
  informReceiveInval(GeneralInv inv){
    PreciseInv pi = null;
    BoundInval bi = null;

    Env.printDebug("informReceiveInval");
    /*
      assert(inv instanceof PreciseInv);
      pi = (PreciseInv)inv;
      if(pi.isBound()){
      bi = (BoundInval)pi;
      if((this.mbox != null) && (this.mbox.getObjId().equals(bi.getObjId()))){
      // Wake the mailbox and indicate that we are no longer waiting
      // for anything
      this.mbox.wake(bi.getAcceptStamp());
      this.mbox = null;
      }
      }
    */
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informLocalWrite(ObjId objId,
                   long offset,
                   long length,
                   AcceptStamp as){
    Env.printDebug("informLocalWrite");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informLocalDelete(ObjId objId){
    Env.printDebug("informLocalDelete");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informDemandReadMiss(ObjId objId, long offset, long length){
    int numBytes = 0;

    Env.printDebug("informDemandReadMiss");
    try{
      numBytes = this.rmiClient.issueDemandRead(objId,
                                                offset,
                                                length,
                                                -1,
                                                senderNodeId,
                                                myNodeId,
                                                myNodeDNS,
                                                myNodeDemandBodyPort);
    }catch(RMINetworkException e){
      e.printStackTrace();
      System.err.println("" + e);
      assert(false);
    }catch(RMIApplicationException e){
      e.printStackTrace();
      System.err.println("" + e);
      assert(false);
    }catch(ObjNotFoundException e){
      e.printStackTrace();
      System.err.println("" + e);
      assert(false);
    }catch(ReadOfInvalidRangeException e){
      e.printStackTrace();
      System.err.println("" + e);
      assert(false);
    }catch(IOException e){
      e.printStackTrace();
      System.err.println("" + e);
      assert(false);
    }
    assert(numBytes == Constants.FILE_SIZE_BYTES);
  }

 /** 
 *  Record the fact that this object arrived 
 **/ 
  public void
  informReceiveDemandReply(BodyMsg msg){

    Env.printDebug("informReceiveDemandReply");
    /*
      if((this.mbox != null) && (this.mbox.getObjId().equals(msg.getObjId()))){
      // Wake the mailbox and indicate that we are no longer waiting
      // for anything
      this.mbox.wake(msg.getAcceptStamp());
      this.mbox = null;
      }
    */
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informDemandReadHit(ObjId objId, long offset, long length){
    Env.printDebug("informDemandReadHit");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informDemandImprecise(ObjId objId,
                        PreciseSet enclosingIS,
                        VV lpVV){
    Env.printDebug("informDemandImprecise");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informBecameImprecise(PreciseSet is){
    Env.printDebug("informBecameImprecise");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informBecamePrecise(PreciseSet is){
    Env.printDebug("informBecamePrecise");
  }

 /** 
 **/ 
  //    inform methods for send-checkpoint protocol
 /** 
 **/ 
  
 /** 
 *  called in SubscribeInvalWorker when !(this.omitVV < startVV) i.e 
 *  gap exist between the sender's omitVV and the requested stream's  
 *  startVV. It implies that the ongoing subscribe inval stream is  
 *  failed. 
 *  
 *  What expected in the controller is to make the decision whether 
 *  to subscribe inval from other nodes for the receiver or invoke 
 *  a subscribeCheckpoint request to the same node optionally followed  
 *  by a subscribeInval request with a higher startVV 
 **/ 
  public void
  informGapExistForSubscribeInv(NodeId invReceiver,
                                SubscriptionSet is,
                                VV startVV,
                                VV omitVV){
    Env.printDebug("informGapExistForSubscribeInv");
  }

 /** 
 *  inform Outgoing Checkpoint Stream initiated called in CPSendWorker 
 **/ 
  public void
  informOutgoingCheckpointStreamInitiated(NodeId targetNodeId, 
                                          String cpPath, 
                                          String[] exclChildNames,
                                          VV startVV,
                                          boolean placeholderWriterSet){
    Env.printDebug("informOutgoingCheckpointStreamInitiated");
  }
 /** 
 *  inform Outgoing Checkpoint Stream initiated called in CPSendWorker 
 **/ 
  public void
  informOutgoingCheckpointStreamTerminated(NodeId receiverNodeId,
                                           String cpPath,
                                           String[] exclChildNames,
                                           VV startVV, 
                                           boolean placeholderWriterSet){
    Env.printDebug("informOutgoingCheckpointStreamTerminated");
  }
 /** 
 *  inform a Checkpoint Stream initiated called in CPRecvWorker 
 **/ 
  public void
  informCheckpointStreamInitiated(NodeId senderNodeId, 
                                  String cpPath,
                                  String[] exclChildNames,
                                  VV vvStart,
                                  boolean placeholderWriterSet){
    Env.printDebug("informCheckpointStreamInitiated");
  }

 /** 
 *  inform a Checkpoint Stream terminated called in CPRecvWorker 
 **/ 
  public void
  informCheckpointStreamTerminated(NodeId senderNodeId, 
                                   String cpPath,
                                   String[] exclChildNames,
                                   VV vvStart, 
                                   boolean placeholderWriterSet){
    Env.printDebug("informCheckpointStreamTerminated");
  }

 /** 
 *  inform a Checkpoint Stream apply status called in CPRecvWorker 
 **/ 
  public void
  informCheckpointStreamReceiveStatus(NodeId senderNodeId, 
                                      String cpPath,
                                      String[] exclChildNames,
                                      VV vvStart, 
                                      boolean applyStatus,
                                      boolean placeholderWriterSet){
    Env.printDebug("informCheckpointStreamTerminated"); 
  }

  /*
  //-----------------------------------------------------------------------
  // Get a mailbox for objId that will be signalled when the bytes
  // for that object arrive
  //-----------------------------------------------------------------------
  public synchronized DataArrivalMailbox
  getObjMailbox(ObjId objId){
    this.mbox = new DataArrivalMailbox(objId);
    return(this.mbox);
  }
  */
}
