 /** 
 *  Peform the Nice experiments 
 **/ 
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.EOFException;

public class NiceExptSender{

 /** 
 *  Private data 
 **/ 
  private static final int WAIT_SIGNAL_PORT = 4789;

 /** 
 *  Program staring point 
 **/ 
  public static void
  main(String[] argv){
    int nodeIdInt = 0;
    int algorithm = 0;
    NodeId myNodeId = null;
    URANode uraNode = null;

    if(argv.length == 3){
      // Start URA Node
      nodeIdInt = Integer.parseInt(argv[1]);
      myNodeId = new NodeId(nodeIdInt);
      algorithm = Integer.parseInt(argv[2]);
      uraNode = new URANode(argv[0],
                            myNodeId,
                            Controller.NULL_CONTROLLER,
                            true);
      // Perform initial writes to populate the file system locally
      try{
        NiceExptSender.initialize(uraNode);
      }catch(IOException e){
        e.printStackTrace();
        System.err.println("" + e);
        assert(false);
      }

      // Wait to be woken up; the RMIServer has been started, so the
      // receiver can subscribe to listen to invalidates/updates
      System.err.println("Algorithm = ");
      Constants.printAlgorithm(algorithm);
      System.err.println("Waiting to be woken up on port: " +
                         WAIT_SIGNAL_PORT);
      Synchronizer.waitSignal(WAIT_SIGNAL_PORT);
      System.err.println("Woken up, starting experiment");

      // Issue NUM_FILES writes of FILE_SIZE_BYTES bytes each
      try{
        NiceExptSender.performWrites(uraNode, System.in, algorithm);
      }catch(IOException e){
        System.err.println("" + e);
      }
    }else{
      System.err.println("java NiceExptSender <configFileName> " +
                         "<my node id> <algorithm>");
    }
  }

 /** 
 *  Initialize the sender file system 
 **/ 
  private static void
  initialize(URANode uraNode) throws IOException{
    LocalInterface li = null;
    ExptFileBytes exptFileBytes = null;
    ObjId objId = null;

    li = uraNode.getLocalInterface();
    for(int i = 0; i < Constants.NUM_FILES; i++){
      try{
        exptFileBytes = new ExptFileBytes(-1, Constants.FILE_SIZE_BYTES);
        objId = new ObjId("/" + i);
        li.write(objId,
                 0,
                 Constants.FILE_SIZE_BYTES,
                 Core.DEFAULT_PRIORITY,
                 exptFileBytes.makeImmutableBytes(),
                 true); // Use bound invals when initializing
      }catch(InvalidExptFileBytesException e){
        e.printStackTrace();
        System.err.println("" + e);
        assert(false);
      }
    }
  }

 /** 
 *  Read a trace file and generate events accordingly 
 **/ 
  private static void
  performWrites(URANode uraNode, InputStream is, int algorithm)
    throws IOException{
    LocalInterface li = null;
    boolean done = false;
    BufferedReader br = null;
    TraceEntry traceEntry = null;
    long startTimeMS = 0;
    long exptTimeMS = 0;
    ExptFileBytes exptFileBytes = null;
    boolean useBoundInvals = false;

    useBoundInvals = (algorithm == Constants.PUSH_ALL);
    li = uraNode.getLocalInterface();
    br = new BufferedReader(new InputStreamReader(is));
    startTimeMS = System.currentTimeMillis();
    while(!done){
      try{
        do{
          traceEntry = new TraceEntry(br);
        }while(traceEntry.getOperation() != TraceEntry.WRITE);

        // Found a write operation; wait until we can perform it
        exptTimeMS = System.currentTimeMillis() - startTimeMS;
        while(exptTimeMS < traceEntry.getTimeMS()){
          try{
            Thread.sleep(traceEntry.getTimeMS() - exptTimeMS);
          }catch(InterruptedException e){
            e.printStackTrace();
            System.err.println("" + e);
            assert(false);
          }
          exptTimeMS = System.currentTimeMillis() - startTimeMS;
        }

        // Time to write
        exptFileBytes = new ExptFileBytes(traceEntry.getEventNum(),
                                          Constants.FILE_SIZE_BYTES);
        li.write(traceEntry.getObjId(),
                 0,
                 Constants.FILE_SIZE_BYTES,
                 traceEntry.getPriority(),
                 exptFileBytes.makeImmutableBytes(),
                 useBoundInvals);
      }catch(EOFException e){
        done = true;
      }catch(InvalidExptFileBytesException e){
        e.printStackTrace();
        System.err.println("" + e);
        assert(false);
      }catch(InvalidTraceEntryException e){
        e.printStackTrace();
        System.err.println("" + e);
        assert(false);
      }
    }
  }
}
