/*
 * Simple utility to measure round trip time
 * run Rtt send hostname on sender and Rtt recv on receiver
 */
import java.net.*;
import java.io.*;

public class RTT{
    public static  int port = 17382;
    public static  int sleepMS = 1000;

    private static void printUsage(){
	System.out.println("java RTT [send hostname | recv]");
    }
    public static void main(String arg[]){
	if(arg.length < 1){
	    printUsage();
	    System.exit(-1);
	}
	if(arg[0].equals("recv")){
	    receiver();
	}
	if(arg.length != 2){
	    printUsage();
	    System.exit(-1);
	}
	sender(arg[1]);
    }

    public static void receiver(){
	System.out.println("I am the receiver on port " + port + "\n");
	try{
	    ServerSocket ss = new ServerSocket(port);
	    Socket s = ss.accept();
	    s.setTcpNoDelay(true);
	    InputStream is = s.getInputStream();
	    OutputStream os = s.getOutputStream();
	    while(true){
		byte b[] = new byte[1];
		int got = is.read(b);
		if(got != 1){
		    System.out.println("Whaa?\n");
		    System.exit(-1);
		}
		os.write(b);
		os.flush();
	    }
	}
	catch(Exception e){
	    e.printStackTrace();
	    System.out.println("Exception: " + e.toString());
	}
    }

    public static void sender(String recvr){
	System.out.println("# I am the Sender to " + recvr + "\n");
	System.out.println("# time_since_start rtt\n");
	try{
	    InetAddress ip = InetAddress.getByName(recvr);
	    Socket s = new Socket(ip, port);
	    InputStream is = s.getInputStream();
	    OutputStream os = s.getOutputStream();
	    byte b[] = new byte[1];
	    b[0] = 42;
	    long sent, recv;
	    long start = System.currentTimeMillis();
	    while(true){
		Thread.sleep(sleepMS);
		sent = System.currentTimeMillis();
		os.write(b);
		os.flush();
		int got = is.read(b);
		if(got != 1){
		    System.out.println("Whaa?\n");
		    System.exit(-1);
		}
		recv = System.currentTimeMillis();
		System.out.println(sent - start + " " + (recv - sent));
	    }
	}
	catch(Exception e){
	    e.printStackTrace();
	    System.out.println("Exception: " + e.toString());
	}

    }
}
