 /** 
 *  Used to synchronize starting experiments 
 **/ 
import java.net.Socket;
import java.net.ServerSocket;
import java.io.InputStream;
import java.io.DataInputStream;
import java.io.OutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Synchronizer{

 /** 
 *  Data members 
 **/ 
  private static final short MAGIC_NUMBER = 17;

 /** 
 *  Create a socket and wait to be woken up 
 **/ 
  public static void
  waitSignal(int portNum){
    Socket sock = null;
    ServerSocket ss = null;
    InputStream is = null;
    DataInputStream dis = null;
    short val = 0;

    try{
      ss = new ServerSocket(portNum);
      sock = ss.accept();
      is = sock.getInputStream();
      dis = new DataInputStream(is);
      val = dis.readShort();
      assert(val == MAGIC_NUMBER);
    }catch(IOException e){
      System.err.println("" + e);
      e.printStackTrace();
      assert(false);
    }finally{
      try{
        // close() closes all channels as well
        sock.close();
      }catch(IOException e){
        // Do nothing here
      }
    }
  }

 /** 
 *  Wake node <nodeName> 
 **/ 
  public static void
  wakeNode(String nodeName, int portNum){
    Socket sock = null;
    OutputStream os = null;
    DataOutputStream dos = null;

    try{
      sock = new Socket(nodeName, portNum);
      sock.setTcpNoDelay(true);
      os = sock.getOutputStream();
      dos = new DataOutputStream(os);
      dos.writeShort(MAGIC_NUMBER);
      dos.flush();
    }catch(IOException e){
      System.err.println("Could not wake node " + nodeName + ":" + e);
      e.printStackTrace();
    }finally{
      try{
        // close() closes all open channels as well
        sock.close();
      }catch(IOException e){
        // Do nothing here
      }
    }
  }

 /** 
 *  Wake all sleeping sockets 
 **/ 
  public static void
  main(String[] argv){
    assert((argv.length % 2) == 0);

    for(int i = 0; i < argv.length; i += 2){
      Synchronizer.wakeNode(argv[i], Integer.parseInt(argv[i + 1]));
    }
  }
}
