 /** 
 *  Global Coordinator 
 *  Read scripts from standard input 
 *  Currently have 4 kinds of commands: subscribe, subscribeBody, 
 *                                      issueDemandRead, and sleep 
 **/ 
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.BufferedWriter;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.HashMap;
import java.util.Random;
import java.util.Vector;

public class PartialReplication extends CoordExptA
{
  public static long SUBSCRIPTION_DURATION_MS = 1000000;  // 1000 seconds
  public static long MAX_DELAY_MS = 1000; // 1 second
  AcceptStamp asAfterWrite;

 /** 
 *  Constructor 
 **/ 
  public PartialReplication(String exptConfigFileName, String shellType_){
    super(exptConfigFileName, shellType_);
    asAfterWrite = null;
  }
  
  public SubscriptionSet getSubscriptionSet(double percentage){
    SubscriptionSet dis = null;
    if (percentage == 1){//100%
      dis = SubscriptionSet.makeSubscriptionSet(":/*");

    } else if(percentage == 0.1){//10%
      dis = SubscriptionSet.makeSubscriptionSet("/0/*");
      
    } else if(percentage == 0.2){//20%
      String[] dirStrs = new String[2];
      dirStrs[0] = "/0/*";
      dirStrs[1] = "/1/*";
      dis = SubscriptionSet.makeSubscriptionSet(dirStrs);
      
    } else if(percentage == 0.4){//40%
      //dis = SubscriptionSet.makeSubscriptionSet("/0/*:/1/*:/2/*:/3/*");
      String[] dirStrs = new String[4];
      dirStrs[0] = "/0/*";
      dirStrs[1] = "/1/*";
      dirStrs[2] = "/2/*";
      dirStrs[3] = "/3/*";
      dis = SubscriptionSet.makeSubscriptionSet(dirStrs);
      
    } else if(percentage == 0.8){//80%
        
      //dis = SubscriptionSet.makeSubscriptionSet("/0/*:/1/*:/2/*:/3/*:/4/*:/5/*:/6/*:/7/*");
      String[] dirStrs = new String[8];
      dirStrs[0] = "/0/*";
      dirStrs[1] = "/1/*";
      dirStrs[2] = "/2/*";
      dirStrs[3] = "/3/*";
      dirStrs[4] = "/4/*";
      dirStrs[5] = "/5/*";
      dirStrs[6] = "/6/*";
      dirStrs[7] = "/7/*";
      dis = SubscriptionSet.makeSubscriptionSet(dirStrs);
    } else if(percentage == 0.01){//1%
      dis = SubscriptionSet.makeSubscriptionSet("/0/0/*");
    } else if(percentage == 0.001){//0.1%
      dis = SubscriptionSet.makeSubscriptionSet("/0/0/0/*");
    } else{
      assert false; // not implemented yet.
    }
    return(dis);
  }
  
  //-------------------------------------------------------------------
  // customize the registered interestset per node in local-ufs-PR.config
  // file. return the corresponding nodeId for specified percentage.
  //-------------------------------------------------------------------
  public int getNodeNum(double percentage){
    
    if (percentage == 1){//100%
      //dis = SubscriptionSet.makeSubscriptionSet(":/*");
      return 20;
    } else if(percentage == 0.1){//10%
      //dis = SubscriptionSet.makeSubscriptionSet("/0/*");
      return 15;
    } else if(percentage == 0.2){//20%
      //String[] dirStrs = new String[2];
      //dirStrs[0] = "/0/*";
      //dirStrs[1] = "/1/*";
      //dis = SubscriptionSet.makeSubscriptionSet(dirStrs);
      return 16;
    } else if(percentage == 0.4){//40%
      //dis = SubscriptionSet.makeSubscriptionSet("/0/*:/1/*:/2/*:/3/*");
      return 17;
      
    } else if(percentage == 0.8){//80%
        
      //dis = SubscriptionSet.makeSubscriptionSet("/0/*:/1/*:/2/*:/3/*:/4/*:/5/*:/6/*:/7/*");
      return 18;
    } else if(percentage == 0.01){//1%
      //dis = SubscriptionSet.makeSubscriptionSet("/0/0/*");
      return 14;
    } else if(percentage == 0.001){//0.1%
      //dis = SubscriptionSet.makeSubscriptionSet("/0/0/0/*");
      return 13;
    } else{
      assert false; // not implemented yet.
      return -1;
    }
    //return(dis);
  }

  //-----------------------------------------------------------------------
  // Demand Read the required percentage of files one by one and return the
  // last file demandReaded so that for experiments we know when it's over
  //-----------------------------------------------------------------------
  public String demandReadPartialFiles(int supplierNodeId, 
                                       int receiverNodeId, 
                                       long numTotalFiles,
                                       double percentage,
                                       long fileSize){
    String fileName = null;
    long numFiles = Math.round(numTotalFiles * percentage);
    for(long i = 0; i < numFiles; i++){
      fileName = this.senderScriptGen.createFileName(i, numTotalFiles);
      this.issueDemandRead(supplierNodeId,
                           receiverNodeId,
                           fileName,
                           0,
                           fileSize,
                           i);
    }
    return fileName;
  }
  //----------------------------------------------------
  // case 1. full replication
  //----------------------------------------------------
  public long fullRepl(int initiater,
		       int subscriber){
    CoordCommPacket ccp = null;
    StatsRecord initStats = null;
    StatsRecord finalStats = null;
    StatsRecord diffStats = null;
    SubscriptionSet dis = null;
        
    long numFiles = 10000;  
    long fileSize = 1000; //1kB
    long start, end;
    double avgMS;
      
    String lastFile = null;
    int[] nodeList = new int[2];
      
    nodeList[0] = initiater;
    nodeList[1] = subscriber;
    asAfterWrite = null;
    this.restartRMIRegistrySync();
       
    this.startNode(initiater);
    this.startNode(subscriber);
    this.waitStartNode(initiater);
    this.waitStartNode(subscriber);

    initStats = this.getStats(nodeList);
    //Write all files with bound inval
    this.sendPopulateFullScript(initiater, 
                                true, //bound
                                numFiles, //numFiles
                                fileSize);   // file size

    ccp = this.recv(initiater);
    assert(ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
    assert(ccp.getData() instanceof AcceptStamp);
        
    asAfterWrite = (AcceptStamp)ccp.getData();

    dis = SubscriptionSet.makeSubscriptionSet(":/*");

    this.issueSubscribe(initiater,
                        subscriber,
                        AcceptVV.makeVVAllNegatives(),

                        dis,
                        SUBSCRIPTION_DURATION_MS,
                        MAX_DELAY_MS);
    this.sendSync(subscriber, asAfterWrite);
    ccp = this.recv(subscriber);
    assert(ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
    assert(ccp.getData() == null);
    System.err.println("Received a SYNC_DONE");
    // post condition:
    // Sender and receiver have synchronized for the first initial
    // sequential writes.
        
    finalStats = this.getStats(nodeList);
    diffStats = finalStats.getDiff(initStats);
    System.out.println("-------------CASE 1 Full Replication-----------");
    System.out.println(diffStats);

    // kill the nodes
    System.out.println("Exit value for node " + initiater+" =" 
                       + this.killNode(initiater));
    System.out.println("Exit value for node " + subscriber+" = " 
                       + this.killNode(subscriber));
    asAfterWrite = null;
    return diffStats.getTotal();
  }
    
  //----------------------------------------------------------------
  // Case 2 separate data from metadata
  //        do the same thing as above except that now
  //        (1) the sender writes with unbound inval
  //        (2) the receiver subscribes all files for invals and 
  //            gets data by demandread partial files. 
  // note: to save time, case 3 i.e. the next method will share
  //       the same initiater as in this one. therefor, we don't
  //       kill the initiater node at the end of this method.
  //----------------------------------------------------------------
  public long partialRepl(int initiater, 
                          int subscriber,
                          double percentage){

    CoordCommPacket ccp = null;
    StatsRecord initStats = null;
    StatsRecord finalStats = null;
    StatsRecord diffStats = null;
    SubscriptionSet dis = null;
        
    long numFiles = 10000;  
    long fileSize = 1000; //1kB
    long start, end;
    double avgMS;
    
    String lastFile = null;
    asAfterWrite = null;
    int[] nodeList = new int[2];
    nodeList[0] = initiater;
    nodeList[1] = subscriber;
    this.restartRMIRegistrySync();
       
    this.startNode(initiater);
    this.startNode(subscriber);
    this.waitStartNode(initiater);
    this.waitStartNode(subscriber);

    initStats = this.getStats(nodeList);
      
    //Write all files with unbound inval
    this.sendPopulateFullScript(initiater, 
                                false, //bound
                                numFiles, //numFiles
                                fileSize);   // file size
      
      
    ccp = this.recv(initiater);
    assert(ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
    assert(ccp.getData() instanceof AcceptStamp);
        
    asAfterWrite = (AcceptStamp)ccp.getData();

    this.issueSubscribe(initiater,
                        subscriber,
                        AcceptVV.makeVVAllNegatives(),
                        
                        SubscriptionSet.makeSubscriptionSet(":/*"),
                        SUBSCRIPTION_DURATION_MS,
                        MAX_DELAY_MS);
    this.sendSync(subscriber, asAfterWrite);
    ccp = this.recv(subscriber);
    assert(ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
    assert(ccp.getData() == null);
    System.err.println("Received a SYNC_DONE");
      
    //
    // demand Read the interested x percentage of files
    //
    lastFile = this.demandReadPartialFiles(initiater,
                                           subscriber,
                                           numFiles,
                                           percentage,
                                           fileSize);
    //System.err.println("111111111");
    //read the last demanded file to make sure 
    // that all the demanded files arrive.
    this.sendRead(subscriber, lastFile, 0, fileSize);
    //System.err.println("222222222");
    ccp = this.recv(subscriber);
    //System.err.println("333333333333");
    assert(ccp.getSignalType() == CoordCommPacket.READ_DONE);
    assert(ccp.getData() instanceof AcceptStamp);
        	
    finalStats = this.getStats(nodeList);
    diffStats = finalStats.getDiff(initStats);
    System.out.println("---------CASE 2 Subscribe all inval --------------");
    System.out.println("percentage = " + percentage + ":\n" + diffStats);
      
    System.out.println("Exit value for node " + subscriber+" = " 
                       + this.killNode(subscriber));
    return diffStats.getTotal();
  }

  //---------------------------------------------------------
  // Case 3 Separate data from metadata + imprecise inval
  //        start a new node to just subscribe x% of files
  // Note: to save time, we share the same initiater as case 2
  //       therefore, assume initiater is the same as above method
  //       and the node is not killed in case 2 , we don't 
  //       have to repopulate the data again for the initiater
  //---------------------------------------------------------
  public long partialReplWithImprecise(int initiater,
                                       int subscriber,
                                       double percentage){
    //System.err.println("4444444444");
    CoordCommPacket ccp = null;
    StatsRecord initStats = null;
    StatsRecord finalStats = null;
    StatsRecord diffStats = null;
    SubscriptionSet dis = null;
        
    long numFiles = 10000;  
    long fileSize = 1000; //1kB
    long start, end;
    double avgMS;
    
    String lastFile = null;
    assert asAfterWrite!=null;//should be the value from partialRepl
    int[] nodeList = new int[2];
    nodeList[0] = initiater;
    nodeList[1] = subscriber;
    //this.restartRMIRegistrySync();
       
    //this.startNode(initiater);
    this.startNode(subscriber);
    //this.waitStartNode(initiater);
    this.waitStartNode(subscriber);

    initStats = this.getStats(nodeList);
      
    this.issueSubscribe(initiater,
                        subscriber,
                        AcceptVV.makeVVAllNegatives(),
                        
                        this.getSubscriptionSet(percentage),
                        SUBSCRIPTION_DURATION_MS,
                        MAX_DELAY_MS);
    //System.err.println("77777777777777777777");
    this.sendSync(subscriber, asAfterWrite);
    //System.err.println("888888888888888888888");
    ccp = this.recv(subscriber);
    //System.err.println("999999999999999999999999");
    assert(ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
    assert(ccp.getData() == null);
    //System.err.println("Received third SYNC_DONE");
        
    lastFile = this.demandReadPartialFiles(initiater,
                                           subscriber,
                                           numFiles,
                                           percentage,
                                           fileSize);
    //System.err.println("111111111");
    //read the last demanded file to make sure 
    // that all the demanded files arrive.
    this.sendRead(subscriber, lastFile, 0, fileSize);
    //System.err.println("222222222");
    ccp = this.recv(subscriber);
    //System.err.println("333333333333");
    assert(ccp.getSignalType() == CoordCommPacket.READ_DONE);
    assert(ccp.getData() instanceof AcceptStamp);
        	
    finalStats = this.getStats(nodeList);
    diffStats = finalStats.getDiff(initStats);
    System.out.println("------------CASE 3 Subscribe x% inval -------------");
    System.out.println("percentage = " + percentage + ":\n" + diffStats);
    
    System.out.println("Exit value for node " + initiater+" =" 
                       + this.killNode(initiater));
    System.out.println("Exit value for node " + subscriber+" = " 
                       + this.killNode(subscriber));
    return diffStats.getTotal();
  }

  //-----------------------------------------------------------------------
  // Program starting point
  //-----------------------------------------------------------------------
  public static void main(String[] argv)
    {
      PartialReplication coord = null;

      if (argv.length < 3){
        System.out.println("Usage: <exptConfigfile> <shellType> <percentage> <datafileName>");
        System.exit(-1);
      }
      coord = new PartialReplication(argv[0], argv[1]);
      double percentage = new Double(argv[2]).doubleValue();
      //String dataFileName = System.getProperty("user.dir")+"/experiments/sosp/results/PR.data";
      String dataFileName = argv[3];
      String fullDataFileName = dataFileName +".full";

      long full = 0;
      if (percentage == 0.001) {// to save time, we just run full for first percentage
        full = coord.fullRepl(9, 10);
        try{
          BufferedWriter bwFull = new BufferedWriter(new FileWriter(fullDataFileName, false));
          assert bwFull!=null;
          String data = full  + "\n"; 
          bwFull.write(data, 0, data.length());
          bwFull.flush();
          
        } catch (Exception e){
          
          e.printStackTrace();
          assert(false);
        }
      }else{
        //read full from file
        try{
          BufferedReader in = new BufferedReader(new FileReader(fullDataFileName));
          assert in!=null;
          String line = in.readLine();
          full = new Long(line).longValue();
          assert full>0;
          
        }catch (Exception e){
          
          e.printStackTrace();
          assert(false);
        }
      }

      long pr1 = coord.partialRepl(11, 12, percentage);
      long pr2 = coord.partialReplWithImprecise(11, coord.getNodeNum(percentage), percentage); //note the first node has to be 11
      try{
        BufferedWriter bw = new BufferedWriter(new FileWriter(dataFileName, true));
        assert bw!=null;
        String data = percentage*100 +" " + full// x
          +" " + pr1  
          +" " + pr2
          + "\n"; 
        bw.write(data, 0, data.length());
        bw.flush();
      
      } catch (Exception e){
        
        e.printStackTrace();
        assert(false);
      }
	  
    }
}

//---------------------------------------------------------------------------
// $Log: PartialReplication.java,v $
// Revision 1.5  2005/03/15 21:15:35  zjiandan
// Automatic GC checked in.
//
// Revision 1.4  2005/03/03 20:25:10  zjiandan
// minor bugs fixed.
//
// Revision 1.3  2005/03/02 21:44:07  zjiandan
// Modified to work with new code
//
// Revision 1.2  2005/02/28 20:26:00  zjiandan
// Added Garbage Collection code and part of Checkpoint exchange protocol code
//
// Revision 1.1  2005/01/13 20:55:41  zjiandan
// Reorganized sosp experiments files into sosp subdirectory under experiments.
//
// Revision 1.1  2005/01/10 03:50:30  zjiandan
// Source files for the first three Experiments.
//
//---------------------------------------------------------------------------
