import java.io.IOException;
import java.io.EOFException;

public class BFSExpDriver extends PLExpDriver{

  public BFSExpDriver(long chunk, long chunk_size, long interInput, int interInputCount, long output, int treeWidth, URANode n){
    super(chunk, chunk_size, interInput, interInputCount, output, treeWidth, n);
  }
 
  public void synchResults(){
    int[] otherNodes = Config.getNodesExclusive(0);
    
    for(int i=otherNodes.length-1; i>=0; i--){
      if(otherNodes[i] < 4){
        ObjId[] objId = new ObjId[1];
        objId[0] = new ObjId("/00/" + otherNodes[i]);
        waitForFiles(objId, 0, outputSize, otherNodes[i], otherNodes[i], (int)exeChunk+interFileCount);
      }
    }
   

//    for(int i=0; i<otherNodes.length; i++){
    for(int i=otherNodes.length-1; i>=0; i--){
      if(otherNodes[i] >= 4){
        String[] s = new String[1];
        s[0] = new String("/*");
        SubscriptionSet set = SubscriptionSet.makeSubscriptionSet(s);
        RMIClient rmiClient = new RMIClient();
        try{
          CounterVV startVV = new CounterVV(node.getCurrentVV());
          rmiClient.subscribe(set, startVV,
                              new NodeId(otherNodes[i]), new NodeId(localId), 
                              Config.getDNS(new NodeId(localId)), 
                              Config.getPortInval(new NodeId(localId)),
                              SUBSCRIPTION_TIMEOUT_MS, MAX_FORCE_MS, MAX_DELAY_MS);
        } catch(Exception e){
          e.printStackTrace();
        }
      }
    }

    for(int i=otherNodes.length-1; i>=0; i--){
        if(otherNodes[i] >= 4){
          ObjId[] objId = new ObjId[1];
          objId[0] = new ObjId("/00/" + otherNodes[i]);
          waitForFiles(objId, 0, outputSize, otherNodes[i], otherNodes[i], (int)exeChunk+interFileCount);
        }
    }
  }

  public void produceResult(){
    if(localId < 4){
      String[] s = new String[1];
      s[0] = new String("/*");
      SubscriptionSet set = SubscriptionSet.makeSubscriptionSet(s);
      RMIClient rmiClient = new RMIClient();
      try{
        CounterVV startVV = new CounterVV(AcceptVV.makeVVAllNegatives());
        startVV.setStampByServer(new NodeId(0), exeChunk-1);
        rmiClient.subscribe(set, startVV,
                            new NodeId(localId), new NodeId(0), 
                            Config.getDNS(new NodeId(0)), 
                            Config.getPortInval(new NodeId(0)),
                            SUBSCRIPTION_TIMEOUT_MS, MAX_FORCE_MS, MAX_DELAY_MS);
      } catch(Exception e){
        e.printStackTrace();
      }
    }
    super.produceResult();
  }

  protected boolean getInitWriteType(){
    return true;
  }

  protected boolean getInterWriteType(){
    return true;
  }

  protected boolean getResultWriteType(){
    return true;
  }

  protected String getResultSet(){
    return "/*";
  }

  protected void issueBody(ObjId id,
                           long offset,
                           long length,
                           long requestId, 
                           NodeId supplierNodeId,
                           NodeId readerNodeId,
                           String readerNodeDNS,
                           int readerPortBody, 
                           RMIClient rmiClient) 
    throws RMINetworkException, RMIApplicationException,
    ObjNotFoundException, IOException, ReadOfInvalidRangeException,
    EOFException{
  }
  
  protected void waitForFiles(ObjId[] oids, int offset, long length, int writer, int supplier, int as){
    NodeId wid = new NodeId(writer);
    LocalInterface li = node.getLocalInterface();
    long hint = as;
//    try{
//      hint = node.getCurrentVV().getStampByServer(wid);
//      if(hint < 0){ // We shall receive at least one inval before reading the body
//        System.out.println("waiting for inval " + 0 + " to arrive from " + sid);
//      System.out.println(node.getCurrentVV());
//        hint = 0;
//      }
//    } catch (Exception nsee){
//      assert false;
//    }
    
    BodyMsg bm = null;
    for(int i=0; i<oids.length; i++){
      long localHint = hint;
      while(bm == null){
        try{
//          System.out.println("About to read object: " + oids[i]);
//          System.out.println("Sync on: " + new AcceptStamp(localHint, wid));
          li.sync(new AcceptStamp(localHint, wid));

          bm = li.readBlockInvalid(oids[i], offset, length, true);
        } catch (ObjNotFoundException onfe){
//          System.out.println("Inval hasn't arrived yet, try it again.");
          //hint++;
        } catch (Exception e){
          e.printStackTrace();
          assert false;
        }
        //localHint ++;
      }
      System.out.println("Received: " + oids[i]);
      bm = null;
    }
  }
  
  /*********** main ***********/
  
  public static void main(String[] argv){
    URANode n = new URANode(argv[0], null, Controller.NULL_CONTROLLER, false);
    System.out.println((int)Config.getMyNodeId().getIDint());
    long chk = (new Long(argv[1])).longValue();
    long chksz = (new Long(argv[2])).longValue();
    long iip = (new Long(argv[3])).longValue();
    int ic = (new Integer(argv[4])).intValue();
    long op = (new Long(argv[5])).longValue();
    int tw = (new Integer(argv[6])).intValue();
    int sid = (int)Config.getMyNodeId().getIDint();
    BarrierClient bc = new BarrierClient("borage.cs.utexas.edu", 9494, sid);

//    assert ic < tw;
    
    BFSExpDriver bfsDriver = new BFSExpDriver(chk, chksz, iip, ic, op, tw, n);
    bfsDriver.runExp(bc);
  }
}
